/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;

public class BSProperties
extends Properties {
    private static final long serialVersionUID = 8813061313728932325L;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        this.store0(new BufferedWriter(new OutputStreamWriter(out, "8859_1")), comments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bw2, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            BSProperties.writeComments(bw2, comments);
        }
        bw2.write("# " + new Date().toString());
        bw2.newLine();
        BSProperties bSProperties = this;
        synchronized (bSProperties) {
            ArrayList<Object> list = Collections.list(this.keys());
            Collections.sort(list);
            for (Object e2 : list) {
                String key = (String)e2;
                String val = (String)this.get(key);
                key = this.saveConvert(key, true, escUnicode);
                val = this.saveConvert(val, false, escUnicode);
                bw2.write(key + "=" + val);
                bw2.newLine();
            }
        }
        bw2.flush();
    }

    private static void writeComments(BufferedWriter bw2, String comments) throws IOException {
        int current;
        bw2.write("# ");
        int len = comments.length();
        int last = 0;
        char[] uu2 = new char[6];
        uu2[0] = 92;
        uu2[1] = 117;
        for (current = 0; current < len; ++current) {
            char c2 = comments.charAt(current);
            if (c2 <= '\u00ff' && c2 != '\n' && c2 != '\r') continue;
            if (last != current) {
                bw2.write(comments.substring(last, current));
            }
            if (c2 > '\u00ff') {
                uu2[2] = BSProperties.toHex(c2 >> 12 & 0xF);
                uu2[3] = BSProperties.toHex(c2 >> 8 & 0xF);
                uu2[4] = BSProperties.toHex(c2 >> 4 & 0xF);
                uu2[5] = BSProperties.toHex(c2 & 0xF);
                bw2.write(new String(uu2));
            } else {
                bw2.newLine();
                if (c2 == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw2.write("# ");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw2.write(comments.substring(last, current));
        }
        bw2.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x2 = 0; x2 < len; ++x2) {
            char aChar = theString.charAt(x2);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x2 == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(BSProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(BSProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(BSProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(BSProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }
}

