/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.util.Coord;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;

public final class CommonUtils {
    public static boolean isStringAllLettersOrDigits(CharSequence s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (Character.isLetterOrDigit(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isItemInList(int id2, int md2, String list) {
        if (list.trim().length() != 0) {
            String[] items;
            for (String item : items = list.split(";")) {
                String[] values = item.split(",");
                if (CommonUtils.parseInt(values[0]) != id2) continue;
                if (values.length == 1) {
                    return true;
                }
                if (values.length != 2 || CommonUtils.parseInt(values[1]) != md2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isIDInList(int id2, int md2, String list) {
        String[] itemArray = list.split(";");
        for (int i2 = 0; i2 < itemArray.length; ++i2) {
            String[] values = itemArray[i2].split(",");
            int tempID = CommonUtils.parseInt(values[0], Integer.MAX_VALUE);
            if (tempID == Integer.MAX_VALUE) continue;
            if (values.length > 1 && CommonUtils.parseInt(values[1], -1) == md2) {
                return true;
            }
            if (tempID != id2) continue;
            return true;
        }
        return false;
    }

    public static boolean isIDInList(int id2, String list) {
        return CommonUtils.isIDInList(id2, -1, list);
    }

    public static int[][][] stringToGroups(String string) {
        String[] groups;
        ArrayList<int[][]> groupList = new ArrayList<int[][]>();
        for (String group : groups = string.split(";")) {
            groupList.add(CommonUtils.stringToGroup(group));
        }
        int[][][] res = new int[groupList.size()][][];
        for (int i2 = 0; i2 < groupList.size(); ++i2) {
            res[i2] = (int[][])groupList.get(i2);
        }
        return res;
    }

    public static int[][] stringToGroup(String string) {
        String[] blocks;
        ArrayList<int[]> blockList = new ArrayList<int[]>();
        for (String block : blocks = string.split(">")) {
            blockList.add(CommonUtils.stringToBlock(block));
        }
        int[][] res = new int[blockList.size()][];
        for (int i2 = 0; i2 < blockList.size(); ++i2) {
            res[i2] = (int[])blockList.get(i2);
        }
        return res;
    }

    public static int[] stringToBlock(String string) {
        int[] values = new int[]{0, -1};
        String[] src = string.split(",");
        if (src.length < 1) {
            return values;
        }
        values[0] = CommonUtils.parseInt(src[0]);
        if (src.length < 2) {
            return values;
        }
        values[1] = CommonUtils.parseInt(src[1]);
        return values;
    }

    public static boolean isBlockInGroups(int[] block, int[][][] groups) {
        for (int[][] group : groups) {
            if (CommonUtils.indexOfBlock(block, group) <= -1) continue;
            return true;
        }
        return false;
    }

    public static int indexOfBlock(int[] block, int[][] group) {
        for (int i2 = 0; i2 < group.length; ++i2) {
            if (block[0] != group[i2][0] || group[i2][1] != -1 && block[1] != group[i2][1]) continue;
            return i2;
        }
        return -1;
    }

    public static int[][] getRelatedBlocks(int[] block, int[][][] groups) {
        ArrayList<int[]> blockList = new ArrayList<int[]>();
        for (int[][] group : groups) {
            if (CommonUtils.indexOfBlock(block, group) <= -1) continue;
            for (int i2 = 0; i2 < groups.length; ++i2) {
                if (blockList.contains(group[i2])) continue;
                blockList.add(i2, group[i2]);
            }
        }
        int[][] secondary = new int[blockList.size()][];
        for (int i3 = 0; i3 < blockList.size(); ++i3) {
            secondary[i3] = (int[])blockList.get(i3);
        }
        return secondary;
    }

    public static int smallerBlockIndex(int[] block, int[][][] groups) {
        int min = Integer.MAX_VALUE;
        for (int[][] group : groups) {
            int i2 = CommonUtils.indexOfBlock(block, group);
            if (i2 <= -1 || i2 >= min) continue;
            min = i2;
        }
        if (min == Integer.MAX_VALUE) {
            min = -1;
        }
        return min;
    }

    public static boolean isMetadataNull(int id2, int[][][] groups) {
        int[][][] arr$ = groups;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[][] group;
            for (int[] block : group = arr$[i$]) {
                if (block[0] != id2 || block[1] != -1) continue;
                return true;
            }
        }
        return false;
    }

    public static int sqr(int value) {
        return value * value;
    }

    public static float sqr(float value) {
        return value * value;
    }

    public static int parseInt(String string) {
        return CommonUtils.parseInt(string, 0);
    }

    public static int parseInt(String string, int defaultValue) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException ex2) {
            return defaultValue;
        }
    }

    public void playAtPitch(int i2, aab world, sq entityplayer) {
        float f2 = (float)Math.pow(2.0, (double)(i2 - 12) / 12.0);
        world.a((mp)entityplayer, "note.pling", 0.5f, f2);
    }

    public static int getHighestGroundBlock(aab world, int x2, int y2, int z2) {
        while (y2 > 0 && (world.c(x2, y2, z2) || !world.u(x2, y2, z2) || world.a(x2, y2, z2) == apa.N.cz)) {
            --y2;
        }
        return y2;
    }

    public static int getFirstNonAirBlockFromTop(aab world, int x2, int z2) {
        int y2;
        for (y2 = world.R(); world.c(x2, y2 - 1, z2) && y2 > 0; --y2) {
        }
        return y2;
    }

    public static int getSphericalDistance(Coord startPos, Coord endPos) {
        return (int)Math.round(Math.sqrt(CommonUtils.sqr(endPos.x - startPos.x) + CommonUtils.sqr(endPos.z - startPos.z) + CommonUtils.sqr(endPos.y - startPos.y)));
    }

    public static int getCubicDistance(Coord startPos, Coord endPos) {
        return Math.abs(endPos.x - startPos.x) + Math.abs(endPos.y - startPos.y) + Math.abs(endPos.z - startPos.z);
    }

    public static double getDistanceRatioToCenter(int point1, int point2, int pos) {
        double radius = (double)Math.abs(point2 - point1) / 2.0;
        double dar = Math.abs((double)Math.abs(pos - point1) - radius);
        return radius != 0.0 ? dar / radius : 0.0;
    }

    public static void setHugeMushroom(aab world, Random random, int x2, int y2, int z2, int id2) {
        int w2 = 3;
        int cw2 = 4;
        int h2 = 4;
        CommonUtils.fillWithBlocks(world, x2 - w2 + 1, y2, z2 - w2, x2 + w2 - 1, y2 + h2 - 1, z2 - w2, id2, 10);
        CommonUtils.fillWithBlocks(world, x2 - w2 + 1, y2, z2 + w2, x2 + w2 - 1, y2 + h2 - 1, z2 + w2, id2, 10);
        CommonUtils.fillWithBlocks(world, x2 - w2, y2, z2 - w2 + 1, x2 - w2, y2 + h2 - 1, z2 + w2 - 1, id2, 10);
        CommonUtils.fillWithBlocks(world, x2 + w2, y2, z2 - w2 + 1, x2 + w2, y2 + h2 - 1, z2 + w2 - 1, id2, 10);
        CommonUtils.fillWithBlocksRounded(world, x2 - cw2, y2 + h2, z2 - cw2, x2 + cw2, y2 + h2, z2 + cw2, id2, 14);
    }

    public static void fillWithBlocks(aab world, int x1, int y1, int z1, int x2, int y2, int z2, int id2, int damage) {
        for (int x3 = x1; x3 <= x2; ++x3) {
            for (int y3 = y1; y3 <= y2; ++y3) {
                for (int z3 = z1; z3 <= z2; ++z3) {
                    world.f(x3, y3, z3, id2, damage, 3);
                }
            }
        }
    }

    public static void fillWithBlocksRounded(aab world, int x1, int y1, int z1, int x2, int y2, int z2, int id2, int damage) {
        for (int x3 = x1; x3 <= x2; ++x3) {
            for (int y3 = y1; y3 <= y2; ++y3) {
                for (int z3 = z1; z3 <= z2; ++z3) {
                    double zd2;
                    double yd2;
                    double xd2 = CommonUtils.getDistanceRatioToCenter(x1, x2, x3);
                    if (!(xd2 * xd2 + (yd2 = CommonUtils.getDistanceRatioToCenter(y1, y2, y3)) * yd2 + (zd2 = CommonUtils.getDistanceRatioToCenter(z1, z2, z3)) * zd2 <= 1.5)) continue;
                    world.f(x3, y3, z3, id2, damage, 3);
                }
            }
        }
    }

    public static boolean isGamePaused(Minecraft mc2) {
        return mc2.s != null && (mc2.s.f() || mc2.s instanceof bkf);
    }

    public static String getMCTimeString(long worldTime, long fmt) {
        long HH = (int)((worldTime / 1000L + 6L) % 24L);
        int MM = (int)((double)(worldTime % 1000L) / 1000.0 * 60.0);
        boolean am2 = HH < 12L;
        String hour = "";
        hour = fmt == 24L ? (HH < 10L ? "0" : "") + String.valueOf(HH) : String.valueOf(HH == 0L ? 12L : (HH %= fmt));
        String min = (MM < 10 ? "0" : "") + String.valueOf(MM);
        return hour + ":" + min + (fmt == 12L ? (am2 ? "AM" : "PM") : "");
    }

    public static String ticksToTimeString(long ticks) {
        long secs = ticks / 20L;
        long mins = secs / 60L;
        long hrs = mins / 60L;
        long days = hrs / 24L;
        String time = "";
        if (days > 0L) {
            time = days + ":";
        }
        if (hrs > 0L) {
            time = time + (hrs % 24L < 10L && days > 0L ? "0" : "") + hrs % 24L + ":";
        }
        time = mins > 0L ? time + (mins % 60L < 10L && hrs > 0L ? "0" : "") + mins % 60L + ":" : time + "0:";
        time = time + (secs % 60L < 10L ? "0" : "") + secs % 60L;
        return time;
    }

    public static String stringArrayToString(String[] sa2) {
        return CommonUtils.stringArrayToString(sa2, "#");
    }

    public static String stringArrayToString(String[] sa2, String separator) {
        String ret = "";
        for (String s2 : sa2) {
            ret = ret + separator + " " + s2;
        }
        return ret.replaceFirst(separator + " ", "");
    }

    public static String[] loadTextFromURL(URL url, Logger logger) {
        return CommonUtils.loadTextFromURL(url, logger, new String[]{""}, 1000);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, int timeoutMS) {
        return CommonUtils.loadTextFromURL(url, logger, new String[]{""}, timeoutMS);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, String defaultValue) {
        return CommonUtils.loadTextFromURL(url, logger, new String[]{defaultValue}, 1000);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, String defaultValue, int timeoutMS) {
        return CommonUtils.loadTextFromURL(url, logger, new String[]{defaultValue}, timeoutMS);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, String[] defaultValue) {
        return CommonUtils.loadTextFromURL(url, logger, defaultValue, 1000);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, String[] defaultValue, int timeoutMS) {
        ArrayList<String> arraylist = new ArrayList<String>();
        Scanner scanner = null;
        try {
            URLConnection uc2 = url.openConnection();
            uc2.setReadTimeout(timeoutMS);
            uc2.setConnectTimeout(timeoutMS);
            scanner = new Scanner(uc2.getInputStream(), "UTF-8");
        }
        catch (Throwable e2) {
            logger.log(Level.WARNING, String.format("Error retrieving remote string value! Defaulting to %s", CommonUtils.stringArrayToString(defaultValue)));
            return defaultValue;
        }
        while (scanner.hasNextLine()) {
            arraylist.add(scanner.nextLine());
        }
        scanner.close();
        return arraylist.toArray(new String[arraylist.size()]);
    }

    public static String getMinecraftDir() {
        try {
            return Minecraft.b().getAbsolutePath();
        }
        catch (NoClassDefFoundError e2) {
            return MinecraftServer.D().e("").getAbsolutePath();
        }
    }

    public static String getConfigDir() {
        File configDir = new File(CommonUtils.getMinecraftDir(), "config");
        return configDir.getAbsolutePath();
    }
}

