/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.util.BSLog;
import bspkrs.util.CommonUtils;
import java.net.URL;
import java.util.logging.Logger;

public class ModVersionChecker {
    private URL versionURL;
    private final String modName;
    private final String newVer;
    private final String oldVer;
    private String updateURL;
    private String[] loadMsg;
    private String[] inGameMsg;
    private int remoteBeginIndex;
    private int remoteEndIndex = -1;
    private boolean useRemoteStringIndices = false;

    @Deprecated
    public ModVersionChecker(String modName, String oldVer, String versionURL, String updateURL, String[] loadMsg, String[] inGameMsg, Logger logger) {
        this(modName, oldVer, versionURL, updateURL, loadMsg, inGameMsg);
    }

    public ModVersionChecker(String modName, String oldVer, String versionURL, String updateURL, String[] loadMsg, String[] inGameMsg) {
        this.modName = modName;
        this.oldVer = oldVer;
        this.updateURL = updateURL;
        this.loadMsg = loadMsg;
        this.inGameMsg = inGameMsg;
        try {
            this.versionURL = new URL(versionURL);
            BSLog.info("Initializing ModVersionChecker for mod %s", modName);
        }
        catch (Throwable e2) {
            BSLog.warning("Error initializing ModVersionChecker for mod %s: %s", modName, e2.getMessage());
        }
        String[] versionLines = CommonUtils.loadTextFromURL(this.versionURL, BSLog.INSTANCE.getLogger(), new String[]{oldVer}, 300);
        this.newVer = versionLines[0].trim();
        if (versionLines.length > 1 && versionLines[1].trim().length() != 0) {
            this.updateURL = versionLines[1];
        }
        if (versionLines.length > 2 && versionLines[2].trim().length() != 0 && versionLines[2].contains(",")) {
            try {
                String[] indices = versionLines[2].split(",");
                this.remoteBeginIndex = Integer.parseInt(indices[0]);
                this.remoteEndIndex = Integer.parseInt(indices[1]);
                this.useRemoteStringIndices = this.remoteBeginIndex <= this.remoteEndIndex;
            }
            catch (Throwable e3) {
                this.remoteEndIndex = -1;
                this.remoteBeginIndex = -1;
            }
        }
        this.setLoadMessage(loadMsg);
        this.setInGameMessage(inGameMsg);
    }

    @Deprecated
    public ModVersionChecker(String modName, String oldVer, String versionURL, String updateURL, Logger logger) {
        this(modName, oldVer, versionURL, updateURL);
    }

    public ModVersionChecker(String modName, String oldVer, String versionURL, String updateURL) {
        this(modName, oldVer, versionURL, updateURL, new String[]{"{modName} {oldVer} is out of date! Visit {updateURL} to download the latest release ({newVer})."}, new String[]{"\u00a7c{modName} {newVer} \u00a7ris out! Download the latest from \u00a7a{updateURL}\u00a7r"});
    }

    public void checkVersionWithLogging() {
        if (!this.isCurrentVersion()) {
            for (String msg : this.loadMsg) {
                BSLog.info(msg, new Object[0]);
            }
        }
    }

    public void checkVersionWithLoggingBySubStringAsFloat(int beginIndex, int endIndex) {
        if (!this.isCurrentVersionBySubStringAsFloatNewer(beginIndex, endIndex)) {
            for (String msg : this.loadMsg) {
                BSLog.info(msg, new Object[0]);
            }
        }
    }

    public void setLoadMessage(String[] loadMsg) {
        this.loadMsg = loadMsg;
        for (int i2 = 0; i2 < this.loadMsg.length; ++i2) {
            this.loadMsg[i2] = this.replaceAllTags(this.loadMsg[i2]);
        }
    }

    public void setInGameMessage(String[] inGameMsg) {
        this.inGameMsg = inGameMsg;
        for (int i2 = 0; i2 < this.inGameMsg.length; ++i2) {
            this.inGameMsg[i2] = this.replaceAllTags(this.inGameMsg[i2]);
        }
    }

    public String[] getLoadMessage() {
        return this.loadMsg;
    }

    public String[] getInGameMessage() {
        return this.inGameMsg;
    }

    public boolean isCurrentVersion() {
        return this.newVer.equalsIgnoreCase(this.oldVer);
    }

    public boolean isCurrentVersionBySubStringAsFloatNewer(int beginIndex, int endIndex) {
        try {
            if (this.useRemoteStringIndices) {
                return Float.valueOf(this.newVer.substring(this.remoteBeginIndex, this.remoteEndIndex)).floatValue() <= Float.valueOf(this.oldVer.substring(beginIndex, endIndex)).floatValue();
            }
            return Float.valueOf(this.newVer.substring(beginIndex, endIndex)).floatValue() <= Float.valueOf(this.oldVer.substring(beginIndex, endIndex)).floatValue();
        }
        catch (Throwable e2) {
            BSLog.warning("Method isCurrentVersionBySubStringAsFloatNewer() encountered an error while comparing version substrings for mod %s: %s", this.modName, e2.getMessage());
            return true;
        }
    }

    private String replaceAllTags(String s2) {
        return s2.replace("{oldVer}", this.oldVer).replace("{newVer}", this.newVer).replace("{modName}", this.modName).replace("{updateURL}", this.updateURL);
    }
}

