/*
 * Decompiled with CFR 0.152.
 */
package me.FurH.LockClient.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import me.FurH.LockClient.files.LockMd5;
import net.minecraft.client.Minecraft;

public class LockData {
    public String url;
    public String name;
    public String dir;
    public long size;
    public int slices;
    public String md5;
    public String calmd5;
    public File output;
    public byte[][] buffer;
    public boolean done;
    public int index = 0;

    public boolean isValid() {
        return this.calmd5 == null ? false : this.md5.equals(this.calmd5);
    }

    public void handleArray(byte[] array) {
        if (this.done) {
            return;
        }
        this.buffer[this.index] = array;
        ++this.index;
        if (this.index >= this.buffer.length) {
            this.done = true;
        }
    }

    public LockData(String data) throws Exception {
        String[] split = data.split("\\|");
        if (split.length < 5) {
            throw new Exception("Invalid string data: " + data);
        }
        if (data.startsWith("http")) {
            this.url = split[0];
            this.name = this.url.substring(this.url.lastIndexOf(47) + 1);
        } else {
            this.name = split[0];
        }
        this.dir = split[1];
        this.size = Long.parseLong(split[2]);
        this.slices = Integer.parseInt(split[3]);
        this.md5 = split[4];
        this.buffer = new byte[this.slices][];
        File source = new File(Minecraft.b(), "temp" + this.dir);
        if (!source.exists()) {
            source.mkdirs();
        }
        this.output = new File(source, this.name);
        if (this.output.exists()) {
            this.calmd5 = LockMd5.getMd5(this.output);
        }
    }

    public File buildFile() throws Exception {
        if (this.index >= this.buffer.length) {
            return this.getFileFromBytes(this.output);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromBytes(File source) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(source);
            fos.write(this.joinByteArray());
            fos.close();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.calmd5 = LockMd5.getMd5(source);
        return source;
    }

    private byte[] joinByteArray() {
        int lenght = 0;
        for (byte[] slice : this.buffer) {
            lenght += slice.length;
        }
        byte[] ret = new byte[lenght];
        int read = 0;
        for (int j1 = 0; j1 < this.buffer.length; ++j1) {
            byte[] copy = this.buffer[j1];
            System.arraycopy(copy, 0, ret, read, copy.length);
            read += copy.length;
        }
        return ret;
    }
}

