/*
 * Decompiled with CFR 0.152.
 */
package me.FurH.LockClient.files;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import me.FurH.LockClient.LockClientHandler;
import me.FurH.LockClient.files.LockData;
import me.FurH.LockClient.files.LockThreads;
import me.FurH.LockClient.files.LockUrl;
import me.FurH.LockClient.patcher.LockWorker;
import net.minecraft.client.Minecraft;

public final class LockDownload {
    public AtomicBoolean success = new AtomicBoolean(false);
    public AtomicBoolean done = new AtomicBoolean(false);
    private AtomicBoolean connecting = new AtomicBoolean(false);
    private AtomicBoolean forcekill = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private List datas;
    private List urls;
    private long totalSlices;
    public long totalSize;
    public long sizeDone;
    public long lastDone;
    private long slicesDone;
    private int fileIndex;
    private boolean hasURL = false;
    private LockData current;
    public long speed = 0L;
    public long time = 1000L;
    private long start;
    private FileLock lock = null;
    private FileChannel channel = null;
    private boolean lockB = false;

    public LockDownload(List datas, List urls, List skip) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (LockClientHandler.getLockHandler().isConnected() && !LockDownload.this.done.get()) {
                    try {
                        1.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                LockDownload.this.forcekill.set(true);
                LockThreads.killAll();
            }
        };
        thread.setDaemon(true);
        thread.setName("FLockClient Shutdown Thread");
        thread.start();
        this.datas = datas;
        this.urls = urls;
        try {
            File temp = new File(Minecraft.b(), "lock");
            this.channel = new RandomAccessFile(temp, "rw").getChannel();
            this.lock = this.channel.lock(0L, Long.MAX_VALUE, true);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        LockDownload.this.lock.release();
                        LockDownload.this.channel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception ex2) {
            LockClientHandler.stack("Error while creating access file", ex2, ex2.getClass().getSimpleName());
        }
        for (LockData data : datas) {
            this.totalSlices += (long)data.slices;
            this.totalSize += data.size;
        }
        for (LockUrl url0 : urls) {
            this.totalSize += url0.size;
            this.totalSlices += (long)url0.slices;
            this.hasURL = true;
        }
        LockClientHandler handler = LockClientHandler.getLockHandler();
        handler.progress.addDownText("Total files queued for download: " + (datas.size() + urls.size()));
        handler.progress.addDownText("Total download size: " + this.getFormatedBytes(this.totalSize) + " in " + this.totalSlices + " slices");
        handler.progress.addDownText("Requesting download ticket...");
        handler.getDownloadTicket(skip);
        if (datas.isEmpty()) {
            this.startUrlDownload();
        }
        this.downloadSpeed();
        this.updateProcess();
    }

    public void receiveBytes(byte[] data) {
        if (this.datas.isEmpty()) {
            this.startUrlDownload();
            return;
        }
        LockClientHandler handler = LockClientHandler.getLockHandler();
        if (data == null) {
            this.startUrlDownload();
            handler.progress.addUpText("Null data incoming!");
            return;
        }
        if (new String(data).equals("done")) {
            this.current.done = true;
        }
        if (this.current == null) {
            this.current = (LockData)this.datas.get(0);
        }
        if (this.current.index == 0) {
            handler.progress.addDownText("Starting Download of " + this.current.name + ", size: " + this.getFormatedBytes(this.current.size));
            this.start = System.currentTimeMillis();
        }
        if (this.current.done) {
            ++this.fileIndex;
            handler.progress.addDownText(this.current.name + " downloaded in " + (System.currentTimeMillis() - this.start) + " ms");
            try {
                this.current.buildFile();
            }
            catch (Exception ex2) {
                LockClientHandler.stack("Failed to create pysical file!", ex2, ex2.getClass().getSimpleName());
                this.current.output.deleteOnExit();
            }
            if (this.fileIndex >= this.datas.size()) {
                for (LockData fdata : this.datas) {
                    handler.progress.addDownText("File: " + fdata.name + ", size: " + this.getFormatedBytes(fdata.size) + ", MD5: " + fdata.calmd5 + ", Ok? " + fdata.isValid());
                }
                if (!this.hasURL) {
                    handler.progress.setProgressAndMessage("All files downloaded successfuly!", 100);
                    this.success.set(true);
                    this.dispose();
                    return;
                }
                this.startUrlDownload();
                return;
            }
            this.current = (LockData)this.datas.get(this.fileIndex);
        }
        handler.progress.addUpText("File: " + this.current.name + ", slices: " + this.totalSlices + ", done: " + this.slicesDone);
        this.current.handleArray(data);
        this.sizeDone += (long)data.length;
        ++this.slicesDone;
    }

    private void startUrlDownload() {
        if (this.started.get()) {
            return;
        }
        this.started.set(true);
        LockThreads.getNewThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (LockUrl url : LockDownload.this.urls) {
                    BufferedInputStream in = null;
                    FileOutputStream fout = null;
                    try {
                        int count;
                        LockClientHandler handler = LockClientHandler.getLockHandler();
                        LockDownload.this.connecting.set(true);
                        handler.progress.setMessageOnly("Connecting...");
                        in = new BufferedInputStream(new URL(url.url).openStream());
                        url.output.delete();
                        LockDownload.this.connecting.set(false);
                        fout = new FileOutputStream(url.output);
                        byte[] data = new byte[1024];
                        while ((count = in.read(data, 0, 1024)) != -1 && !LockDownload.this.forcekill.get()) {
                            fout.write(data, 0, count);
                            LockDownload.this.sizeDone += (long)count;
                        }
                        fout.flush();
                    }
                    catch (Exception ex2) {
                        LockClientHandler.stack("Error on file download: " + url.url, ex2, ex2.getClass().getSimpleName());
                        url.output.deleteOnExit();
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception ex3) {}
                        }
                        if (fout == null) continue;
                        try {
                            fout.close();
                        }
                        catch (Exception ex4) {}
                    }
                }
                LockClientHandler handler = LockClientHandler.getLockHandler();
                handler.progress.setProgressAndMessage("All files downloaded successfuly!", 100);
                LockDownload.this.success.set(true);
                LockDownload.this.dispose();
            }
        }).start();
    }

    public void dispose() {
        this.done.set(true);
        if (this.lockB) {
            return;
        }
        if (!this.success.get()) {
            return;
        }
        this.success.set(false);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    LockThreads.killAll();
                    LockDownload.this.lockB = true;
                    LockClientHandler handler = LockClientHandler.getLockHandler();
                    LockWorker.setup();
                    4.sleep(2000L);
                    handler.progress.setProgressAndMessage("The game will close to patch the files now! Wait to hear two beeps to open it again!", 0);
                    LockDownload.this.done.set(true);
                    4.sleep(3000L);
                    handler.nullTyfy();
                    System.gc();
                    Minecraft.x().g();
                    System.gc();
                }
                catch (Exception ex2) {
                    LockClientHandler.stack("Error on shutdown", ex2, ex2.getClass().getSimpleName());
                }
            }
        };
        thread.setDaemon(true);
        thread.setName("LockClient Cleanup Thread");
        thread.start();
    }

    public void downloadSpeed() {
        LockThreads.getNewThread(new Runnable(){

            @Override
            public void run() {
                while (!LockDownload.this.done.get()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LockDownload.this.speed = (LockDownload.this.sizeDone - LockDownload.this.lastDone) / 1000L;
                    LockDownload.this.lastDone = LockDownload.this.sizeDone;
                }
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public void updateProcess() {
        LockThreads.getNewThread(new Runnable(){

            @Override
            public void run() {
                while (!LockDownload.this.done.get()) {
                    try {
                        LockClientHandler handler = LockClientHandler.getLockHandler();
                        int progress = Math.min((int)((double)LockDownload.this.sizeDone / (double)LockDownload.this.totalSize * 100.0), 100);
                        String totalS = LockDownload.this.getFormatedBytes(handler.task.totalSize);
                        String doneS = LockDownload.this.getFormatedBytes(handler.task.sizeDone);
                        if (!LockDownload.this.connecting.get()) {
                            handler.progress.setProgressAndMessage(doneS + " / " + totalS + " at " + LockDownload.this.getFormatedBytes(handler.task.speed * 1024L) + "/s", progress);
                        } else {
                            handler.progress.setMessageOnly("Connecting...");
                        }
                        if (Minecraft.x().s != handler.progress) {
                            Minecraft.x().a(handler.progress);
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public String getFormatedBytes(double bytes) {
        DecimalFormat decimal = new DecimalFormat("#.##");
        if (bytes >= 1.099511627776E12) {
            return decimal.format(bytes / 1.099511627776E12) + " TB";
        }
        if (bytes >= 1.073741824E9) {
            return decimal.format(bytes / 1.073741824E9) + " GB";
        }
        if (bytes >= 1048576.0) {
            return decimal.format(bytes / 1048576.0) + " MB";
        }
        if (bytes >= 1024.0) {
            return decimal.format(bytes / 1024.0) + " KB";
        }
        return "" + (int)bytes + " bytes";
    }
}

