/*
 * Decompiled with CFR 0.152.
 */
package me.FurH.LockClient.files;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import me.FurH.LockClient.LockClientHandler;
import net.minecraft.client.Minecraft;

public class LockUrl {
    public String url;
    public String name;
    public String dir;
    public long size;
    public int slices;
    public File output;

    public LockUrl(String data) throws Exception {
        String[] split = data.split("\\|");
        if (split.length < 2) {
            throw new Exception("Invalid string data: " + data);
        }
        this.url = split[0];
        this.name = split.length < 3 ? this.url.substring(this.url.lastIndexOf(47) + 1) : split[2];
        this.dir = split[1];
        this.size = this.getDownloadSize(this.url);
        this.slices = (int)Math.floor(this.size / 30720L);
        File source = new File(Minecraft.b(), "temp" + this.dir);
        if (!source.exists()) {
            source.mkdirs();
        }
        this.output = new File(source, this.name);
    }

    private long getDownloadSize(String url) {
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(false);
            System.setProperty("http.agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.19 (KHTML, like Gecko) Chrome/18.0.1025.162 Safari/535.19");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.19 (KHTML, like Gecko) Chrome/18.0.1025.162 Safari/535.19");
            HttpURLConnection.setFollowRedirects(true);
            connection.setUseCaches(true);
            ((HttpURLConnection)connection).setInstanceFollowRedirects(true);
            return connection.getContentLengthLong();
        }
        catch (Exception ex2) {
            LockClientHandler.stack("Error while parsing download size: " + url, ex2, ex2.getClass().getSimpleName());
            ex2.printStackTrace();
            return -1L;
        }
    }
}

