/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantPackage
extends Constant
implements ConstantObject {
    private int name_index;

    public ConstantPackage(ConstantPackage constantPackage) {
        this(constantPackage.getNameIndex());
    }

    ConstantPackage(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort());
    }

    public ConstantPackage(int n) {
        super((byte)20);
        this.name_index = n;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantPackage(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeShort(this.name_index);
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public void setNameIndex(int n) {
        this.name_index = n;
    }

    @Override
    public Object getConstantValue(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.name_index, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public String getBytes(ConstantPool constantPool) {
        return (String)this.getConstantValue(constantPool);
    }

    @Override
    public String toString() {
        return super.toString() + "(name_index = " + this.name_index + ")";
    }
}

