/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public abstract class Utility {
    private static ThreadLocal<Integer> consumed_chars;
    private static boolean wide;
    private static final int FREE_CHARS = 48;
    private static int[] CHAR_MAP;
    private static int[] MAP_CHAR;
    private static final char ESCAPE_CHAR = '$';

    private static int unwrap(ThreadLocal<Integer> threadLocal) {
        return threadLocal.get();
    }

    private static void wrap(ThreadLocal<Integer> threadLocal, int n) {
        threadLocal.set(n);
    }

    public static String accessToString(int n) {
        return Utility.accessToString(n, false);
    }

    public static String accessToString(int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        while (n2 < 32768) {
            n2 = Utility.pow2(n3);
            if ((n & n2) != 0 && (!bl || n2 != 32 && n2 != 512)) {
                stringBuilder.append(Const.getAccessName(n3)).append(" ");
            }
            ++n3;
        }
        return stringBuilder.toString().trim();
    }

    public static String classOrInterface(int n) {
        return (n & 0x200) != 0 ? "interface" : "class";
    }

    public static String codeToString(byte[] byArray, ConstantPool constantPool, int n, int n2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 20);
        try (ByteSequence byteSequence = new ByteSequence(byArray);){
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                Utility.codeToString(byteSequence, constantPool, bl);
            }
            n3 = 0;
            while (byteSequence.available() > 0) {
                if (n2 < 0 || n3 < n2) {
                    String string = Utility.fillup(byteSequence.getIndex() + ":", 6, true, ' ');
                    stringBuilder.append(string).append(Utility.codeToString(byteSequence, constantPool, bl)).append('\n');
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new ClassFormatException("Byte code error: " + stringBuilder.toString(), iOException);
        }
        return stringBuilder.toString();
    }

    public static String codeToString(byte[] byArray, ConstantPool constantPool, int n, int n2) {
        return Utility.codeToString(byArray, constantPool, n, n2, true);
    }

    public static String codeToString(ByteSequence byteSequence, ConstantPool constantPool, boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        short s = (short)byteSequence.readUnsignedByte();
        int n4 = 0;
        int n5 = 0;
        StringBuilder stringBuilder = new StringBuilder(Const.getOpcodeName(s));
        if (s == 170 || s == 171) {
            n3 = byteSequence.getIndex() % 4;
            n5 = n3 == 0 ? 0 : 4 - n3;
            for (n2 = 0; n2 < n5; ++n2) {
                byte by = byteSequence.readByte();
                n = by;
                if (by == 0) continue;
                System.err.println("Warning: Padding byte != 0 in " + Const.getOpcodeName(s) + ":" + n);
            }
            n4 = byteSequence.readInt();
        }
        switch (s) {
            case 170: {
                int n6 = byteSequence.readInt();
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.getIndex() - 12 - n5 - 1;
                stringBuilder.append("\tdefault = ").append(n4 += n8).append(", low = ").append(n6).append(", high = ").append(n7).append("(");
                int[] nArray = new int[n7 - n6 + 1];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    nArray[n3] = n8 + byteSequence.readInt();
                    stringBuilder.append(nArray[n3]);
                    if (n3 >= nArray.length - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(")");
                break;
            }
            case 171: {
                int n9 = byteSequence.readInt();
                int n10 = byteSequence.getIndex() - 8 - n5 - 1;
                int[] nArray = new int[n9];
                int[] nArray2 = new int[n9];
                stringBuilder.append("\tdefault = ").append(n4 += n10).append(", npairs = ").append(n9).append(" (");
                for (n3 = 0; n3 < n9; ++n3) {
                    nArray[n3] = byteSequence.readInt();
                    nArray2[n3] = n10 + byteSequence.readInt();
                    stringBuilder.append("(").append(nArray[n3]).append(", ").append(nArray2[n3]).append(")");
                    if (n3 >= n9 - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                stringBuilder.append("\t\t#").append(byteSequence.getIndex() - 1 + byteSequence.readShort());
                break;
            }
            case 200: 
            case 201: {
                stringBuilder.append("\t\t#").append(byteSequence.getIndex() - 1 + byteSequence.readInt());
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n11;
                if (wide) {
                    n11 = byteSequence.readUnsignedShort();
                    wide = false;
                } else {
                    n11 = byteSequence.readUnsignedByte();
                }
                stringBuilder.append("\t\t%").append(n11);
                break;
            }
            case 196: {
                wide = true;
                stringBuilder.append("\t(wide)");
                break;
            }
            case 188: {
                stringBuilder.append("\t\t<").append(Const.getTypeName(byteSequence.readByte())).append(">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n12 = byteSequence.readUnsignedShort();
                stringBuilder.append("\t\t").append(constantPool.constantToString(n12, (byte)9)).append(bl ? " (" + n12 + ")" : "");
                break;
            }
            case 187: 
            case 192: {
                stringBuilder.append("\t");
            }
            case 193: {
                int n13 = byteSequence.readUnsignedShort();
                stringBuilder.append("\t<").append(constantPool.constantToString(n13, (byte)7)).append(">").append(bl ? " (" + n13 + ")" : "");
                break;
            }
            case 183: 
            case 184: {
                int n14 = byteSequence.readUnsignedShort();
                Constant constant = constantPool.getConstant(n14);
                stringBuilder.append("\t").append(constantPool.constantToString(n14, constant.getTag())).append(bl ? " (" + n14 + ")" : "");
                break;
            }
            case 182: {
                int n15 = byteSequence.readUnsignedShort();
                stringBuilder.append("\t").append(constantPool.constantToString(n15, (byte)10)).append(bl ? " (" + n15 + ")" : "");
                break;
            }
            case 185: {
                int n16 = byteSequence.readUnsignedShort();
                n2 = byteSequence.readUnsignedByte();
                stringBuilder.append("\t").append(constantPool.constantToString(n16, (byte)11)).append(bl ? " (" + n16 + ")\t" : "").append(n2).append("\t").append(byteSequence.readUnsignedByte());
                break;
            }
            case 186: {
                int n17 = byteSequence.readUnsignedShort();
                stringBuilder.append("\t").append(constantPool.constantToString(n17, (byte)18)).append(bl ? " (" + n17 + ")\t" : "").append(byteSequence.readUnsignedByte()).append(byteSequence.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int n18 = byteSequence.readUnsignedShort();
                stringBuilder.append("\t\t").append(constantPool.constantToString(n18, constantPool.getConstant(n18).getTag())).append(bl ? " (" + n18 + ")" : "");
                break;
            }
            case 18: {
                int n19 = byteSequence.readUnsignedByte();
                stringBuilder.append("\t\t").append(constantPool.constantToString(n19, constantPool.getConstant(n19).getTag())).append(bl ? " (" + n19 + ")" : "");
                break;
            }
            case 189: {
                int n20 = byteSequence.readUnsignedShort();
                stringBuilder.append("\t\t<").append(Utility.compactClassName(constantPool.getConstantString(n20, (byte)7), false)).append(">").append(bl ? " (" + n20 + ")" : "");
                break;
            }
            case 197: {
                int n21 = byteSequence.readUnsignedShort();
                n = byteSequence.readUnsignedByte();
                stringBuilder.append("\t<").append(Utility.compactClassName(constantPool.getConstantString(n21, (byte)7), false)).append(">\t").append(n).append(bl ? " (" + n21 + ")" : "");
                break;
            }
            case 132: {
                short s2;
                int n22;
                if (wide) {
                    n22 = byteSequence.readUnsignedShort();
                    s2 = byteSequence.readShort();
                    wide = false;
                } else {
                    n22 = byteSequence.readUnsignedByte();
                    s2 = byteSequence.readByte();
                }
                stringBuilder.append("\t\t%").append(n22).append("\t").append(s2);
                break;
            }
            default: {
                if (Const.getNoOfOperands(s) <= 0) break;
                n = 0;
                while ((long)n < Const.getOperandTypeCount(s)) {
                    stringBuilder.append("\t\t");
                    switch (Const.getOperandType(s, n)) {
                        case 8: {
                            stringBuilder.append(byteSequence.readByte());
                            break;
                        }
                        case 9: {
                            stringBuilder.append(byteSequence.readShort());
                            break;
                        }
                        case 10: {
                            stringBuilder.append(byteSequence.readInt());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable default case reached!");
                        }
                    }
                    ++n;
                }
                break block0;
            }
        }
        return stringBuilder.toString();
    }

    public static String codeToString(ByteSequence byteSequence, ConstantPool constantPool) throws IOException {
        return Utility.codeToString(byteSequence, constantPool, true);
    }

    public static String compactClassName(String string) {
        return Utility.compactClassName(string, true);
    }

    public static String compactClassName(String string, boolean bl) {
        return Utility.compactClassName(string, "java.lang.", bl);
    }

    public static String compactClassName(String string, String string2, boolean bl) {
        int n = string2.length();
        string = string.replace('/', '.');
        if (bl && string.startsWith(string2) && string.substring(n).indexOf(46) == -1) {
            string = string.substring(n);
        }
        return string;
    }

    public static int setBit(int n, int n2) {
        return n | Utility.pow2(n2);
    }

    public static int clearBit(int n, int n2) {
        int n3 = Utility.pow2(n2);
        return (n & n3) == 0 ? n : n ^ n3;
    }

    public static boolean isSet(int n, int n2) {
        return (n & Utility.pow2(n2)) != 0;
    }

    public static String methodTypeToSignature(String string, String[] stringArray) throws ClassFormatException {
        String string2;
        StringBuilder stringBuilder = new StringBuilder("(");
        if (stringArray != null) {
            for (String string3 : stringArray) {
                string2 = Utility.getSignature(string3);
                if (string2.endsWith("V")) {
                    throw new ClassFormatException("Invalid type: " + string3);
                }
                stringBuilder.append(string2);
            }
        }
        string2 = Utility.getSignature(string);
        stringBuilder.append(")").append(string2);
        return stringBuilder.toString();
    }

    public static String[] methodSignatureArgumentTypes(String string) throws ClassFormatException {
        return Utility.methodSignatureArgumentTypes(string, true);
    }

    public static String[] methodSignatureArgumentTypes(String string, boolean bl) throws ClassFormatException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n = string.indexOf(40) + 1;
            if (n <= 0) {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            while (string.charAt(n) != ')') {
                arrayList.add(Utility.typeSignatureToString(string.substring(n), bl));
                n += Utility.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string, stringIndexOutOfBoundsException);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String methodSignatureReturnType(String string) throws ClassFormatException {
        return Utility.methodSignatureReturnType(string, true);
    }

    public static String methodSignatureReturnType(String string, boolean bl) throws ClassFormatException {
        String string2;
        try {
            int n = string.lastIndexOf(41) + 1;
            if (n <= 0) {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            string2 = Utility.typeSignatureToString(string.substring(n), bl);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string, stringIndexOutOfBoundsException);
        }
        return string2;
    }

    public static String methodSignatureToString(String string, String string2, String string3) {
        return Utility.methodSignatureToString(string, string2, string3, true);
    }

    public static String methodSignatureToString(String string, String string2, String string3, boolean bl) {
        return Utility.methodSignatureToString(string, string2, string3, bl, null);
    }

    public static String methodSignatureToString(String string, String string2, String string3, boolean bl, LocalVariableTable localVariableTable) throws ClassFormatException {
        String string4;
        StringBuilder stringBuilder = new StringBuilder("(");
        int n = string3.contains("static") ? 0 : 1;
        try {
            int n2 = string.indexOf(40) + 1;
            if (n2 <= 0) {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            while (string.charAt(n2) != ')') {
                String string5 = Utility.typeSignatureToString(string.substring(n2), bl);
                stringBuilder.append(string5);
                if (localVariableTable != null) {
                    LocalVariable localVariable = localVariableTable.getLocalVariable(n, 0);
                    if (localVariable != null) {
                        stringBuilder.append(" ").append(localVariable.getName());
                    }
                } else {
                    stringBuilder.append(" arg").append(n);
                }
                n = "double".equals(string5) || "long".equals(string5) ? (n += 2) : ++n;
                stringBuilder.append(", ");
                n2 += Utility.unwrap(consumed_chars);
            }
            string4 = Utility.typeSignatureToString(string.substring(++n2), bl);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string, stringIndexOutOfBoundsException);
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(")");
        return string3 + (string3.length() > 0 ? " " : "") + string4 + " " + string2 + stringBuilder.toString();
    }

    private static int pow2(int n) {
        return 1 << n;
    }

    public static String replace(String string, String string2, String string3) {
        try {
            if (string.contains(string2)) {
                int n;
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = 0;
                while ((n = string.indexOf(string2, n2)) != -1) {
                    stringBuilder.append(string.substring(n2, n));
                    stringBuilder.append(string3);
                    n2 = n + string2.length();
                }
                stringBuilder.append(string.substring(n2));
                string = stringBuilder.toString();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println(stringIndexOutOfBoundsException);
        }
        return string;
    }

    public static String signatureToString(String string) {
        return Utility.signatureToString(string, true);
    }

    public static String signatureToString(String string, boolean bl) {
        String string2 = "";
        String string3 = "";
        int n = 0;
        if (string.charAt(0) == '<') {
            string3 = Utility.typeParamTypesToString(string, bl);
            n += Utility.unwrap(consumed_chars);
        }
        if (string.charAt(n) == '(') {
            string2 = string3 + Utility.typeSignaturesToString(string.substring(n), bl, ')');
            string2 = string2 + Utility.typeSignatureToString(string.substring(n += Utility.unwrap(consumed_chars)), bl);
            n += Utility.unwrap(consumed_chars);
            return string2;
        }
        string2 = Utility.typeSignatureToString(string.substring(n), bl);
        if (string3.length() == 0 && (n += Utility.unwrap(consumed_chars)) == string.length()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string3);
        stringBuilder.append(" extends ");
        stringBuilder.append(string2);
        if (n < string.length()) {
            stringBuilder.append(" implements ");
            stringBuilder.append(Utility.typeSignatureToString(string.substring(n), bl));
            n += Utility.unwrap(consumed_chars);
        }
        while (n < string.length()) {
            stringBuilder.append(", ");
            stringBuilder.append(Utility.typeSignatureToString(string.substring(n), bl));
            n += Utility.unwrap(consumed_chars);
        }
        return stringBuilder.toString();
    }

    private static String typeParamTypesToString(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("<");
        int n = 1;
        stringBuilder.append(Utility.typeParamTypeToString(string.substring(n), bl));
        n += Utility.unwrap(consumed_chars);
        while (string.charAt(n) != '>') {
            stringBuilder.append(", ");
            stringBuilder.append(Utility.typeParamTypeToString(string.substring(n), bl));
            n += Utility.unwrap(consumed_chars);
        }
        Utility.wrap(consumed_chars, n + 1);
        return stringBuilder.append(">").toString();
    }

    private static String typeParamTypeToString(String string, boolean bl) {
        int n = string.indexOf(58);
        if (n <= 0) {
            throw new ClassFormatException("Invalid type parameter signature: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
        if (string.charAt(++n) != ':') {
            stringBuilder.append(" extends ");
            stringBuilder.append(Utility.typeSignatureToString(string.substring(n), bl));
            n += Utility.unwrap(consumed_chars);
        }
        while (string.charAt(n) == ':') {
            stringBuilder.append(" & ");
            stringBuilder.append(Utility.typeSignatureToString(string.substring(++n), bl));
            n += Utility.unwrap(consumed_chars);
        }
        Utility.wrap(consumed_chars, n);
        return stringBuilder.toString();
    }

    private static String typeSignaturesToString(String string, boolean bl, char c) {
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, 1));
        int n = 1;
        if (string.charAt(n) != c) {
            stringBuilder.append(Utility.typeSignatureToString(string.substring(n), bl));
            n += Utility.unwrap(consumed_chars);
        }
        while (string.charAt(n) != c) {
            stringBuilder.append(", ");
            stringBuilder.append(Utility.typeSignatureToString(string.substring(n), bl));
            n += Utility.unwrap(consumed_chars);
        }
        Utility.wrap(consumed_chars, n + 1);
        return stringBuilder.append(c).toString();
    }

    public static String typeSignatureToString(String string, boolean bl) throws ClassFormatException {
        Utility.wrap(consumed_chars, 1);
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'T': {
                    int n = string.indexOf(59);
                    if (n < 0) {
                        throw new ClassFormatException("Invalid type variable signature: " + string);
                    }
                    Utility.wrap(consumed_chars, n + 1);
                    return Utility.compactClassName(string.substring(1, n), bl);
                }
                case 'L': {
                    int n = string.indexOf(60);
                    if (n < 0) {
                        n = 0;
                    } else if ((n = string.indexOf(62, n)) < 0) {
                        throw new ClassFormatException("Invalid signature: " + string);
                    }
                    int n2 = string.indexOf(59, n);
                    if (n2 < 0) {
                        throw new ClassFormatException("Invalid signature: " + string);
                    }
                    int n3 = string.substring(0, n2).indexOf(60);
                    if (n3 < 0) {
                        Utility.wrap(consumed_chars, n2 + 1);
                        return Utility.compactClassName(string.substring(1, n2), bl);
                    }
                    n = string.indexOf(59);
                    if (n < 0) {
                        throw new ClassFormatException("Invalid signature: " + string);
                    }
                    if (n < n3) {
                        Utility.wrap(consumed_chars, n + 1);
                        return Utility.compactClassName(string.substring(1, n), bl);
                    }
                    StringBuilder stringBuilder = new StringBuilder(Utility.compactClassName(string.substring(1, n3), bl)).append("<");
                    int n4 = n3 + 1;
                    if (string.charAt(n4) == '+') {
                        stringBuilder.append("? extends ");
                        ++n4;
                    } else if (string.charAt(n4) == '-') {
                        stringBuilder.append("? super ");
                        ++n4;
                    }
                    if (string.charAt(n4) == '*') {
                        stringBuilder.append("?");
                        ++n4;
                    } else {
                        stringBuilder.append(Utility.typeSignatureToString(string.substring(n4), bl));
                        n4 = Utility.unwrap(consumed_chars) + n4;
                        Utility.wrap(consumed_chars, n4);
                    }
                    while (string.charAt(n4) != '>') {
                        stringBuilder.append(", ");
                        if (string.charAt(n4) == '+') {
                            stringBuilder.append("? extends ");
                            ++n4;
                        } else if (string.charAt(n4) == '-') {
                            stringBuilder.append("? super ");
                            ++n4;
                        }
                        if (string.charAt(n4) == '*') {
                            stringBuilder.append("?");
                            ++n4;
                            continue;
                        }
                        stringBuilder.append(Utility.typeSignatureToString(string.substring(n4), bl));
                        n4 = Utility.unwrap(consumed_chars) + n4;
                        Utility.wrap(consumed_chars, n4);
                    }
                    stringBuilder.append(">");
                    if (string.charAt(++n4) == '.') {
                        stringBuilder.append(".");
                        stringBuilder.append(Utility.typeSignatureToString("L" + string.substring(n4 + 1), bl));
                        n4 = Utility.unwrap(consumed_chars) + n4;
                        Utility.wrap(consumed_chars, n4);
                        return stringBuilder.toString();
                    }
                    if (string.charAt(n4) != ';') {
                        throw new ClassFormatException("Invalid signature: " + string);
                    }
                    Utility.wrap(consumed_chars, n4 + 1);
                    return stringBuilder.toString();
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 0;
                    while (string.charAt(n) == '[') {
                        stringBuilder.append("[]");
                        ++n;
                    }
                    int n5 = n;
                    String string2 = Utility.typeSignatureToString(string.substring(n), bl);
                    int n6 = Utility.unwrap(consumed_chars) + n5;
                    Utility.wrap(consumed_chars, n6);
                    return string2 + stringBuilder.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatException("Invalid signature: `" + string + "'");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid signature: " + string, stringIndexOutOfBoundsException);
        }
    }

    public static String getSignature(String string) {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = -1;
        block4: for (n2 = 0; n2 < cArray.length; ++n2) {
            switch (cArray[n2]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!bl) continue block4;
                    bl2 = true;
                    continue block4;
                }
                case '[': {
                    if (!bl) {
                        throw new RuntimeException("Illegal type: " + string);
                    }
                    n3 = n2;
                    break block4;
                }
                default: {
                    bl = true;
                    if (bl2) continue block4;
                    stringBuilder.append(cArray[n2]);
                }
            }
        }
        n2 = 0;
        if (n3 > 0) {
            n2 = Utility.countBrackets(string.substring(n3));
        }
        string = stringBuilder.toString();
        stringBuilder.setLength(0);
        for (n = 0; n < n2; ++n) {
            stringBuilder.append('[');
        }
        n = 0;
        for (int i = 4; i <= 12 && n == 0; ++i) {
            if (!Const.getTypeName(i).equals(string)) continue;
            n = 1;
            stringBuilder.append(Const.getShortTypeName(i));
        }
        if (n == 0) {
            stringBuilder.append('L').append(string.replace('.', '/')).append(';');
        }
        return stringBuilder.toString();
    }

    private static int countBrackets(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        boolean bl = false;
        block4: for (char c : cArray) {
            switch (c) {
                case '[': {
                    if (bl) {
                        throw new RuntimeException("Illegally nested brackets:" + string);
                    }
                    bl = true;
                    continue block4;
                }
                case ']': {
                    if (!bl) {
                        throw new RuntimeException("Illegally nested brackets:" + string);
                    }
                    bl = false;
                    ++n;
                    continue block4;
                }
            }
        }
        if (bl) {
            throw new RuntimeException("Illegally nested brackets:" + string);
        }
        return n;
    }

    public static byte typeOfMethodSignature(String string) throws ClassFormatException {
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            int n = string.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(string.substring(n));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string, stringIndexOutOfBoundsException);
        }
    }

    public static byte typeOfSignature(String string) throws ClassFormatException {
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': 
                case 'T': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
                case '!': 
                case '*': 
                case '+': {
                    return Utility.typeOfSignature(string.substring(1));
                }
            }
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string, stringIndexOutOfBoundsException);
        }
    }

    public static short searchOpcode(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (short s = 0; s < Const.OPCODE_NAMES_LENGTH; s = (short)(s + 1)) {
            if (!Const.getOpcodeName(s).equals(string)) continue;
            return s;
        }
        return -1;
    }

    private static short byteToShort(byte by) {
        return by < 0 ? (short)(256 + by) : (short)by;
    }

    public static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            short s = Utility.byteToShort(byArray[i]);
            String string = Integer.toHexString(s);
            if (s < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            if (i >= byArray.length - 1) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public static String format(int n, int n2, boolean bl, char c) {
        return Utility.fillup(Integer.toString(n), n2, bl, c);
    }

    public static String fillup(String string, int n, boolean bl, char c) {
        int n2 = n - string.length();
        char[] cArray = new char[n2 < 0 ? 0 : n2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
        if (bl) {
            return string + new String(cArray);
        }
        return new String(cArray) + string;
    }

    static boolean equals(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void printArray(PrintStream printStream, Object[] objectArray) {
        printStream.println(Utility.printArray(objectArray, true));
    }

    public static void printArray(PrintWriter printWriter, Object[] objectArray) {
        printWriter.println(Utility.printArray(objectArray, true));
    }

    public static String printArray(Object[] objectArray) {
        return Utility.printArray(objectArray, true);
    }

    public static String printArray(Object[] objectArray, boolean bl) {
        return Utility.printArray(objectArray, bl, false);
    }

    public static String printArray(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append('{');
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) {
                stringBuilder.append(bl2 ? "\"" : "").append(objectArray[i]).append(bl2 ? "\"" : "");
            } else {
                stringBuilder.append("null");
            }
            if (i >= objectArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        if (bl) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public static boolean isJavaIdentifierPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    public static String encode(byte[] byArray, boolean bl) throws IOException {
        Object object;
        Object object2;
        Closeable closeable;
        if (bl) {
            closeable = new ByteArrayOutputStream();
            object2 = null;
            try {
                object = new GZIPOutputStream((OutputStream)closeable);
                Object object3 = null;
                try {
                    ((GZIPOutputStream)object).write(byArray, 0, byArray.length);
                    byArray = ((ByteArrayOutputStream)closeable).toByteArray();
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (object != null) {
                        if (object3 != null) {
                            try {
                                ((DeflaterOutputStream)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            ((DeflaterOutputStream)object).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (object2 != null) {
                        try {
                            ((ByteArrayOutputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((ByteArrayOutputStream)closeable).close();
                    }
                }
            }
        }
        closeable = new CharArrayWriter();
        object2 = new JavaWriter((Writer)closeable);
        object = null;
        try {
            for (byte by : byArray) {
                int n = by & 0xFF;
                ((JavaWriter)object2).write(n);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (object2 != null) {
                if (object != null) {
                    try {
                        ((FilterWriter)object2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((FilterWriter)object2).close();
                }
            }
        }
        return ((CharArrayWriter)closeable).toString();
    }

    public static byte[] decode(String string, boolean bl) throws IOException {
        byte[] byArray;
        Closeable closeable = new JavaReader(new CharArrayReader(string.toCharArray()));
        Object object = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int n;
            while ((n = ((JavaReader)closeable).read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (closeable != null) {
                if (object != null) {
                    try {
                        ((FilterReader)closeable).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((FilterReader)closeable).close();
                }
            }
        }
        if (bl) {
            int n;
            closeable = new GZIPInputStream(new ByteArrayInputStream(byArray));
            object = new byte[byArray.length * 3];
            int n2 = 0;
            while ((n = ((InflaterInputStream)closeable).read()) >= 0) {
                object[n2++] = (byte)n;
            }
            byArray = new byte[n2];
            System.arraycopy(object, 0, byArray, 0, n2);
        }
        return byArray;
    }

    public static String convertString(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (char c : cArray) {
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block7;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    static {
        int n;
        consumed_chars = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        wide = false;
        CHAR_MAP = new int[48];
        MAP_CHAR = new int[256];
        int n2 = 0;
        for (n = 65; n <= 90; ++n) {
            Utility.CHAR_MAP[n2] = n;
            Utility.MAP_CHAR[n] = n2++;
        }
        for (n = 103; n <= 122; ++n) {
            Utility.CHAR_MAP[n2] = n;
            Utility.MAP_CHAR[n] = n2++;
        }
        Utility.CHAR_MAP[n2] = 36;
        Utility.MAP_CHAR[36] = n2++;
        Utility.CHAR_MAP[n2] = 95;
        Utility.MAP_CHAR[95] = n2;
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader reader) {
            super(reader);
        }

        @Override
        public int read() throws IOException {
            int n = this.in.read();
            if (n != 36) {
                return n;
            }
            int n2 = this.in.read();
            if (n2 < 0) {
                return -1;
            }
            if (n2 >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 102) {
                int n3 = this.in.read();
                if (n3 < 0) {
                    return -1;
                }
                char[] cArray = new char[]{(char)n2, (char)n3};
                int n4 = Integer.parseInt(new String(cArray), 16);
                return n4;
            }
            return MAP_CHAR[n2];
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                cArray[n + i] = (char)this.read();
            }
            return n2;
        }
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer writer) {
            super(writer);
        }

        @Override
        public void write(int n) throws IOException {
            if (Utility.isJavaIdentifierPart((char)n) && n != 36) {
                this.out.write(n);
            } else {
                this.out.write(36);
                if (n >= 0 && n < 48) {
                    this.out.write(CHAR_MAP[n]);
                } else {
                    char[] cArray = Integer.toHexString(n).toCharArray();
                    if (cArray.length == 1) {
                        this.out.write(48);
                        this.out.write(cArray[0]);
                    } else {
                        this.out.write(cArray[0]);
                        this.out.write(cArray[1]);
                    }
                }
            }
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                this.write(cArray[n + i]);
            }
        }

        @Override
        public void write(String string, int n, int n2) throws IOException {
            this.write(string.toCharArray(), n, n2);
        }
    }
}

