/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.CompoundInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.LOOKUPSWITCH;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.TABLESWITCH;

public final class SWITCH
implements CompoundInstruction {
    private int[] match;
    private InstructionHandle[] targets;
    private Select instruction;
    private int match_length;

    public SWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle, int n) {
        this.match = (int[])nArray.clone();
        this.targets = (InstructionHandle[])instructionHandleArray.clone();
        this.match_length = nArray.length;
        if (this.match_length < 2) {
            this.instruction = new TABLESWITCH(nArray, instructionHandleArray, instructionHandle);
        } else {
            this.sort(0, this.match_length - 1);
            if (this.matchIsOrdered(n)) {
                this.fillup(n, instructionHandle);
                this.instruction = new TABLESWITCH(this.match, this.targets, instructionHandle);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, instructionHandle);
            }
        }
    }

    public SWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        this(nArray, instructionHandleArray, instructionHandle, 1);
    }

    private void fillup(int n, InstructionHandle instructionHandle) {
        int n2 = this.match_length + this.match_length * n;
        int[] nArray = new int[n2];
        InstructionHandle[] instructionHandleArray = new InstructionHandle[n2];
        int n3 = 1;
        nArray[0] = this.match[0];
        instructionHandleArray[0] = this.targets[0];
        for (int i = 1; i < this.match_length; ++i) {
            int n4 = this.match[i - 1];
            int n5 = this.match[i] - n4;
            for (int j = 1; j < n5; ++j) {
                nArray[n3] = n4 + j;
                instructionHandleArray[n3] = instructionHandle;
                ++n3;
            }
            nArray[n3] = this.match[i];
            instructionHandleArray[n3] = this.targets[i];
            ++n3;
        }
        this.match = new int[n3];
        this.targets = new InstructionHandle[n3];
        System.arraycopy(nArray, 0, this.match, 0, n3);
        System.arraycopy(instructionHandleArray, 0, this.targets, 0, n3);
    }

    private void sort(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = this.match[n + n2 >>> 1];
        while (true) {
            if (this.match[n3] < n5) {
                ++n3;
                continue;
            }
            while (n5 < this.match[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                int n6 = this.match[n3];
                this.match[n3] = this.match[n4];
                this.match[n4] = n6;
                InstructionHandle instructionHandle = this.targets[n3];
                this.targets[n3] = this.targets[n4];
                this.targets[n4] = instructionHandle;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.sort(n, n4);
        }
        if (n3 < n2) {
            this.sort(n3, n2);
        }
    }

    private boolean matchIsOrdered(int n) {
        for (int i = 1; i < this.match_length; ++i) {
            if (this.match[i] - this.match[i - 1] <= n) continue;
            return false;
        }
        return true;
    }

    @Override
    public InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }
}

