/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xalan.internal.utils.SecuritySupport;
import com.sun.org.apache.xml.internal.serializer.CharInfo;
import com.sun.org.apache.xml.internal.serializer.EncodingInfo;
import com.sun.org.apache.xml.internal.serializer.Encodings;
import com.sun.org.apache.xml.internal.serializer.NamespaceMappings;
import com.sun.org.apache.xml.internal.serializer.SerializerBase;
import com.sun.org.apache.xml.internal.serializer.SerializerTraceWriter;
import com.sun.org.apache.xml.internal.serializer.TreeWalker;
import com.sun.org.apache.xml.internal.serializer.WriterChain;
import com.sun.org.apache.xml.internal.serializer.WriterToASCI;
import com.sun.org.apache.xml.internal.serializer.WriterToUTF8Buffered;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import com.sun.org.apache.xml.internal.serializer.utils.WrappedRuntimeException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import jdk.xml.internal.JdkXmlUtils;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class ToStream
extends SerializerBase {
    private static final String COMMENT_BEGIN = "<!--";
    private static final String COMMENT_END = "-->";
    protected BoolStack m_disableOutputEscapingStates = new BoolStack();
    EncodingInfo m_encodingInfo = new EncodingInfo(null, null);
    Method m_canConvertMeth;
    boolean m_triedToGetConverter = false;
    Object m_charToByteConverter = null;
    protected BoolStack m_preserves = new BoolStack();
    protected boolean m_ispreserve = false;
    protected boolean m_isprevtext = false;
    protected int m_maxCharacter = Encodings.getLastPrintable();
    protected char[] m_lineSep = SecuritySupport.getSystemProperty("line.separator").toCharArray();
    protected boolean m_lineSepUse = true;
    protected int m_lineSepLen = this.m_lineSep.length;
    protected CharInfo m_charInfo;
    boolean m_shouldFlush = true;
    protected boolean m_spaceBeforeClose = false;
    boolean m_startNewLine;
    protected boolean m_inDoctype = false;
    boolean m_isUTF8 = false;
    protected boolean m_cdataStartCalled = false;
    private boolean m_expandDTDEntities = true;
    private char m_highSurrogate = '\u0000';
    private boolean m_escaping = true;
    OutputStream m_outputStream;
    private boolean m_writer_set_by_user;

    protected void closeCDATA() throws SAXException {
        try {
            this.m_writer.write("]]>");
            this.m_cdataTagOpen = false;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void serialize(Node node) throws IOException {
        try {
            TreeWalker treeWalker = new TreeWalker(this);
            treeWalker.traverse(node);
        }
        catch (SAXException sAXException) {
            throw new WrappedRuntimeException(sAXException);
        }
    }

    static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    protected final void flushWriter() throws SAXException {
        Writer writer = this.m_writer;
        if (null != writer) {
            try {
                if (writer instanceof WriterToUTF8Buffered) {
                    if (this.m_shouldFlush) {
                        ((WriterToUTF8Buffered)writer).flush();
                    } else {
                        ((WriterToUTF8Buffered)writer).flushBuffer();
                    }
                }
                if (writer instanceof WriterToASCI) {
                    if (this.m_shouldFlush) {
                        writer.flush();
                    }
                } else {
                    writer.flush();
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            Writer writer = this.m_writer;
            this.DTDprolog();
            writer.write("<!ELEMENT ");
            writer.write(string);
            writer.write(32);
            writer.write(string2);
            writer.write(62);
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            this.DTDprolog();
            this.outputEntityDecl(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void outputEntityDecl(String string, String string2) throws IOException {
        Writer writer = this.m_writer;
        writer.write("<!ENTITY ");
        writer.write(string);
        writer.write(" \"");
        writer.write(string2);
        writer.write("\">");
        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    protected final void outputLineSep() throws IOException {
        this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    @Override
    void setProp(String string, String string2, boolean bl) {
        if (string2 != null) {
            char c = ToStream.getFirstCharLocName(string);
            switch (c) {
                case 'c': {
                    if (!"cdata-section-elements".equals(string)) break;
                    this.addCdataSectionElements(string2);
                    break;
                }
                case 'd': {
                    if ("doctype-system".equals(string)) {
                        this.m_doctypeSystem = string2;
                        break;
                    }
                    if (!"doctype-public".equals(string)) break;
                    this.m_doctypePublic = string2;
                    if (!string2.startsWith("-//W3C//DTD XHTML")) break;
                    this.m_spaceBeforeClose = true;
                    break;
                }
                case 'e': {
                    Object object;
                    Object object2;
                    Object object3;
                    String string3 = string2;
                    if (!"encoding".equals(string)) break;
                    String string4 = Encodings.getMimeEncoding(string2);
                    if (string4 != null) {
                        super.setProp("mime-name", string4, bl);
                    }
                    String string5 = this.getOutputPropertyNonDefault("encoding");
                    String string6 = this.getOutputPropertyDefault("encoding");
                    if ((!bl || string6 != null && string6.equalsIgnoreCase(string3)) && (bl || string5 != null && string5.equalsIgnoreCase(string3))) break;
                    EncodingInfo encodingInfo = Encodings.getEncodingInfo(string3);
                    if (string3 != null && encodingInfo.name == null) {
                        object3 = Utils.messages.createMessage("ER_ENCODING_NOT_SUPPORTED", new Object[]{string3});
                        object2 = "Warning: encoding \"" + string3 + "\" not supported, using " + "UTF-8";
                        try {
                            object = super.getTransformer();
                            if (object != null) {
                                ErrorListener errorListener = ((Transformer)object).getErrorListener();
                                if (null != errorListener && this.m_sourceLocator != null) {
                                    errorListener.warning(new TransformerException((String)object3, this.m_sourceLocator));
                                    errorListener.warning(new TransformerException((String)object2, this.m_sourceLocator));
                                } else {
                                    System.out.println((String)object3);
                                    System.out.println((String)object2);
                                }
                            } else {
                                System.out.println((String)object3);
                                System.out.println((String)object2);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        string3 = "UTF-8";
                        string2 = "UTF-8";
                        encodingInfo = Encodings.getEncodingInfo(string3);
                    }
                    if (bl && string5 != null) break;
                    this.m_encodingInfo = encodingInfo;
                    if (string3 != null) {
                        this.m_isUTF8 = string3.equals("UTF-8");
                    }
                    if ((object3 = this.getOutputStream()) == null) break;
                    object2 = this.getWriter();
                    object = this.getOutputProperty("encoding");
                    if (object2 != null && this.m_writer_set_by_user || string3.equalsIgnoreCase((String)object)) break;
                    super.setProp(string, string2, bl);
                    this.setOutputStreamInternal((OutputStream)object3, false);
                    break;
                }
                case 'i': {
                    if ("{http://xml.apache.org/xalan}indent-amount".equals(string)) {
                        this.setIndentAmount(Integer.parseInt(string2));
                        break;
                    }
                    if ("indent".equals(string)) {
                        this.m_doIndent = string2.endsWith("yes");
                        break;
                    }
                    if (!"{http://www.oracle.com/xml}isStandalone".equals(string)) break;
                    this.m_isStandalone = string2.endsWith("yes");
                    break;
                }
                case 'l': {
                    if (!"{http://xml.apache.org/xalan}line-separator".equals(string)) break;
                    this.m_lineSep = string2.toCharArray();
                    this.m_lineSepLen = this.m_lineSep.length;
                    break;
                }
                case 'm': {
                    if (!"media-type".equals(string)) break;
                    this.m_mediatype = string2;
                    break;
                }
                case 'o': {
                    boolean bl2;
                    if (!"omit-xml-declaration".equals(string)) break;
                    this.m_shouldNotWriteXMLHeader = bl2 = string2.endsWith("yes");
                    break;
                }
                case 's': {
                    if (!"standalone".equals(string)) break;
                    if (bl) {
                        this.setStandaloneInternal(string2);
                        break;
                    }
                    this.m_standaloneWasSpecified = true;
                    this.setStandaloneInternal(string2);
                    break;
                }
                case 'v': {
                    if (!"version".equals(string)) break;
                    this.m_version = string2;
                    break;
                }
            }
            super.setProp(string, string2, bl);
        }
    }

    @Override
    public void setOutputFormat(Properties properties) {
        String string;
        Object object;
        boolean bl = this.m_shouldFlush;
        if (properties != null) {
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                String string2 = properties.getProperty(string);
                String string3 = (String)properties.get(string);
                if (string3 == null && string2 != null) {
                    this.setOutputPropertyDefault(string, string2);
                }
                if (string3 == null) continue;
                this.setOutputProperty(string, string3);
            }
        }
        if (null != (object = (String)properties.get("{http://xml.apache.org/xalan}entities"))) {
            string = (String)properties.get("method");
            this.m_charInfo = CharInfo.getCharInfo((String)object, string);
        }
        this.m_shouldFlush = bl;
    }

    @Override
    public Properties getOutputFormat() {
        String string;
        Object object;
        Properties properties = new Properties();
        Object object2 = this.getOutputPropDefaultKeys();
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            object = object3.next();
            string = this.getOutputPropertyDefault((String)object);
            properties.put(object, string);
        }
        object2 = new Properties(properties);
        object3 = this.getOutputPropKeys();
        object = object3.iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            String string2 = this.getOutputPropertyNonDefault(string);
            if (string2 == null) continue;
            ((Hashtable)object2).put(string, string2);
        }
        return object2;
    }

    @Override
    public void setWriter(Writer writer) {
        this.setWriterInternal(writer, true);
    }

    private void setWriterInternal(Writer writer, boolean bl) {
        this.m_writer_set_by_user = bl;
        this.m_writer = writer;
        if (this.m_tracer != null) {
            boolean bl2 = true;
            Writer writer2 = this.m_writer;
            while (writer2 instanceof WriterChain) {
                if (writer2 instanceof SerializerTraceWriter) {
                    bl2 = false;
                    break;
                }
                writer2 = ((WriterChain)((Object)writer2)).getWriter();
            }
            if (bl2) {
                this.m_writer = new SerializerTraceWriter(this.m_writer, this.m_tracer);
            }
        }
    }

    public boolean setLineSepUse(boolean bl) {
        boolean bl2 = this.m_lineSepUse;
        this.m_lineSepUse = bl;
        return bl2;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.setOutputStreamInternal(outputStream, true);
    }

    private void setOutputStreamInternal(OutputStream outputStream, boolean bl) {
        this.m_outputStream = outputStream;
        String string = this.getOutputProperty("encoding");
        if ("UTF-8".equalsIgnoreCase(string)) {
            try {
                this.setWriterInternal(new WriterToUTF8Buffered(outputStream), false);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        } else if ("WINDOWS-1250".equals(string) || "US-ASCII".equals(string) || "ASCII".equals(string)) {
            this.setWriterInternal(new WriterToASCI(outputStream), false);
        } else if (string != null) {
            Writer writer = null;
            try {
                writer = Encodings.getWriter(outputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                writer = null;
            }
            if (writer == null) {
                System.out.println("Warning: encoding \"" + string + "\" not supported, using " + "UTF-8");
                string = "UTF-8";
                this.setEncoding(string);
                try {
                    writer = Encodings.getWriter(outputStream, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            this.setWriterInternal(writer, false);
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            this.setWriterInternal(outputStreamWriter, false);
        }
    }

    @Override
    public boolean setEscaping(boolean bl) {
        boolean bl2 = this.m_escaping;
        this.m_escaping = bl;
        return bl2;
    }

    protected void indent(int n) throws IOException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_indentAmount > 0) {
            this.printSpace(n * this.m_indentAmount);
        }
    }

    protected void indent() throws IOException {
        this.indent(this.m_elemContext.m_currentElemDepth);
    }

    private void printSpace(int n) throws IOException {
        Writer writer = this.m_writer;
        for (int i = 0; i < n; ++i) {
            writer.write(32);
        }
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            Writer writer = this.m_writer;
            this.DTDprolog();
            writer.write("<!ATTLIST ");
            writer.write(string);
            writer.write(32);
            writer.write(string2);
            writer.write(32);
            writer.write(string3);
            if (string4 != null) {
                writer.write(32);
                writer.write(string4);
            }
            writer.write(62);
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public Writer getWriter() {
        return this.m_writer;
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        try {
            this.DTDprolog();
            this.m_writer.write("<!ENTITY ");
            this.m_writer.write(string);
            if (string2 != null) {
                this.m_writer.write(" PUBLIC \"");
                this.m_writer.write(string2);
            } else {
                this.m_writer.write(" SYSTEM \"");
                this.m_writer.write(string3);
            }
            this.m_writer.write("\" >");
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected boolean escapingNotNeeded(char c) {
        boolean bl = c < '\u007f' ? c >= ' ' || '\n' == c || '\r' == c || '\t' == c : this.m_encodingInfo.isInEncoding(c);
        return bl;
    }

    protected int writeUTF16Surrogate(char c, char[] cArray, int n, int n2) throws IOException, SAXException {
        char c2;
        char c3;
        int n3 = -1;
        if (n + 1 >= n2) {
            this.m_highSurrogate = c;
            return n3;
        }
        if (this.m_highSurrogate == '\u0000') {
            c3 = c;
            c2 = cArray[n + 1];
            n3 = 0;
        } else {
            c3 = this.m_highSurrogate;
            c2 = c;
            this.m_highSurrogate = '\u0000';
        }
        if (!Encodings.isLowUTF16Surrogate(c2)) {
            this.throwIOE(c3, c2);
        }
        Writer writer = this.m_writer;
        if (this.m_encodingInfo.isInEncoding(c3, c2)) {
            writer.write(new char[]{c3, c2}, 0, 2);
        } else {
            String string = this.getEncoding();
            if (string != null) {
                n3 = this.writeCharRef(writer, c3, c2);
            } else {
                writer.write(new char[]{c3, c2}, 0, 2);
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int accumDefaultEntity(Writer writer, char c, int n, char[] cArray, int n2, boolean bl, boolean bl2) throws IOException {
        if (!bl2 && '\n' == c) {
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            return n + 1;
        } else {
            if ((!bl || !this.m_charInfo.isSpecialTextChar(c)) && (bl || !this.m_charInfo.isSpecialAttrChar(c))) return n;
            String string = this.m_charInfo.getOutputStringForChar(c);
            if (null == string) return n;
            writer.write(string);
        }
        return n + 1;
    }

    void writeNormalizedChars(char[] cArray, int n, int n2, boolean bl, boolean bl2) throws IOException, SAXException {
        Writer writer = this.m_writer;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if ('\n' == c && bl2) {
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                continue;
            }
            if (bl && !this.escapingNotNeeded(c)) {
                i = this.handleEscaping(writer, c, cArray, i, n3);
                continue;
            }
            if (bl && i < n3 - 2 && ']' == c && ']' == cArray[i + 1] && '>' == cArray[i + 2]) {
                writer.write("]]]]><![CDATA[>");
                i += 2;
                continue;
            }
            if (this.escapingNotNeeded(c)) {
                if (bl && !this.m_cdataTagOpen) {
                    writer.write("<![CDATA[");
                    this.m_cdataTagOpen = true;
                }
                writer.write(c);
                continue;
            }
            i = this.handleEscaping(writer, c, cArray, i, n3);
        }
    }

    private int handleEscaping(Writer writer, char c, char[] cArray, int n, int n2) throws IOException, SAXException {
        if (Encodings.isHighUTF16Surrogate(c) || Encodings.isLowUTF16Surrogate(c)) {
            if (this.writeUTF16Surrogate(c, cArray, n, n2) >= 0 && Encodings.isHighUTF16Surrogate(c)) {
                ++n;
            }
        } else {
            this.writeCharRef(writer, c);
        }
        return n;
    }

    public void endNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.pop();
    }

    public void startNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.push(true);
    }

    protected void cdata(char[] cArray, int n, int n2) throws SAXException {
        try {
            boolean bl;
            int n3 = n;
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            }
            this.m_ispreserve = true;
            if (!this.m_cdataTagOpen && this.shouldIndent()) {
                this.indent();
            }
            boolean bl2 = bl = n2 >= 1 && this.escapingNotNeeded(cArray[n]);
            if (bl && !this.m_cdataTagOpen) {
                this.m_writer.write("<![CDATA[");
                this.m_cdataTagOpen = true;
            }
            if (this.isEscapingDisabled()) {
                this.charactersRaw(cArray, n, n2);
            } else {
                this.writeNormalizedChars(cArray, n, n2, true, this.m_lineSepUse);
            }
            if (bl && cArray[n + n2 - 1] == ']') {
                this.closeCDATA();
            }
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n3, n2);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(Utils.messages.createMessage("ER_OIERROR", null), iOException);
        }
    }

    private boolean isEscapingDisabled() {
        return this.m_disableOutputEscapingStates.peekOrFalse();
    }

    protected void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        try {
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            }
            this.m_ispreserve = true;
            this.m_writer.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0 || this.m_inEntityRef && !this.m_expandDTDEntities) {
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_cdataStartCalled || this.m_elemContext.m_isCdataSection) {
            this.cdata(cArray, n, n2);
            return;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
            this.charactersRaw(cArray, n, n2);
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n, n2);
            }
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        }
        try {
            int n3;
            char c;
            char c2;
            int n4;
            int n5 = n + n2;
            int n6 = n - 1;
            for (n4 = n; n4 < n5 && ((c2 = cArray[n4]) == ' ' || c2 == '\n' && this.m_lineSepUse || c2 == '\r' || c2 == '\t'); ++n4) {
                if (this.m_charInfo.isTextASCIIClean(c2)) continue;
                n4 = n6 = this.processDirty(cArray, n5, n4, c2, n6, true);
            }
            if (n4 < n5) {
                this.m_ispreserve = true;
            }
            boolean bl = "1.0".equals(this.getVersion());
            while (n4 < n5) {
                while (n4 < n5 && (c = cArray[n4]) < '\u007f' && this.m_charInfo.isTextASCIIClean(c)) {
                    ++n4;
                }
                if (n4 == n5) break;
                c = cArray[n4];
                if ((ToStream.isCharacterInC0orC1Range(c) || !bl && ToStream.isNELorLSEPCharacter(c) || !this.escapingNotNeeded(c) || this.m_charInfo.isSpecialTextChar(c)) && '\"' != c) {
                    n4 = n6 = this.processDirty(cArray, n5, n4, c, n6, true);
                }
                ++n4;
            }
            if (n4 > (n3 = n6 + 1)) {
                c = n4 - n3;
                this.m_writer.write(cArray, n3, (int)c);
            }
            this.m_isprevtext = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (this.m_tracer != null) {
            super.fireCharEvent(cArray, n, n2);
        }
    }

    private static boolean isCharacterInC0orC1Range(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return false;
        }
        return c >= '\u007f' && c <= '\u009f' || c >= '\u0001' && c <= '\u001f';
    }

    private static boolean isNELorLSEPCharacter(char c) {
        return c == '\u0085' || c == '\u2028';
    }

    private int processDirty(char[] cArray, int n, int n2, char c, int n3, boolean bl) throws IOException, SAXException {
        int n4 = n3 + 1;
        if (n2 > n4) {
            int n5 = n2 - n4;
            this.m_writer.write(cArray, n4, n5);
        }
        if ('\n' == c && bl) {
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        } else {
            n4 = this.accumDefaultEscape(this.m_writer, c, n2, cArray, n, bl, false);
            n2 = n4 - 1;
        }
        return n2;
    }

    @Override
    public void characters(String string) throws SAXException {
        if (this.m_inEntityRef && !this.m_expandDTDEntities) {
            return;
        }
        int n = string.length();
        if (n > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_charsBuff, 0);
        this.characters(this.m_charsBuff, 0, n);
    }

    protected int accumDefaultEscape(Writer writer, char c, int n, char[] cArray, int n2, boolean bl, boolean bl2) throws IOException, SAXException {
        int n3 = this.accumDefaultEntity(writer, c, n, cArray, n2, bl, bl2);
        if (n == n3) {
            if (this.m_highSurrogate != '\u0000') {
                if (!Encodings.isLowUTF16Surrogate(c)) {
                    this.throwIOE(this.m_highSurrogate, c);
                }
                this.writeCharRef(writer, this.m_highSurrogate, c);
                this.m_highSurrogate = '\u0000';
                return ++n3;
            }
            if (Encodings.isHighUTF16Surrogate(c)) {
                if (n + 1 >= n2) {
                    this.m_highSurrogate = c;
                    ++n3;
                } else {
                    char c2;
                    if (!Encodings.isLowUTF16Surrogate(c2 = cArray[++n])) {
                        this.throwIOE(c, c2);
                    }
                    this.writeCharRef(writer, c, c2);
                    n3 += 2;
                }
            } else {
                if (ToStream.isCharacterInC0orC1Range(c) || "1.1".equals(this.getVersion()) && ToStream.isNELorLSEPCharacter(c)) {
                    this.writeCharRef(writer, c);
                } else if ((!this.escapingNotNeeded(c) || bl && this.m_charInfo.isSpecialTextChar(c) || !bl && this.m_charInfo.isSpecialAttrChar(c)) && this.m_elemContext.m_currentElemDepth > 0) {
                    this.writeCharRef(writer, c);
                } else {
                    writer.write(c);
                }
                ++n3;
            }
        }
        return n3;
    }

    private void writeCharRef(Writer writer, char c) throws IOException, SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        writer.write("&#");
        writer.write(Integer.toString(c));
        writer.write(59);
    }

    private int writeCharRef(Writer writer, char c, char c2) throws IOException, SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        int n = Encodings.toCodePoint(c, c2);
        writer.write("&#");
        writer.write(Integer.toString(n));
        writer.write(59);
        return n;
    }

    private void throwIOE(char c, char c2) throws IOException {
        throw new IOException(Utils.messages.createMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c) + " " + Integer.toHexString(c2)}));
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            if (this.m_needToOutputDocTypeDecl && null != this.getDoctypeSystem()) {
                this.outputDocTypeDecl(string3, true);
            }
            this.m_needToOutputDocTypeDecl = false;
            if (this.m_elemContext.m_startTagOpen) {
                this.closeStartTag();
                this.m_elemContext.m_startTagOpen = false;
            }
            if (string != null) {
                this.ensurePrefixIsDeclared(string, string3);
            }
            this.m_ispreserve = false;
            if (this.shouldIndent() && this.m_startNewLine) {
                this.indent();
            }
            this.m_startNewLine = true;
            Writer writer = this.m_writer;
            writer.write(60);
            writer.write(string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (attributes != null) {
            this.addAttributes(attributes);
        }
        this.m_elemContext = this.m_elemContext.push(string, string2, string3);
        this.m_isprevtext = false;
        if (this.m_tracer != null) {
            this.firePseudoAttributes();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3) throws SAXException {
        this.startElement(string, string2, string3, null);
    }

    @Override
    public void startElement(String string) throws SAXException {
        this.startElement(null, null, string, null);
    }

    void outputDocTypeDecl(String string, boolean bl) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            char c;
            String string2;
            Writer writer = this.m_writer;
            writer.write("<!DOCTYPE ");
            writer.write(string);
            String string3 = this.getDoctypePublic();
            if (null != string3) {
                writer.write(" PUBLIC \"");
                writer.write(string3);
                writer.write(34);
            }
            if (null != (string2 = this.getDoctypeSystem())) {
                c = JdkXmlUtils.getQuoteChar(string2);
                if (null == string3) {
                    writer.write(" SYSTEM");
                }
                writer.write(" ");
                writer.write(c);
                writer.write(string2);
                writer.write(c);
                if (bl) {
                    writer.write(">");
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    bl = false;
                }
            }
            if ((c = '\u0000') != '\u0000' && bl) {
                writer.write(62);
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processAttributes(Writer writer, int n) throws IOException, SAXException {
        String string = this.getEncoding();
        for (int i = 0; i < n; ++i) {
            String string2 = this.m_attributes.getQName(i);
            String string3 = this.m_attributes.getValue(i);
            writer.write(32);
            writer.write(string2);
            writer.write("=\"");
            this.writeAttrString(writer, string3, string);
            writer.write(34);
        }
    }

    public void writeAttrString(Writer writer, String string, String string2) throws IOException, SAXException {
        int n = string.length();
        if (n > this.m_attrBuff.length) {
            this.m_attrBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_attrBuff, 0);
        char[] cArray = this.m_attrBuff;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.escapingNotNeeded(c) && !this.m_charInfo.isSpecialAttrChar(c)) {
                writer.write(c);
                ++n2;
                continue;
            }
            n2 = this.accumDefaultEscape(writer, c, n2, cArray, n, false, true);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_prefixMap.popNamespaces(this.m_elemContext.m_currentElemDepth, null);
        try {
            Writer writer = this.m_writer;
            if (this.m_elemContext.m_startTagOpen) {
                int n;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elemContext.m_elementName);
                }
                if ((n = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(this.m_writer, n);
                    this.m_attributes.clear();
                }
                if (this.m_spaceBeforeClose) {
                    writer.write(" />");
                } else {
                    writer.write("/>");
                }
            } else {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                if (this.shouldIndent()) {
                    this.indent(this.m_elemContext.m_currentElemDepth - 1);
                }
                writer.write(60);
                writer.write(47);
                writer.write(string3);
                writer.write(62);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (!this.m_elemContext.m_startTagOpen && this.m_doIndent) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
        this.m_elemContext = this.m_elemContext.m_prev;
    }

    @Override
    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.startPrefixMapping(string, string2, true);
    }

    @Override
    public boolean startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        int n;
        if (bl) {
            this.flushPending();
            n = this.m_elemContext.m_currentElemDepth + 1;
        } else {
            n = this.m_elemContext.m_currentElemDepth;
        }
        boolean bl2 = this.m_prefixMap.pushNamespace(string, string2, n);
        if (bl2) {
            if ("".equals(string)) {
                String string3 = "xmlns";
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string3, string3, "CDATA", string2, false);
            } else if (!"".equals(string2)) {
                String string4 = "xmlns:" + string;
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string, string4, "CDATA", string2, false);
            }
        }
        return bl2;
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        int n3 = n;
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        try {
            int n4;
            if (this.shouldIndent() && this.m_isStandalone) {
                this.indent();
            }
            int n5 = n + n2;
            boolean bl = false;
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
            }
            if (this.shouldIndent() && !this.m_isStandalone) {
                this.indent();
            }
            Writer writer = this.m_writer;
            writer.write(COMMENT_BEGIN);
            for (n4 = n; n4 < n5; ++n4) {
                if (bl && cArray[n4] == '-') {
                    writer.write(cArray, n, n4 - n);
                    writer.write(" -");
                    n = n4 + 1;
                }
                bl = cArray[n4] == '-';
            }
            if (n2 > 0) {
                n4 = n5 - n;
                if (n4 > 0) {
                    writer.write(cArray, n, n4);
                }
                if (cArray[n5 - 1] == '-') {
                    writer.write(32);
                }
            }
            writer.write(COMMENT_END);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.m_startNewLine = true;
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n3, n2);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        this.m_cdataStartCalled = false;
    }

    @Override
    public void endDTD() throws SAXException {
        try {
            if (this.m_needToCallStartDocument) {
                return;
            }
            if (this.m_needToOutputDocTypeDecl) {
                this.outputDocTypeDecl(this.m_elemContext.m_elementName, false);
                this.m_needToOutputDocTypeDecl = false;
            }
            Writer writer = this.m_writer;
            if (!this.m_inDoctype) {
                writer.write("]>");
            } else {
                writer.write(62);
            }
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (0 == n2) {
            return;
        }
        this.characters(cArray, n, n2);
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_cdataStartCalled = true;
    }

    @Override
    public void startEntity(String string) throws SAXException {
        if (string.equals("[dtd]")) {
            this.m_inExternalDTD = true;
        }
        if (!this.m_expandDTDEntities && !this.m_inExternalDTD) {
            this.startNonEscaping();
            this.characters("&" + string + ';');
            this.endNonEscaping();
        }
        this.m_inEntityRef = true;
    }

    protected void closeStartTag() throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            try {
                int n;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elemContext.m_elementName);
                }
                if ((n = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(this.m_writer, n);
                    this.m_attributes.clear();
                }
                this.m_writer.write(62);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            if (this.m_StringOfCDATASections != null) {
                this.m_elemContext.m_isCdataSection = this.isCdataSection();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
                this.m_preserves.push(this.m_ispreserve);
            }
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.setDoctypeSystem(string3);
        this.setDoctypePublic(string2);
        this.m_elemContext.m_elementName = string;
        this.m_inDoctype = true;
    }

    @Override
    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    @Override
    public void setIndentAmount(int n) {
        this.m_indentAmount = n;
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext && (this.m_elemContext.m_currentElemDepth > 0 || this.m_isStandalone);
    }

    private void setCdataSectionElements(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (null != string2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = string2.length();
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!bl) {
                        if (stringBuilder.length() <= 0) continue;
                        this.addCdataSectionElement(stringBuilder.toString(), arrayList);
                        stringBuilder.setLength(0);
                        continue;
                    }
                } else if ('{' == c) {
                    bl = true;
                } else if ('}' == c) {
                    bl = false;
                }
                stringBuilder.append(c);
            }
            if (stringBuilder.length() > 0) {
                this.addCdataSectionElement(stringBuilder.toString(), arrayList);
                stringBuilder.setLength(0);
            }
            this.setCdataSectionElements(arrayList);
        }
    }

    private void addCdataSectionElement(String string, List<String> list) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", false);
        String string3 = stringTokenizer.nextToken();
        String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        if (null == string2) {
            list.add(null);
            list.add(string3);
        } else {
            list.add(string3);
            list.add(string2);
        }
    }

    @Override
    public void setCdataSectionElements(List<String> list) {
        int n;
        if (list != null && (n = list.size() - 1) > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; i += 2) {
                if (i != 0) {
                    stringBuilder.append(' ');
                }
                String string = list.get(i);
                String string2 = list.get(i + 1);
                if (string != null) {
                    stringBuilder.append('{');
                    stringBuilder.append(string);
                    stringBuilder.append('}');
                }
                stringBuilder.append(string2);
            }
            this.m_StringOfCDATASections = stringBuilder.toString();
        }
        this.initCdataElems(this.m_StringOfCDATASections);
    }

    protected String ensureAttributesNamespaceIsDeclared(String string, String string2, String string3) throws SAXException {
        if (string != null && string.length() > 0) {
            String string4;
            int n = 0;
            n = string3.indexOf(":");
            String string5 = string4 = n < 0 ? "" : string3.substring(0, n);
            if (n > 0) {
                String string6 = this.m_prefixMap.lookupNamespace(string4);
                if (string6 != null && string6.equals(string)) {
                    return null;
                }
                this.startPrefixMapping(string4, string, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", string4, "xmlns:" + string4, "CDATA", string, false);
                return string4;
            }
            String string7 = this.m_prefixMap.lookupPrefix(string);
            if (string7 == null) {
                string7 = this.m_prefixMap.generateNextPrefix();
                this.startPrefixMapping(string7, string, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", string7, "xmlns:" + string7, "CDATA", string, false);
            }
            return string7;
        }
        return null;
    }

    void ensurePrefixIsDeclared(String string, String string2) throws SAXException {
        if (string != null && string.length() > 0) {
            String string3;
            String string4;
            int n = string2.indexOf(":");
            boolean bl = n < 0;
            String string5 = string4 = bl ? "" : string2.substring(0, n);
            if (!(null == string4 || null != (string3 = this.m_prefixMap.lookupNamespace(string4)) && string3.equals(string))) {
                this.startPrefixMapping(string4, string);
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", bl ? "xmlns" : string4, bl ? "xmlns" : "xmlns:" + string4, "CDATA", string, false);
            }
        }
    }

    @Override
    public void flushPending() throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        if (this.m_elemContext.m_startTagOpen) {
            this.closeStartTag();
            this.m_elemContext.m_startTagOpen = false;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        }
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
    }

    @Override
    public boolean addAttributeAlways(String string, String string2, String string3, String string4, String string5, boolean bl) {
        boolean bl2;
        int n = this.m_attributes.getIndex(string3);
        if (n >= 0) {
            String string6 = null;
            if (this.m_tracer != null && string5.equals(string6 = this.m_attributes.getValue(n))) {
                string6 = null;
            }
            this.m_attributes.setValue(n, string5);
            bl2 = false;
            if (string6 != null) {
                this.firePseudoAttributes();
            }
        } else {
            if (bl) {
                String string7;
                NamespaceMappings.MappingRecord mappingRecord;
                int n2 = string3.indexOf(58);
                if (n2 > 0 && (mappingRecord = this.m_prefixMap.getMappingFromPrefix(string7 = string3.substring(0, n2))) != null && mappingRecord.m_declarationDepth == this.m_elemContext.m_currentElemDepth && !mappingRecord.m_uri.equals(string)) {
                    string7 = this.m_prefixMap.lookupPrefix(string);
                    if (string7 == null) {
                        string7 = this.m_prefixMap.generateNextPrefix();
                    }
                    string3 = string7 + ':' + string2;
                }
                try {
                    string7 = this.ensureAttributesNamespaceIsDeclared(string, string2, string3);
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            }
            this.m_attributes.addAttribute(string, string2, string3, string4, string5);
            bl2 = true;
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
        }
        return bl2;
    }

    protected void firePseudoAttributes() {
        if (this.m_tracer != null) {
            try {
                Object object;
                this.m_writer.flush();
                StringBuffer stringBuffer = new StringBuffer();
                int n = this.m_attributes.getLength();
                if (n > 0) {
                    object = new WritertoStringBuffer(stringBuffer);
                    this.processAttributes((Writer)object, n);
                }
                stringBuffer.append('>');
                object = stringBuffer.toString().toCharArray();
                this.m_tracer.fireGenerateEvent(11, (char[])object, 0, ((Object)object).length);
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setTransformer(Transformer transformer) {
        super.setTransformer(transformer);
        if (this.m_tracer != null && !(this.m_writer instanceof SerializerTraceWriter)) {
            this.m_writer = new SerializerTraceWriter(this.m_writer, this.m_tracer);
        }
    }

    @Override
    public boolean reset() {
        boolean bl = false;
        if (super.reset()) {
            this.resetToStream();
            bl = true;
        }
        return bl;
    }

    private void resetToStream() {
        this.m_cdataStartCalled = false;
        this.m_disableOutputEscapingStates.clear();
        this.m_escaping = true;
        this.m_inDoctype = false;
        this.m_ispreserve = false;
        this.m_ispreserve = false;
        this.m_isprevtext = false;
        this.m_isUTF8 = false;
        this.m_preserves.clear();
        this.m_shouldFlush = true;
        this.m_spaceBeforeClose = false;
        this.m_startNewLine = false;
        this.m_lineSepUse = true;
        this.m_expandDTDEntities = true;
    }

    @Override
    public void setEncoding(String string) {
        this.setOutputProperty("encoding", string);
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        try {
            this.DTDprolog();
            this.m_writer.write("<!NOTATION ");
            this.m_writer.write(string);
            if (string2 != null) {
                this.m_writer.write(" PUBLIC \"");
                this.m_writer.write(string2);
            } else {
                this.m_writer.write(" SYSTEM \"");
                this.m_writer.write(string3);
            }
            this.m_writer.write("\" >");
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        try {
            this.DTDprolog();
            this.m_writer.write("<!ENTITY ");
            this.m_writer.write(string);
            if (string2 != null) {
                this.m_writer.write(" PUBLIC \"");
                this.m_writer.write(string2);
            } else {
                this.m_writer.write(" SYSTEM \"");
                this.m_writer.write(string3);
            }
            this.m_writer.write("\" NDATA ");
            this.m_writer.write(string4);
            this.m_writer.write(" >");
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void DTDprolog() throws SAXException, IOException {
        Writer writer = this.m_writer;
        if (this.m_needToOutputDocTypeDecl) {
            this.outputDocTypeDecl(this.m_elemContext.m_elementName, false);
            this.m_needToOutputDocTypeDecl = false;
        }
        if (this.m_inDoctype) {
            writer.write(" [");
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            this.m_inDoctype = false;
        }
    }

    @Override
    public void setDTDEntityExpansion(boolean bl) {
        this.m_expandDTDEntities = bl;
    }

    public void addCdataSectionElements(String string) {
        if (string != null) {
            this.initCdataElems(string);
        }
        this.m_StringOfCDATASections = this.m_StringOfCDATASections == null ? string : this.m_StringOfCDATASections + " " + string;
    }

    static final class BoolStack {
        private boolean[] m_values;
        private int m_allocatedSize;
        private int m_index;

        public BoolStack() {
            this(32);
        }

        public BoolStack(int n) {
            this.m_allocatedSize = n;
            this.m_values = new boolean[n];
            this.m_index = -1;
        }

        public final int size() {
            return this.m_index + 1;
        }

        public final void clear() {
            this.m_index = -1;
        }

        public final boolean push(boolean bl) {
            if (this.m_index == this.m_allocatedSize - 1) {
                this.grow();
            }
            boolean bl2 = bl;
            this.m_values[++this.m_index] = bl2;
            return bl2;
        }

        public final boolean pop() {
            return this.m_values[this.m_index--];
        }

        public final boolean popAndTop() {
            --this.m_index;
            return this.m_index >= 0 ? this.m_values[this.m_index] : false;
        }

        public final void setTop(boolean bl) {
            this.m_values[this.m_index] = bl;
        }

        public final boolean peek() {
            return this.m_values[this.m_index];
        }

        public final boolean peekOrFalse() {
            return this.m_index > -1 ? this.m_values[this.m_index] : false;
        }

        public final boolean peekOrTrue() {
            return this.m_index > -1 ? this.m_values[this.m_index] : true;
        }

        public boolean isEmpty() {
            return this.m_index == -1;
        }

        private void grow() {
            this.m_allocatedSize *= 2;
            boolean[] blArray = new boolean[this.m_allocatedSize];
            System.arraycopy(this.m_values, 0, blArray, 0, this.m_index + 1);
            this.m_values = blArray;
        }
    }

    private class WritertoStringBuffer
    extends Writer {
        private final StringBuffer m_stringbuf;

        WritertoStringBuffer(StringBuffer stringBuffer) {
            this.m_stringbuf = stringBuffer;
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            this.m_stringbuf.append(cArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void write(int n) {
            this.m_stringbuf.append((char)n);
        }

        @Override
        public void write(String string) {
            this.m_stringbuf.append(string);
        }
    }
}

