/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.CC_ClassWriter;
import codechicken.core.asm.InsnListPrinter;
import codechicken.core.asm.InstructionComparator;
import codechicken.core.asm.ObfuscationMappings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class ASMHelper {
    public static MethodNode findMethod(ObfuscationMappings.DescriptorMapping methodmap, ClassNode cnode) {
        for (MethodNode mnode : cnode.methods) {
            if (!methodmap.matches(mnode)) continue;
            return mnode;
        }
        return null;
    }

    public static FieldNode findField(ObfuscationMappings.DescriptorMapping fieldmap, ClassNode cnode) {
        for (FieldNode fnode : cnode.fields) {
            if (!fieldmap.matches(fnode)) continue;
            return fnode;
        }
        return null;
    }

    public static ClassNode createClassNode(byte[] bytes) {
        return ASMHelper.createClassNode(bytes, 0);
    }

    public static ClassNode createClassNode(byte[] bytes, int flags) {
        ClassNode cnode = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)cnode, flags);
        return cnode;
    }

    public static byte[] createBytes(ClassNode cnode, int flags) {
        CC_ClassWriter cw2 = new CC_ClassWriter(flags);
        cnode.accept((ClassVisitor)cw2);
        return cw2.toByteArray();
    }

    public static byte[] writeMethods(String name, byte[] bytes, Multimap writers) {
        if (writers.containsKey((Object)name)) {
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            for (MethodWriter mw : writers.get((Object)name)) {
                MethodNode mv2 = ASMHelper.findMethod(mw.method, cnode);
                if (mv2 == null) {
                    mv2 = (MethodNode)cnode.visitMethod(mw.access, mw.method.s_name, mw.method.s_desc, null, mw.exceptions);
                }
                mv2.access = mw.access;
                mv2.instructions.clear();
                mw.write(mv2);
            }
            bytes = ASMHelper.createBytes(cnode, 3);
        }
        return bytes;
    }

    public static byte[] injectMethods(String name, byte[] bytes, Multimap injectors) {
        if (injectors.containsKey((Object)name)) {
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            for (MethodInjector injector : injectors.get((Object)name)) {
                MethodNode method = ASMHelper.findMethod(injector.method, cnode);
                if (method == null) {
                    throw new RuntimeException("Method not found: " + injector.method);
                }
                System.out.println("Injecting into " + injector.method + "\n" + ASMHelper.printInsnList(injector.injection));
                List callNodes = injector.before ? InstructionComparator.insnListFindStart(method.instructions, injector.needle) : InstructionComparator.insnListFindEnd(method.instructions, injector.needle);
                if (callNodes.size() == 0) {
                    throw new RuntimeException("Needle not found in Haystack: " + injector.method + "\n" + ASMHelper.printInsnList(injector.needle));
                }
                for (AbstractInsnNode node : callNodes) {
                    if (injector.before) {
                        System.out.println("Injected before: " + ASMHelper.printInsn(node));
                        method.instructions.insertBefore(node, ASMHelper.cloneInsnList(injector.injection));
                        continue;
                    }
                    System.out.println("Injected after: " + ASMHelper.printInsn(node));
                    method.instructions.insert(node, ASMHelper.cloneInsnList(injector.injection));
                }
            }
            bytes = ASMHelper.createBytes(cnode, 2);
        }
        return bytes;
    }

    public static String printInsnList(InsnList list) {
        InsnListPrinter p = new InsnListPrinter();
        p.visitInsnList(list);
        return p.textString();
    }

    public static String printInsn(AbstractInsnNode insn) {
        InsnListPrinter p = new InsnListPrinter();
        p.visitInsn(insn);
        return p.textString();
    }

    public static Map cloneLabels(InsnList insns) {
        HashMap<LabelNode, LabelNode> labelMap = new HashMap<LabelNode, LabelNode>();
        AbstractInsnNode insn = insns.getFirst();
        while (insn != null) {
            if (insn.getType() == 8) {
                labelMap.put((LabelNode)insn, new LabelNode());
            }
            insn = insn.getNext();
        }
        return labelMap;
    }

    public static InsnList cloneInsnList(InsnList insns) {
        return ASMHelper.cloneInsnList(ASMHelper.cloneLabels(insns), insns);
    }

    public static InsnList cloneInsnList(Map labelMap, InsnList insns) {
        InsnList clone = new InsnList();
        AbstractInsnNode insn = insns.getFirst();
        while (insn != null) {
            clone.add(insn.clone(labelMap));
            insn = insn.getNext();
        }
        return clone;
    }

    public static List cloneTryCatchBlocks(Map labelMap, List tcblocks) {
        ArrayList<TryCatchBlockNode> clone = new ArrayList<TryCatchBlockNode>();
        for (TryCatchBlockNode node : tcblocks) {
            clone.add(new TryCatchBlockNode((LabelNode)labelMap.get(node.start), (LabelNode)labelMap.get(node.end), (LabelNode)labelMap.get(node.handler), node.type));
        }
        return clone;
    }

    public static List cloneLocals(Map labelMap, List locals) {
        ArrayList<LocalVariableNode> clone = new ArrayList<LocalVariableNode>();
        for (LocalVariableNode node : locals) {
            clone.add(new LocalVariableNode(node.name, node.desc, node.signature, (LabelNode)labelMap.get(node.start), (LabelNode)labelMap.get(node.end), node.index));
        }
        return clone;
    }

    public static void copy(MethodNode src, MethodNode dst) {
        Map labelMap = ASMHelper.cloneLabels(src.instructions);
        dst.instructions = ASMHelper.cloneInsnList(labelMap, src.instructions);
        dst.tryCatchBlocks = ASMHelper.cloneTryCatchBlocks(labelMap, src.tryCatchBlocks);
        if (src.localVariables != null) {
            dst.localVariables = ASMHelper.cloneLocals(labelMap, src.localVariables);
        }
        dst.visibleAnnotations = src.visibleAnnotations;
        dst.invisibleAnnotations = src.invisibleAnnotations;
        dst.visitMaxs(src.maxStack, src.maxLocals);
    }

    public static byte[] alterMethods(String name, byte[] bytes, HashMultimap altercators) {
        if (altercators.containsKey((Object)name)) {
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            for (MethodAltercator injector : altercators.get((Object)name)) {
                MethodNode method = ASMHelper.findMethod(injector.method, cnode);
                if (method == null) {
                    throw new RuntimeException("Method not found: " + injector.method);
                }
                injector.alter(method);
            }
            bytes = ASMHelper.createBytes(cnode, 3);
        }
        return bytes;
    }

    public static String printInsnList(InstructionComparator.InsnListSection subsection) {
        InsnListPrinter p = new InsnListPrinter();
        p.visitInsnList(subsection);
        return p.textString();
    }

    public static int getLocal(List list, String name) {
        int found = -1;
        for (LocalVariableNode node : list) {
            if (!node.name.equals(name)) continue;
            if (found >= 0) {
                throw new RuntimeException("Duplicate local variable: " + name + " not coded to handle this scenario.");
            }
            found = node.index;
        }
        return found;
    }

    public static void replaceMethodCode(MethodNode original, MethodNode replacement) {
        original.instructions.clear();
        if (original.localVariables != null) {
            original.localVariables.clear();
        }
        if (original.tryCatchBlocks != null) {
            original.tryCatchBlocks.clear();
        }
        replacement.accept((MethodVisitor)original);
    }

    public static void removeBlock(InsnList insns, InstructionComparator.InsnListSection block) {
        AbstractInsnNode insn = block.first;
        while (true) {
            AbstractInsnNode next = insn.getNext();
            insns.remove(insn);
            if (insn == block.last) break;
            insn = next;
        }
    }

    public static class CodeBlock {
        public Label start = new Label();
        public Label end = new Label();
    }

    public static class ForBlock
    extends CodeBlock {
        public Label cmp = new Label();
        public Label inc = new Label();
        public Label body = new Label();
    }

    public static abstract class MethodAltercator {
        public final ObfuscationMappings.DescriptorMapping method;

        public MethodAltercator(ObfuscationMappings.DescriptorMapping method) {
            this.method = method;
        }

        public abstract void alter(MethodNode var1);
    }

    public static class MethodInjector {
        public final ObfuscationMappings.DescriptorMapping method;
        public final InsnList needle;
        public final InsnList injection;
        public final boolean before;

        public MethodInjector(ObfuscationMappings.DescriptorMapping method, InsnList needle, InsnList injection, boolean before) {
            this.method = method;
            this.needle = needle;
            this.injection = injection;
            this.before = before;
        }
    }

    public static abstract class MethodWriter {
        public final int access;
        public final ObfuscationMappings.DescriptorMapping method;
        public final String[] exceptions;

        public MethodWriter(int access, ObfuscationMappings.DescriptorMapping method) {
            this(access, method, null);
        }

        public MethodWriter(int access, ObfuscationMappings.DescriptorMapping method, String[] exceptions) {
            this.access = access;
            this.method = method;
            this.exceptions = exceptions;
        }

        public abstract void write(MethodNode var1);
    }
}

