/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.EnumSet;

public class BiomeDictionary {
    private static final int BIOME_LIST_SIZE = 256;
    private static BiomeInfo[] biomeList = new BiomeInfo[256];
    private static ArrayList<aav>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerBiomeType(aav biome, Type ... types) {
        if (aav.a[biome.N] != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    BiomeDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(biome);
            }
            if (biomeList[biome.N] == null) {
                BiomeDictionary.biomeList[biome.N] = new BiomeInfo(types);
            } else {
                for (Type type : types) {
                    BiomeDictionary.biomeList[biome.N].typeList.add(type);
                }
            }
            return true;
        }
        return false;
    }

    public static aav[] getBiomesForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new aav[0]);
        }
        return new aav[0];
    }

    public static Type[] getTypesForBiome(aav biome) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.N] != null) {
            return BiomeDictionary.biomeList[biome.N].typeList.toArray(new Type[0]);
        }
        return new Type[0];
    }

    public static boolean areBiomesEquivalent(aav biomeA, aav biomeB) {
        int a2 = biomeA.N;
        int b2 = biomeB.N;
        BiomeDictionary.checkRegistration(biomeA);
        BiomeDictionary.checkRegistration(biomeB);
        if (biomeList[a2] != null && biomeList[b2] != null) {
            for (Type type : BiomeDictionary.biomeList[a2].typeList) {
                if (!BiomeDictionary.containsType(biomeList[b2], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBiomeOfType(aav biome, Type type) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.N] != null) {
            return BiomeDictionary.containsType(biomeList[biome.N], type);
        }
        return false;
    }

    public static boolean isBiomeRegistered(aav biome) {
        return biomeList[biome.N] != null;
    }

    public static boolean isBiomeRegistered(int biomeID) {
        return biomeList[biomeID] != null;
    }

    public static void registerAllBiomes() {
        for (int i2 = 0; i2 < 256; ++i2) {
            if (aav.a[i2] == null) continue;
            BiomeDictionary.checkRegistration(aav.a[i2]);
        }
    }

    public static void makeBestGuess(aav biome) {
        if (biome.I.z >= 3) {
            if (biome.e() && biome.F >= 1.0f) {
                BiomeDictionary.registerBiomeType(biome, Type.JUNGLE);
            } else if (!biome.e()) {
                BiomeDictionary.registerBiomeType(biome, Type.FOREST);
            }
        } else if (biome.E <= 0.3f && biome.E >= 0.0f && (!biome.e() || biome.D >= 0.0f)) {
            BiomeDictionary.registerBiomeType(biome, Type.PLAINS);
        }
        if (biome.e() && biome.D < 0.0f && biome.E <= 0.3f && biome.E >= 0.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.SWAMP);
        }
        if (biome.D <= -0.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.WATER);
        }
        if (biome.E >= 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.MOUNTAIN);
        }
        if (biome.c() || biome.F < 0.2f) {
            BiomeDictionary.registerBiomeType(biome, Type.FROZEN);
        }
        if (!biome.e() && biome.F >= 1.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.DESERT);
        }
    }

    private static void checkRegistration(aav biome) {
        if (!BiomeDictionary.isBiomeRegistered(biome)) {
            BiomeDictionary.makeBestGuess(biome);
        }
    }

    private static boolean containsType(BiomeInfo info, Type type) {
        return info.typeList.contains((Object)type);
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.registerBiomeType(aav.b, Type.WATER);
        BiomeDictionary.registerBiomeType(aav.c, Type.PLAINS);
        BiomeDictionary.registerBiomeType(aav.d, Type.DESERT);
        BiomeDictionary.registerBiomeType(aav.e, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(aav.f, Type.FOREST);
        BiomeDictionary.registerBiomeType(aav.g, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(aav.u, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(aav.h, Type.SWAMP);
        BiomeDictionary.registerBiomeType(aav.i, Type.WATER);
        BiomeDictionary.registerBiomeType(aav.l, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(aav.m, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(aav.n, Type.FROZEN);
        BiomeDictionary.registerBiomeType(aav.o, Type.FROZEN);
        BiomeDictionary.registerBiomeType(aav.r, Type.BEACH);
        BiomeDictionary.registerBiomeType(aav.s, Type.DESERT);
        BiomeDictionary.registerBiomeType(aav.w, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(aav.x, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(aav.t, Type.FOREST);
        BiomeDictionary.registerBiomeType(aav.k, Type.END);
        BiomeDictionary.registerBiomeType(aav.j, Type.NETHER);
        BiomeDictionary.registerBiomeType(aav.p, Type.MUSHROOM);
        BiomeDictionary.registerBiomeType(aav.v, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(aav.q, Type.MUSHROOM, Type.BEACH);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public BiomeInfo(Type[] types) {
            for (Type t2 : types) {
                this.typeList.add(t2);
            }
        }
    }

    public static enum Type {
        FOREST,
        PLAINS,
        MOUNTAIN,
        HILLS,
        SWAMP,
        WATER,
        DESERT,
        FROZEN,
        JUNGLE,
        WASTELAND,
        BEACH,
        NETHER,
        END,
        MUSHROOM,
        MAGICAL;

    }
}

