/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.libraries;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ICodec;
import paulscode.sound.Library;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.Source;
import paulscode.sound.libraries.ChannelJavaSound;
import paulscode.sound.libraries.LibraryJavaSound$Exception;
import paulscode.sound.libraries.LibraryJavaSound$MixerRanking;
import paulscode.sound.libraries.SourceJavaSound;

@SideOnly(value=Side.CLIENT)
public class LibraryJavaSound
extends Library {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final int XXX = 0;
    private final int maxClipSize = 0x100000;
    private static Mixer myMixer = null;
    private static LibraryJavaSound$MixerRanking myMixerRanking = null;
    private static LibraryJavaSound instance = null;
    private static int minSampleRate = 4000;
    private static int maxSampleRate = 48000;
    private static int lineCount = 32;
    private static boolean useGainControl = true;
    private static boolean usePanControl = true;
    private static boolean useSampleRateControl = true;

    public LibraryJavaSound() {
        instance = this;
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking = null;
        if (myMixer == null) {
            for (Mixer.Info info : AudioSystem.getMixerInfo()) {
                if (!info.getName().equals("Java Sound Audio Engine")) continue;
                libraryJavaSound$MixerRanking = new LibraryJavaSound$MixerRanking();
                try {
                    libraryJavaSound$MixerRanking.rank(info);
                }
                catch (LibraryJavaSound$Exception libraryJavaSound$Exception) {
                    break;
                }
                if (libraryJavaSound$MixerRanking.rank < 14) break;
                myMixer = AudioSystem.getMixer(info);
                LibraryJavaSound.mixerRanking(true, libraryJavaSound$MixerRanking);
                break;
            }
            if (myMixer == null) {
                void var2_4;
                LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking2 = libraryJavaSound$MixerRanking;
                for (Mixer.Info info : AudioSystem.getMixerInfo()) {
                    libraryJavaSound$MixerRanking = new LibraryJavaSound$MixerRanking();
                    try {
                        libraryJavaSound$MixerRanking.rank(info);
                    }
                    catch (LibraryJavaSound$Exception libraryJavaSound$Exception) {
                        // empty catch block
                    }
                    if (var2_4 != null && libraryJavaSound$MixerRanking.rank <= var2_4.rank) continue;
                    LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking3 = libraryJavaSound$MixerRanking;
                }
                if (var2_4 == null) {
                    throw new LibraryJavaSound$Exception("No useable mixers found!", new LibraryJavaSound$MixerRanking());
                }
                try {
                    myMixer = AudioSystem.getMixer(var2_4.mixerInfo);
                    LibraryJavaSound.mixerRanking(true, (LibraryJavaSound$MixerRanking)var2_4);
                }
                catch (Exception exception) {
                    throw new LibraryJavaSound$Exception("No useable mixers available!", new LibraryJavaSound$MixerRanking());
                }
            }
        }
        this.setMasterVolume(1.0f);
        this.message("JavaSound initialized.");
        super.init();
    }

    public static boolean libraryCompatible() {
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            if (!info.getName().equals("Java Sound Audio Engine")) continue;
            return true;
        }
        return false;
    }

    protected Channel createChannel(int n2) {
        return new ChannelJavaSound(n2, myMixer);
    }

    public void cleanup() {
        super.cleanup();
        instance = null;
        myMixer = null;
        myMixerRanking = null;
    }

    public boolean loadSound(FilenameURL filenameURL) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(filenameURL == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(filenameURL.getFilename()) != null) {
            return true;
        }
        ICodec iCodec = SoundSystemConfig.getCodec(filenameURL.getFilename());
        if (this.errorCheck(iCodec == null, "No codec found for file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        URL uRL = filenameURL.getURL();
        if (this.errorCheck(uRL == null, "Unable to open file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.initialize(uRL);
        SoundBuffer soundBuffer = iCodec.readAll();
        iCodec.cleanup();
        iCodec = null;
        if (soundBuffer != null) {
            this.bufferMap.put(filenameURL.getFilename(), soundBuffer);
        } else {
            this.errorMessage("Sound buffer null in method 'loadSound'");
        }
        return true;
    }

    public boolean loadSound(SoundBuffer soundBuffer, String string) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(string == null, "Identifier not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(string) != null) {
            return true;
        }
        if (soundBuffer != null) {
            this.bufferMap.put(string, soundBuffer);
        } else {
            this.errorMessage("Sound buffer null in method 'loadSound'");
        }
        return true;
    }

    public void setMasterVolume(float f2) {
        super.setMasterVolume(f2);
        Set set = this.sourceMap.keySet();
        for (String string : set) {
            Source source = (Source)this.sourceMap.get(string);
            if (source == null) continue;
            source.positionChanged();
        }
    }

    public void newSource(boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, float f2, float f3, float f4, int n2, float f5) {
        SoundBuffer soundBuffer = null;
        if (!bl3) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!bl3 && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(string, new SourceJavaSound(this.listener, bl2, bl3, bl4, string, filenameURL, soundBuffer, f2, f3, f4, n2, f5, false));
    }

    public void rawDataStream(AudioFormat audioFormat, boolean bl2, String string, float f2, float f3, float f4, int n2, float f5) {
        this.sourceMap.put(string, new SourceJavaSound(this.listener, audioFormat, bl2, string, f2, f3, f4, n2, f5));
    }

    public void quickPlay(boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, float f2, float f3, float f4, int n2, float f5, boolean bl5) {
        SoundBuffer soundBuffer = null;
        if (!bl3) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!bl3 && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(string, new SourceJavaSound(this.listener, bl2, bl3, bl4, string, filenameURL, soundBuffer, f2, f3, f4, n2, f5, bl5));
    }

    public void copySources(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'copySources'");
        }
        this.sourceMap.clear();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Source source = (Source)hashMap.get(string);
            if (source == null) continue;
            SoundBuffer soundBuffer = null;
            if (!source.toStream) {
                this.loadSound(source.filenameURL);
                soundBuffer = (SoundBuffer)this.bufferMap.get(source.filenameURL.getFilename());
            }
            if (!source.toStream && soundBuffer != null) {
                soundBuffer.trimData(0x100000);
            }
            if (!source.toStream && soundBuffer == null) continue;
            this.sourceMap.put(string, new SourceJavaSound(this.listener, source, soundBuffer));
        }
    }

    public void setListenerVelocity(float f2, float f3, float f4) {
        super.setListenerVelocity(f2, f3, f4);
        this.listenerMoved();
    }

    public void dopplerChanged() {
        super.dopplerChanged();
        this.listenerMoved();
    }

    public static Mixer getMixer() {
        return LibraryJavaSound.mixer(false, null);
    }

    public static void setMixer(Mixer mixer) {
        LibraryJavaSound.mixer(true, mixer);
        SoundSystemException soundSystemException = SoundSystem.getLastException();
        SoundSystem.setException(null);
        if (soundSystemException != null) {
            throw soundSystemException;
        }
    }

    private static synchronized Mixer mixer(boolean bl2, Mixer mixer) {
        if (bl2) {
            if (mixer == null) {
                return myMixer;
            }
            LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking = new LibraryJavaSound$MixerRanking();
            try {
                libraryJavaSound$MixerRanking.rank(mixer.getMixerInfo());
            }
            catch (LibraryJavaSound$Exception libraryJavaSound$Exception) {
                SoundSystemConfig.getLogger().printStackTrace(libraryJavaSound$Exception, 1);
                SoundSystem.setException(libraryJavaSound$Exception);
            }
            myMixer = mixer;
            LibraryJavaSound.mixerRanking(true, libraryJavaSound$MixerRanking);
            if (instance != null) {
                ChannelJavaSound channelJavaSound;
                ListIterator listIterator = LibraryJavaSound.instance.normalChannels.listIterator();
                SoundSystem.setException(null);
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(mixer);
                }
                listIterator = LibraryJavaSound.instance.streamingChannels.listIterator();
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(mixer);
                }
            }
        }
        return myMixer;
    }

    public static LibraryJavaSound$MixerRanking getMixerRanking() {
        return LibraryJavaSound.mixerRanking(false, null);
    }

    private static synchronized LibraryJavaSound$MixerRanking mixerRanking(boolean bl2, LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking) {
        if (bl2) {
            myMixerRanking = libraryJavaSound$MixerRanking;
        }
        return myMixerRanking;
    }

    public static void setMinSampleRate(int n2) {
        LibraryJavaSound.minSampleRate(true, n2);
    }

    private static synchronized int minSampleRate(boolean bl2, int n2) {
        if (bl2) {
            minSampleRate = n2;
        }
        return minSampleRate;
    }

    public static void setMaxSampleRate(int n2) {
        LibraryJavaSound.maxSampleRate(true, n2);
    }

    private static synchronized int maxSampleRate(boolean bl2, int n2) {
        if (bl2) {
            maxSampleRate = n2;
        }
        return maxSampleRate;
    }

    public static void setLineCount(int n2) {
        LibraryJavaSound.lineCount(true, n2);
    }

    private static synchronized int lineCount(boolean bl2, int n2) {
        if (bl2) {
            lineCount = n2;
        }
        return lineCount;
    }

    public static void useGainControl(boolean bl2) {
        LibraryJavaSound.useGainControl(true, bl2);
    }

    private static synchronized boolean useGainControl(boolean bl2, boolean bl3) {
        if (bl2) {
            useGainControl = bl3;
        }
        return useGainControl;
    }

    public static void usePanControl(boolean bl2) {
        LibraryJavaSound.usePanControl(true, bl2);
    }

    private static synchronized boolean usePanControl(boolean bl2, boolean bl3) {
        if (bl2) {
            usePanControl = bl3;
        }
        return usePanControl;
    }

    public static void useSampleRateControl(boolean bl2) {
        LibraryJavaSound.useSampleRateControl(true, bl2);
    }

    private static synchronized boolean useSampleRateControl(boolean bl2, boolean bl3) {
        if (bl2) {
            useSampleRateControl = bl3;
        }
        return useSampleRateControl;
    }

    public static String getTitle() {
        return "Java Sound";
    }

    public static String getDescription() {
        return "The Java Sound API.  For more information, see http://java.sun.com/products/java-media/sound/";
    }

    public String getClassName() {
        return "LibraryJavaSound";
    }

    static /* synthetic */ int access$000(boolean bl2, int n2) {
        return LibraryJavaSound.minSampleRate(bl2, n2);
    }

    static /* synthetic */ int access$100(boolean bl2, int n2) {
        return LibraryJavaSound.maxSampleRate(bl2, n2);
    }

    static /* synthetic */ int access$200(boolean bl2, int n2) {
        return LibraryJavaSound.lineCount(bl2, n2);
    }

    static /* synthetic */ boolean access$300(boolean bl2, boolean bl3) {
        return LibraryJavaSound.useGainControl(bl2, bl3);
    }

    static /* synthetic */ boolean access$400(boolean bl2, boolean bl3) {
        return LibraryJavaSound.usePanControl(bl2, bl3);
    }

    static /* synthetic */ boolean access$500(boolean bl2, boolean bl3) {
        return LibraryJavaSound.useSampleRateControl(bl2, bl3);
    }
}

