/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.bptblocks.BptBlockBed;
import buildcraft.api.bptblocks.BptBlockCustomStack;
import buildcraft.api.bptblocks.BptBlockDelegate;
import buildcraft.api.bptblocks.BptBlockDirt;
import buildcraft.api.bptblocks.BptBlockDoor;
import buildcraft.api.bptblocks.BptBlockIgnore;
import buildcraft.api.bptblocks.BptBlockIgnoreMeta;
import buildcraft.api.bptblocks.BptBlockInventory;
import buildcraft.api.bptblocks.BptBlockLever;
import buildcraft.api.bptblocks.BptBlockLiquid;
import buildcraft.api.bptblocks.BptBlockPiston;
import buildcraft.api.bptblocks.BptBlockPumpkin;
import buildcraft.api.bptblocks.BptBlockRedstoneRepeater;
import buildcraft.api.bptblocks.BptBlockRotateInventory;
import buildcraft.api.bptblocks.BptBlockRotateMeta;
import buildcraft.api.bptblocks.BptBlockSign;
import buildcraft.api.bptblocks.BptBlockStairs;
import buildcraft.api.bptblocks.BptBlockWallSide;
import buildcraft.api.filler.FillerManager;
import buildcraft.builders.BlockArchitect;
import buildcraft.builders.BlockBlueprintLibrary;
import buildcraft.builders.BlockBuilder;
import buildcraft.builders.BlockFiller;
import buildcraft.builders.BlockMarker;
import buildcraft.builders.BlockPathMarker;
import buildcraft.builders.BptBlockFiller;
import buildcraft.builders.BuilderProxyClient;
import buildcraft.builders.EventHandlerBuilders;
import buildcraft.builders.FillerFillAll;
import buildcraft.builders.FillerFillPyramid;
import buildcraft.builders.FillerFillStairs;
import buildcraft.builders.FillerFillWalls;
import buildcraft.builders.FillerFlattener;
import buildcraft.builders.FillerHorizon;
import buildcraft.builders.FillerRegistry;
import buildcraft.builders.FillerRemover;
import buildcraft.builders.GuiHandler;
import buildcraft.builders.IBuilderHook;
import buildcraft.builders.ItemBptBluePrint;
import buildcraft.builders.ItemBptTemplate;
import buildcraft.builders.TileArchitect;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.TileFiller;
import buildcraft.builders.TileMarker;
import buildcraft.builders.TilePathMarker;
import buildcraft.builders.network.PacketHandlerBuilders;
import buildcraft.core.DefaultProps;
import buildcraft.core.blueprints.BptPlayerIndex;
import buildcraft.core.blueprints.BptRootIndex;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.LinkedList;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;

@Mod(name="BuildCraft Builders", version="3.7.1", useMetadata=false, modid="BuildCraft|Builders", dependencies="required-after:BuildCraft|Core@3.7.1")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandlerBuilders.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftBuilders {
    public static final int LIBRARY_PAGE_SIZE = 12;
    public static final int MAX_BLUEPRINTS_NAME_SIZE = 14;
    public static BlockMarker markerBlock;
    public static BlockPathMarker pathMarkerBlock;
    public static BlockFiller fillerBlock;
    public static BlockBuilder builderBlock;
    public static BlockArchitect architectBlock;
    public static BlockBlueprintLibrary libraryBlock;
    public static ItemBptTemplate templateItem;
    public static ItemBptBluePrint blueprintItem;
    public static boolean fillerDestroy;
    public static int fillerLifespanTough;
    public static int fillerLifespanNormal;
    private static BptRootIndex rootBptIndex;
    public static TreeMap playerLibrary;
    private static LinkedList hooks;
    @Mod.Instance(value="BuildCraft|Builders")
    public static BuildCraftBuilders instance;

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        FillerManager.registry = new FillerRegistry();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerBuilders());
        new BptBlock(0);
        new BptBlockIgnore(Block.field_72037_aS.field_71990_ca);
        new BptBlockIgnore(Block.field_71962_X.field_71990_ca);
        new BptBlockIgnore(Block.field_72036_aT.field_71990_ca);
        new BptBlockIgnore(Block.field_72099_aa.field_71990_ca);
        new BptBlockDirt(Block.field_71979_v.field_71990_ca);
        new BptBlockDirt(Block.field_71980_u.field_71990_ca);
        new BptBlockDirt(Block.field_72050_aA.field_71990_ca);
        new BptBlockDelegate(Block.field_72049_aP.field_71990_ca, Block.field_72035_aQ.field_71990_ca);
        new BptBlockDelegate(Block.field_72052_aC.field_71990_ca, Block.field_72051_aB.field_71990_ca);
        new BptBlockDelegate(Block.field_72095_ac.field_71990_ca, Block.field_71963_Z.field_71990_ca);
        new BptBlockWallSide(Block.field_72069_aq.field_71990_ca);
        new BptBlockWallSide(Block.field_72035_aQ.field_71990_ca);
        new BptBlockRotateMeta(Block.field_72055_aF.field_71990_ca, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateMeta(Block.field_71993_bv.field_71990_ca, new int[]{0, 1, 2, 3}, true);
        new BptBlockRotateInventory(Block.field_72051_aB.field_71990_ca, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(Block.field_72077_au.field_71990_ca, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(Block.field_72004_bj.field_71990_ca, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(Block.field_71958_P.field_71990_ca, new int[]{2, 5, 3, 4}, true);
        new BptBlockInventory(Block.field_72106_bF.field_71990_ca);
        new BptBlockRotateMeta(Block.field_71998_bu.field_71990_ca, new int[]{1, 4, 8, 2}, false);
        new BptBlockRotateMeta(Block.field_72005_bk.field_71990_ca, new int[]{0, 1, 2, 3}, false);
        new BptBlockLever(Block.field_82511_ci.field_71990_ca);
        new BptBlockLever(Block.field_72034_aR.field_71990_ca);
        new BptBlockLever(Block.field_72043_aJ.field_71990_ca);
        new BptBlockCustomStack(Block.field_71981_t.field_71990_ca, new ItemStack(Block.field_71981_t));
        new BptBlockCustomStack(Block.field_72075_av.field_71990_ca, new ItemStack(Item.field_77767_aC));
        new BptBlockCustomStack(Block.field_72009_bg.field_71990_ca, new ItemStack(Item.field_77746_aZ));
        new BptBlockCustomStack(Block.field_72058_az.field_71990_ca, new ItemStack(Item.field_77690_S));
        new BptBlockCustomStack(Block.field_71996_bs.field_71990_ca, new ItemStack(Item.field_77739_bg));
        new BptBlockCustomStack(Block.field_71999_bt.field_71990_ca, new ItemStack(Item.field_77740_bh));
        new BptBlockCustomStack(Block.field_72014_bd.field_71990_ca, new ItemStack(Block.field_72014_bd));
        new BptBlockRedstoneRepeater(Block.field_72011_bi.field_71990_ca);
        new BptBlockRedstoneRepeater(Block.field_72010_bh.field_71990_ca);
        new BptBlockLiquid(Block.field_71943_B.field_71990_ca, new ItemStack(Item.field_77786_ax));
        new BptBlockLiquid(Block.field_71942_A.field_71990_ca, new ItemStack(Item.field_77786_ax));
        new BptBlockLiquid(Block.field_71938_D.field_71990_ca, new ItemStack(Item.field_77775_ay));
        new BptBlockLiquid(Block.field_71944_C.field_71990_ca, new ItemStack(Item.field_77775_ay));
        new BptBlockIgnoreMeta(Block.field_72056_aG.field_71990_ca);
        new BptBlockIgnoreMeta(Block.field_71954_T.field_71990_ca);
        new BptBlockIgnoreMeta(Block.field_71953_U.field_71990_ca);
        new BptBlockIgnoreMeta(Block.field_72003_bq.field_71990_ca);
        new BptBlockPiston(Block.field_71963_Z.field_71990_ca);
        new BptBlockPiston(Block.field_71956_V.field_71990_ca);
        new BptBlockPumpkin(Block.field_72008_bf.field_71990_ca);
        new BptBlockStairs(Block.field_72057_aH.field_71990_ca);
        new BptBlockStairs(Block.field_72063_at.field_71990_ca);
        new BptBlockStairs(Block.field_72100_bC.field_71990_ca);
        new BptBlockStairs(Block.field_71992_bw.field_71990_ca);
        new BptBlockStairs(Block.field_71995_bx.field_71990_ca);
        new BptBlockDoor(Block.field_72054_aE.field_71990_ca, new ItemStack(Item.field_77790_av));
        new BptBlockDoor(Block.field_72045_aL.field_71990_ca, new ItemStack(Item.field_77766_aB));
        new BptBlockBed(Block.field_71959_S.field_71990_ca);
        new BptBlockSign(Block.field_72042_aI.field_71990_ca, true);
        new BptBlockSign(Block.field_72053_aD.field_71990_ca, false);
        new BptBlockRotateInventory(BuildCraftBuilders.architectBlock.field_71990_ca, new int[]{2, 5, 3, 4}, true);
        new BptBlockRotateInventory(BuildCraftBuilders.builderBlock.field_71990_ca, new int[]{2, 5, 3, 4}, true);
        new BptBlockInventory(BuildCraftBuilders.libraryBlock.field_71990_ca);
        new BptBlockWallSide(BuildCraftBuilders.markerBlock.field_71990_ca);
        new BptBlockWallSide(BuildCraftBuilders.pathMarkerBlock.field_71990_ca);
        new BptBlockFiller(BuildCraftBuilders.fillerBlock.field_71990_ca);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftBuilders.loadRecipes();
        }
    }

    @Mod.PreInit
    public void initialize(FMLPreInitializationEvent evt) {
        Property templateItemId = BuildCraftCore.mainConfiguration.getItem("templateItem.id", DefaultProps.TEMPLATE_ITEM_ID);
        Property blueprintItemId = BuildCraftCore.mainConfiguration.getItem("blueprintItem.id", DefaultProps.BLUEPRINT_ITEM_ID);
        Property markerId = BuildCraftCore.mainConfiguration.getBlock("marker.id", DefaultProps.MARKER_ID);
        Property pathMarkerId = BuildCraftCore.mainConfiguration.getBlock("pathMarker.id", DefaultProps.PATH_MARKER_ID);
        Property fillerId = BuildCraftCore.mainConfiguration.getBlock("filler.id", DefaultProps.FILLER_ID);
        Property builderId = BuildCraftCore.mainConfiguration.getBlock("builder.id", DefaultProps.BUILDER_ID);
        Property architectId = BuildCraftCore.mainConfiguration.getBlock("architect.id", DefaultProps.ARCHITECT_ID);
        Property libraryId = BuildCraftCore.mainConfiguration.getBlock("blueprintLibrary.id", DefaultProps.BLUEPRINT_LIBRARY_ID);
        Property fillerDestroyProp = BuildCraftCore.mainConfiguration.get("general", "filler.destroy", DefaultProps.FILLER_DESTROY);
        fillerDestroyProp.comment = "If true, Filler will destroy blocks instead of breaking them.";
        fillerDestroy = fillerDestroyProp.getBoolean(DefaultProps.FILLER_DESTROY);
        Property fillerLifespanToughProp = BuildCraftCore.mainConfiguration.get("general", "filler.lifespan.tough", 20);
        fillerLifespanToughProp.comment = "Lifespan in ticks of items dropped by the filler from 'tough' blocks (those that can't be broken by hand)";
        fillerLifespanTough = fillerLifespanToughProp.getInt(20);
        Property fillerLifespanNormalProp = BuildCraftCore.mainConfiguration.get("general", "filler.lifespan.other", 6000);
        fillerLifespanNormalProp.comment = "Lifespan in ticks of items dropped by the filler from non-tough blocks (those that can be broken by hand)";
        fillerLifespanNormal = fillerLifespanNormalProp.getInt(6000);
        templateItem = new ItemBptTemplate(templateItemId.getInt());
        templateItem.func_77655_b("templateItem");
        LanguageRegistry.addName((Object)((Object)templateItem), (String)"Template");
        blueprintItem = new ItemBptBluePrint(blueprintItemId.getInt());
        blueprintItem.func_77655_b("blueprintItem");
        LanguageRegistry.addName((Object)((Object)blueprintItem), (String)"Blueprint");
        markerBlock = new BlockMarker(markerId.getInt());
        CoreProxy.proxy.registerBlock(markerBlock.func_71864_b("markerBlock"));
        CoreProxy.proxy.addName((Object)markerBlock, "Land Mark");
        pathMarkerBlock = new BlockPathMarker(pathMarkerId.getInt());
        CoreProxy.proxy.registerBlock(pathMarkerBlock.func_71864_b("pathMarkerBlock"));
        CoreProxy.proxy.addName((Object)pathMarkerBlock, "Path Mark");
        fillerBlock = new BlockFiller(fillerId.getInt());
        CoreProxy.proxy.registerBlock(fillerBlock.func_71864_b("fillerBlock"));
        CoreProxy.proxy.addName((Object)fillerBlock, "Filler");
        builderBlock = new BlockBuilder(builderId.getInt());
        CoreProxy.proxy.registerBlock(builderBlock.func_71864_b("builderBlock"));
        CoreProxy.proxy.addName((Object)builderBlock, "Builder");
        architectBlock = new BlockArchitect(architectId.getInt());
        CoreProxy.proxy.registerBlock(architectBlock.func_71864_b("architectBlock"));
        CoreProxy.proxy.addName((Object)architectBlock, "Architect Table");
        libraryBlock = new BlockBlueprintLibrary(libraryId.getInt());
        CoreProxy.proxy.registerBlock(libraryBlock.func_71864_b("libraryBlock"));
        CoreProxy.proxy.addName((Object)libraryBlock, "Blueprint Library");
        GameRegistry.registerTileEntity(TileMarker.class, (String)"Marker");
        GameRegistry.registerTileEntity(TileFiller.class, (String)"Filler");
        GameRegistry.registerTileEntity(TileBuilder.class, (String)"net.minecraft.src.builders.TileBuilder");
        GameRegistry.registerTileEntity(TileArchitect.class, (String)"net.minecraft.src.builders.TileTemplate");
        GameRegistry.registerTileEntity(TilePathMarker.class, (String)"net.minecraft.src.builders.TilePathMarker");
        GameRegistry.registerTileEntity(TileBlueprintLibrary.class, (String)"net.minecraft.src.builders.TileBlueprintLibrary");
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)templateItem, 1), new Object[]{"ppp", "pip", "ppp", Character.valueOf('i'), new ItemStack(Item.field_77756_aW, 1, 0), Character.valueOf('p'), Item.field_77759_aK});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)blueprintItem, 1), new Object[]{"ppp", "pip", "ppp", Character.valueOf('i'), new ItemStack(Item.field_77756_aW, 1, 4), Character.valueOf('p'), Item.field_77759_aK});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)markerBlock, 1), new Object[]{"l ", "r ", Character.valueOf('l'), new ItemStack(Item.field_77756_aW, 1, 4), Character.valueOf('r'), Block.field_72035_aQ});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)pathMarkerBlock, 1), new Object[]{"l ", "r ", Character.valueOf('l'), new ItemStack(Item.field_77756_aW, 1, 2), Character.valueOf('r'), Block.field_72035_aQ});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)fillerBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new ItemStack(Item.field_77756_aW, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new ItemStack(Item.field_77756_aW, 1, 11), Character.valueOf('c'), Block.field_72060_ay, Character.valueOf('g'), BuildCraftCore.goldGearItem, Character.valueOf('C'), Block.field_72077_au});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)architectBlock, 1), new Object[]{"btb", "ycy", "gCg", Character.valueOf('b'), new ItemStack(Item.field_77756_aW, 1, 0), Character.valueOf('t'), markerBlock, Character.valueOf('y'), new ItemStack(Item.field_77756_aW, 1, 11), Character.valueOf('c'), Block.field_72060_ay, Character.valueOf('g'), BuildCraftCore.diamondGearItem, Character.valueOf('C'), new ItemStack((Item)templateItem, 1)});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)libraryBlock, 1), new Object[]{"bbb", "bBb", "bbb", Character.valueOf('b'), new ItemStack((Item)blueprintItem), Character.valueOf('B'), Block.field_72093_an});
        FillerManager.registry.addRecipe(new FillerFillAll(), new Object[]{"bbb", "bbb", "bbb", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('b'), Block.field_72081_al});
        FillerManager.registry.addRecipe(new FillerFlattener(), new Object[]{"ggg", "bbb", "bbb", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('b'), Block.field_72081_al});
        FillerManager.registry.addRecipe(new FillerHorizon(), new Object[]{"ggg", "ggg", "bbb", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('b'), Block.field_72081_al});
        FillerManager.registry.addRecipe(new FillerRemover(), new Object[]{"ggg", "ggg", "ggg", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('b'), Block.field_72081_al});
        FillerManager.registry.addRecipe(new FillerFillWalls(), new Object[]{"bbb", "b b", "bbb", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('b'), Block.field_72081_al});
        FillerManager.registry.addRecipe(new FillerFillPyramid(), new Object[]{"   ", " b ", "bbb", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('b'), Block.field_72081_al});
        FillerManager.registry.addRecipe(new FillerFillStairs(), new Object[]{"  b", " bb", "bbb", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('b'), Block.field_72081_al});
    }

    public static BptPlayerIndex getPlayerIndex(String name) {
        BptRootIndex rootIndex = BuildCraftBuilders.getBptRootIndex();
        if (!playerLibrary.containsKey(name)) {
            try {
                playerLibrary.put(name, new BptPlayerIndex(name + ".list", rootIndex));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (BptPlayerIndex)playerLibrary.get(name);
    }

    public static BptRootIndex getBptRootIndex() {
        if (rootBptIndex == null) {
            try {
                rootBptIndex = new BptRootIndex("index.txt");
                rootBptIndex.loadIndex();
                for (IBuilderHook hook : hooks) {
                    hook.rootIndexInitialized(rootBptIndex);
                }
                rootBptIndex.importNewFiles();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rootBptIndex;
    }

    public static ItemStack getBptItemStack(int id, int damage, String name) {
        ItemStack stack = new ItemStack(id, 1, damage);
        NBTTagCompound nbt = new NBTTagCompound();
        if (name != null && !"".equals(name)) {
            nbt.func_74778_a("BptName", name);
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    public static void addHook(IBuilderHook hook) {
        if (!hooks.contains(hook)) {
            hooks.add(hook);
        }
    }

    @Mod.ServerStopping
    public void ServerStop(FMLServerStoppingEvent event) {
        TilePathMarker.clearAvailableMarkersList();
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        if (evt.map == Minecraft.func_71410_x().field_71446_o.field_94154_l) {
            TextureMap terrainMap = evt.map;
            BuilderProxyClient.fillerFillAllTexture = terrainMap.func_94245_a("buildcraft:fillerPatterns/fillAll");
            BuilderProxyClient.fillerClearTexture = terrainMap.func_94245_a("buildcraft:fillerPatterns/clear");
            BuilderProxyClient.fillerWallsTexture = terrainMap.func_94245_a("buildcraft:fillerPatterns/walls");
            BuilderProxyClient.fillerStairsTexture = terrainMap.func_94245_a("buildcraft:fillerPatterns/stairs");
            BuilderProxyClient.fillerFlattenTexture = terrainMap.func_94245_a("buildcraft:fillerPatterns/flatten");
            BuilderProxyClient.fillerHorizonTexture = terrainMap.func_94245_a("buildcraft:fillerPatterns/horizon");
            BuilderProxyClient.fillerPyramidTexture = terrainMap.func_94245_a("buildcraft:fillerPatterns/pyramid");
        }
    }

    static {
        playerLibrary = new TreeMap();
        hooks = new LinkedList();
    }
}

