/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.recipes.RefineryRecipe;
import buildcraft.core.BlockSpring;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.network.PacketHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.energy.BlockEngine;
import buildcraft.energy.BlockOilFlowing;
import buildcraft.energy.BlockOilStill;
import buildcraft.energy.BptBlockEngine;
import buildcraft.energy.EnergyProxy;
import buildcraft.energy.Engine;
import buildcraft.energy.GuiHandler;
import buildcraft.energy.ItemBucketOil;
import buildcraft.energy.ItemEngine;
import buildcraft.energy.OilBucketHandler;
import buildcraft.energy.TriggerEngineHeat;
import buildcraft.energy.worldgen.BiomeGenOilDesert;
import buildcraft.energy.worldgen.BiomeGenOilOcean;
import buildcraft.energy.worldgen.BiomeInitializer;
import buildcraft.energy.worldgen.OilPopulate;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

@Mod(name="BuildCraft Energy", version="3.7.1", useMetadata=false, modid="BuildCraft|Energy", dependencies="required-after:BuildCraft|Core@3.7.1")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandler.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftEnergy {
    public static final int ENERGY_REMOVE_BLOCK = 25;
    public static final int ENERGY_EXTRACT_ITEM = 2;
    public static boolean spawnOilSprings = true;
    public static BiomeGenOilDesert biomeOilDesert;
    public static BiomeGenOilOcean biomeOilOcean;
    public static BlockEngine engineBlock;
    public static Block oilMoving;
    public static Block oilStill;
    public static Item bucketOil;
    public static Item bucketFuel;
    public static Item fuel;
    public static LiquidStack oilLiquid;
    public static LiquidStack fuelLiquid;
    public static boolean canOilBurn;
    public static TreeMap saturationStored;
    public static BCTrigger triggerBlueEngineHeat;
    public static BCTrigger triggerGreenEngineHeat;
    public static BCTrigger triggerYellowEngineHeat;
    public static BCTrigger triggerRedEngineHeat;
    @Mod.Instance(value="BuildCraft|Energy")
    public static BuildCraftEnergy instance;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        class BiomeIdException
        extends RuntimeException {
            public BiomeIdException(String biome, int id) {
                super(String.format("You have a Biome Id conflict at %d for %s", id, biome));
            }
        }
        int oilOceanId;
        Property engineId = BuildCraftCore.mainConfiguration.getBlock("engine.id", DefaultProps.ENGINE_ID);
        Property oilStillId = BuildCraftCore.mainConfiguration.getBlock("oilStill.id", DefaultProps.OIL_STILL_ID);
        Property oilMovingId = BuildCraftCore.mainConfiguration.getBlock("oilMoving.id", DefaultProps.OIL_MOVING_ID);
        Property bucketOilId = BuildCraftCore.mainConfiguration.get("item", "bucketOil.id", DefaultProps.BUCKET_OIL_ID);
        Property bucketFuelId = BuildCraftCore.mainConfiguration.get("item", "bucketFuel.id", DefaultProps.BUCKET_FUEL_ID);
        Property itemFuelId = BuildCraftCore.mainConfiguration.get("item", "fuel.id", DefaultProps.FUEL_ID);
        Property oilDesertBiomeId = BuildCraftCore.mainConfiguration.get("biomes", "oilDesert", 160);
        Property oilOceanBiomeId = BuildCraftCore.mainConfiguration.get("biomes", "oilOcean", 161);
        canOilBurn = BuildCraftCore.mainConfiguration.get("general", "burnOil", true, "Can oil burn?").getBoolean(true);
        BuildCraftCore.mainConfiguration.save();
        int oilDesertId = oilDesertBiomeId.getInt();
        if (oilDesertId > 0) {
            if (BiomeGenBase.field_76773_a[oilDesertId] != null) {
                throw new BiomeIdException("oilDesert", oilDesertId);
            }
            biomeOilDesert = BiomeGenOilDesert.makeBiome(oilDesertId);
        }
        if ((oilOceanId = oilOceanBiomeId.getInt()) > 0) {
            if (BiomeGenBase.field_76773_a[oilOceanId] != null) {
                throw new BiomeIdException("oilOcean", oilOceanId);
            }
            biomeOilOcean = BiomeGenOilOcean.makeBiome(oilOceanId);
        }
        engineBlock = new BlockEngine(engineId.getInt(DefaultProps.ENGINE_ID));
        CoreProxy.proxy.registerBlock((Block)engineBlock, ItemEngine.class);
        LanguageRegistry.addName((Object)new ItemStack((Block)engineBlock, 1, 0), (String)"Redstone Engine");
        LanguageRegistry.addName((Object)new ItemStack((Block)engineBlock, 1, 1), (String)"Steam Engine");
        LanguageRegistry.addName((Object)new ItemStack((Block)engineBlock, 1, 2), (String)"Combustion Engine");
        oilStill = new BlockOilStill(oilStillId.getInt(DefaultProps.OIL_STILL_ID), Material.field_76244_g).func_71864_b("oil");
        CoreProxy.proxy.addName(oilStill.func_71864_b("oilStill"), "Oil");
        CoreProxy.proxy.registerBlock(oilStill);
        Property oilSpringsProp = BuildCraftCore.mainConfiguration.get("general", "oilSprings", true);
        BlockSpring.EnumSpring.OIL.canGen = spawnOilSprings = oilSpringsProp.getBoolean(true);
        BlockSpring.EnumSpring.OIL.liquidBlock = oilStill;
        oilMoving = new BlockOilFlowing(oilMovingId.getInt(DefaultProps.OIL_MOVING_ID), Material.field_76244_g).func_71864_b("oil");
        CoreProxy.proxy.addName(oilMoving.func_71864_b("oilMoving"), "Oil");
        CoreProxy.proxy.registerBlock(oilMoving);
        if (BuildCraftEnergy.oilMoving.field_71990_ca + 1 != BuildCraftEnergy.oilStill.field_71990_ca) {
            throw new RuntimeException("Oil Still id must be Oil Moving id + 1");
        }
        fuel = new ItemBuildCraft(itemFuelId.getInt(DefaultProps.FUEL_ID)).func_77655_b("fuel");
        LanguageRegistry.addName((Object)fuel, (String)"Fuel");
        MinecraftForge.EVENT_BUS.register((Object)new OilBucketHandler());
        bucketOil = new ItemBucketOil(bucketOilId.getInt(DefaultProps.BUCKET_OIL_ID)).func_77655_b("bucketOil").func_77642_a(Item.field_77788_aw);
        LanguageRegistry.addName((Object)bucketOil, (String)"Oil Bucket");
        bucketFuel = new ItemBuildCraft(bucketFuelId.getInt()).func_77655_b("bucketFuel").func_77642_a(Item.field_77788_aw);
        bucketFuel.func_77625_d(1);
        LanguageRegistry.addName((Object)bucketFuel, (String)"Fuel Bucket");
        oilLiquid = LiquidDictionary.getOrCreateLiquid((String)"Oil", (LiquidStack)new LiquidStack(oilStill, 1));
        fuelLiquid = LiquidDictionary.getOrCreateLiquid((String)"Fuel", (LiquidStack)new LiquidStack(fuel, 1));
        RefineryRecipe.registerRefineryRecipe(new RefineryRecipe(LiquidDictionary.getLiquid((String)"Oil", (int)1), null, LiquidDictionary.getLiquid((String)"Fuel", (int)1), 12, 1));
        IronEngineFuel.fuels.add(new IronEngineFuel(Block.field_71938_D.field_71990_ca, 1.0f, 20000));
        IronEngineFuel.fuels.add(new IronEngineFuel(LiquidDictionary.getLiquid((String)"Oil", (int)1000), 3.0f, 20000));
        IronEngineFuel.fuels.add(new IronEngineFuel(LiquidDictionary.getLiquid((String)"Fuel", (int)1000), 6.0f, 100000));
        IronEngineCoolant.coolants.add(new IronEngineCoolant(new LiquidStack(Block.field_71943_B, 1000), 1.0f));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getLiquid((String)"Oil", (int)1000), new ItemStack(bucketOil), new ItemStack(Item.field_77788_aw)));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(LiquidDictionary.getLiquid((String)"Fuel", (int)1000), new ItemStack(bucketFuel), new ItemStack(Item.field_77788_aw)));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.Init
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        new BptBlockEngine(BuildCraftEnergy.engineBlock.field_71990_ca);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftEnergy.loadRecipes();
        }
        EnergyProxy.proxy.registerBlockRenderers();
        EnergyProxy.proxy.registerTileEntities();
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent evt) {
        if (BuildCraftCore.modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)OilPopulate.INSTANCE);
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new BiomeInitializer());
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map == Minecraft.func_71410_x().field_71446_o.field_94155_m) {
            LiquidDictionary.getCanonicalLiquid((String)"Fuel").setRenderingIcon(fuel.func_77617_a(0)).setTextureSheet("/gui/items.png");
        } else {
            LiquidDictionary.getCanonicalLiquid((String)"Oil").setRenderingIcon(oilStill.func_71851_a(1)).setTextureSheet("/terrain.png");
        }
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 0), new Object[]{"www", " g ", "GpG", Character.valueOf('w'), "plankWood", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('G'), BuildCraftCore.woodenGearItem, Character.valueOf('p'), Block.field_71963_Z});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 1), new Object[]{"www", " g ", "GpG", Character.valueOf('w'), Block.field_71978_w, Character.valueOf('g'), Block.field_71946_M, Character.valueOf('G'), BuildCraftCore.stoneGearItem, Character.valueOf('p'), Block.field_71963_Z});
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 2), new Object[]{"www", " g ", "GpG", Character.valueOf('w'), Item.field_77703_o, Character.valueOf('g'), Block.field_71946_M, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('p'), Block.field_71963_Z});
    }

    @Mod.IMCCallback
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            int id;
            String biomeID;
            if (m.key.equals("oil-lake-biome")) {
                try {
                    biomeID = m.getStringValue().trim();
                    id = Integer.valueOf(biomeID);
                    if (id >= BiomeGenBase.field_76773_a.length) {
                        throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.field_76773_a.length);
                    }
                    OilPopulate.INSTANCE.surfaceDepositBiomes.add(id);
                }
                catch (Exception ex) {
                    Logger.getLogger("Buildcraft").log(Level.WARNING, String.format("Received an invalid oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
                }
                Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an successfull oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
                continue;
            }
            if (!m.key.equals("oil-gen-exclude")) continue;
            try {
                biomeID = m.getStringValue().trim();
                id = Integer.valueOf(biomeID);
                if (id >= BiomeGenBase.field_76773_a.length) {
                    throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.field_76773_a.length);
                }
                OilPopulate.INSTANCE.excludedBiomes.add(id);
            }
            catch (Exception ex) {
                Logger.getLogger("Buildcraft").log(Level.WARNING, String.format("Received an invalid oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
            }
            Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an successfull oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
        }
    }

    static {
        saturationStored = new TreeMap();
        triggerBlueEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_BLUE_ENGINE_HEAT, Engine.EnergyStage.Blue);
        triggerGreenEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_GREEN_ENGINE_HEAT, Engine.EnergyStage.Green);
        triggerYellowEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_YELLOW_ENGINE_HEAT, Engine.EnergyStage.Yellow);
        triggerRedEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_RED_ENGINE_HEAT, Engine.EnergyStage.Red);
    }
}

