/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.transport.IExtractionHandler;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.DefaultProps;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.BCAction;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.GateIconProvider;
import buildcraft.transport.GuiHandler;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemGate;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.ItemPlug;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTriggerProvider;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.WireIconProvider;
import buildcraft.transport.blueprints.BptBlockPipe;
import buildcraft.transport.blueprints.BptItemPipeDiamond;
import buildcraft.transport.blueprints.BptItemPipeEmerald;
import buildcraft.transport.blueprints.BptItemPipeIron;
import buildcraft.transport.blueprints.BptItemPipeWooden;
import buildcraft.transport.network.PacketHandlerTransport;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsGold;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsQuartz;
import buildcraft.transport.pipes.PipeItemsSandstone;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsVoid;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLiquidsCobblestone;
import buildcraft.transport.pipes.PipeLiquidsEmerald;
import buildcraft.transport.pipes.PipeLiquidsGold;
import buildcraft.transport.pipes.PipeLiquidsIron;
import buildcraft.transport.pipes.PipeLiquidsSandstone;
import buildcraft.transport.pipes.PipeLiquidsStone;
import buildcraft.transport.pipes.PipeLiquidsVoid;
import buildcraft.transport.pipes.PipeLiquidsWood;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import buildcraft.transport.triggers.ActionEnergyPulser;
import buildcraft.transport.triggers.ActionSignalOutput;
import buildcraft.transport.triggers.ActionSingleEnergyPulse;
import buildcraft.transport.triggers.TriggerPipeContents;
import buildcraft.transport.triggers.TriggerPipeSignal;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.Property;

@Mod(version="3.7.1", modid="BuildCraft|Transport", name="Buildcraft Transport", dependencies="required-after:BuildCraft|Core@3.7.1")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandlerTransport.class)
public class BuildCraftTransport {
    public static BlockGenericPipe genericPipeBlock;
    public static int maxItemsInPipes;
    public static float pipeDurability;
    public static Item pipeWaterproof;
    public static Item pipeGate;
    public static Item pipeGateAutarchic;
    public static Item redPipeWire;
    public static Item bluePipeWire;
    public static Item greenPipeWire;
    public static Item yellowPipeWire;
    public static Item pipeItemsWood;
    public static Item pipeItemsEmerald;
    public static Item pipeItemsStone;
    public static Item pipeItemsCobblestone;
    public static Item pipeItemsIron;
    public static Item pipeItemsQuartz;
    public static Item pipeItemsGold;
    public static Item pipeItemsDiamond;
    public static Item pipeItemsObsidian;
    public static Item pipeItemsVoid;
    public static Item pipeItemsSandstone;
    public static Item pipeLiquidsWood;
    public static Item pipeLiquidsCobblestone;
    public static Item pipeLiquidsStone;
    public static Item pipeLiquidsIron;
    public static Item pipeLiquidsGold;
    public static Item pipeLiquidsVoid;
    public static Item pipeLiquidsSandstone;
    public static Item pipeLiquidsEmerald;
    public static Item pipePowerWood;
    public static Item pipePowerCobblestone;
    public static Item pipePowerStone;
    public static Item pipePowerQuartz;
    public static Item pipePowerGold;
    public static Item pipePowerDiamond;
    public static Item facadeItem;
    public static Item plugItem;
    public static Item pipeStructureCobblestone;
    public static int groupItemsTrigger;
    public static BCTrigger triggerPipeEmpty;
    public static BCTrigger triggerPipeItems;
    public static BCTrigger triggerPipeLiquids;
    public static BCTrigger triggerPipeEnergy;
    public static BCTrigger triggerRedSignalActive;
    public static BCTrigger triggerRedSignalInactive;
    public static BCTrigger triggerBlueSignalActive;
    public static BCTrigger triggerBlueSignalInactive;
    public static BCTrigger triggerGreenSignalActive;
    public static BCTrigger triggerGreenSignalInactive;
    public static BCTrigger triggerYellowSignalActive;
    public static BCTrigger triggerYellowSignalInactive;
    public static BCAction actionRedSignal;
    public static BCAction actionBlueSignal;
    public static BCAction actionGreenSignal;
    public static BCAction actionYellowSignal;
    public static BCAction actionEnergyPulser;
    public static BCAction actionSingleEnergyPulse;
    @Mod.Instance(value="BuildCraft|Transport")
    public static BuildCraftTransport instance;
    public IIconProvider pipeIconProvider = new PipeIconProvider();
    public IIconProvider gateIconProvider = new GateIconProvider();
    public IIconProvider wireIconProvider = new WireIconProvider();
    private static LinkedList pipeRecipes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void preInitialize(FMLPreInitializationEvent evt) {
        try {
            Property exclusionLiquidList;
            String[] excludedLiquidBlocks;
            Property durability = BuildCraftCore.mainConfiguration.get("general", "pipes.durability", DefaultProps.PIPES_DURABILITY);
            durability.comment = "How long a pipe will take to break";
            pipeDurability = (float)durability.getDouble(DefaultProps.PIPES_DURABILITY);
            Property exclusionItemList = BuildCraftCore.mainConfiguration.get("block", "woodenPipe.item.exclusion", new String[0]);
            String[] excludedItemBlocks = exclusionItemList.getStringList();
            if (excludedItemBlocks != null) {
                for (int j = 0; j < excludedItemBlocks.length; ++j) {
                    excludedItemBlocks[j] = excludedItemBlocks[j].trim();
                }
            } else {
                excludedItemBlocks = new String[]{};
            }
            if ((excludedLiquidBlocks = (exclusionLiquidList = BuildCraftCore.mainConfiguration.get("block", "woodenPipe.liquid.exclusion", new String[0])).getStringList()) != null) {
                for (int j = 0; j < excludedLiquidBlocks.length; ++j) {
                    excludedLiquidBlocks[j] = excludedLiquidBlocks[j].trim();
                }
            } else {
                excludedLiquidBlocks = new String[]{};
            }
            PipeManager.registerExtractionHandler(new ExtractionHandler(excludedItemBlocks, excludedLiquidBlocks));
            Property maxItemInPipesProp = BuildCraftCore.mainConfiguration.get("general", "pipes.maxItems", 100);
            maxItemInPipesProp.comment = "pipes containing more than this amount of items will explode, not dropping any item";
            maxItemsInPipes = maxItemInPipesProp.getInt();
            Property groupItemsTriggerProp = BuildCraftCore.mainConfiguration.get("general", "pipes.groupItemsTrigger", 32);
            groupItemsTriggerProp.comment = "when reaching this amount of objects in a pipes, items will be automatically grouped";
            groupItemsTrigger = groupItemsTriggerProp.getInt();
            Property genericPipeId = BuildCraftCore.mainConfiguration.getBlock("pipe.id", DefaultProps.GENERIC_PIPE_ID);
            Property pipeWaterproofId = BuildCraftCore.mainConfiguration.getItem("pipeWaterproof.id", DefaultProps.PIPE_WATERPROOF_ID);
            pipeWaterproof = new ItemBuildCraft(pipeWaterproofId.getInt());
            pipeWaterproof.func_77655_b("pipeWaterproof");
            pipeWaterproof.func_77637_a(CreativeTabBuildCraft.tabBuildCraft);
            LanguageRegistry.addName((Object)pipeWaterproof, (String)"Pipe Waterproof");
            genericPipeBlock = new BlockGenericPipe(genericPipeId.getInt());
            GameRegistry.registerBlock((Block)genericPipeBlock);
            pipeItemsWood = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_WOOD_ID, PipeItemsWood.class, "Wooden Transport Pipe", "plankWood", Block.field_71946_M, "plankWood");
            pipeItemsEmerald = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_EMERALD_ID, PipeItemsEmerald.class, "Emerald Transport Pipe", Item.field_77817_bH, Block.field_71946_M, Item.field_77817_bH);
            pipeItemsCobblestone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_COBBLESTONE_ID, PipeItemsCobblestone.class, "Cobblestone Transport Pipe", Block.field_71978_w, Block.field_71946_M, Block.field_71978_w);
            pipeItemsStone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_STONE_ID, PipeItemsStone.class, "Stone Transport Pipe", Block.field_71981_t, Block.field_71946_M, Block.field_71981_t);
            pipeItemsQuartz = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_QUARTZ_ID, PipeItemsQuartz.class, "Quartz Transport Pipe", Block.field_94339_ct, Block.field_71946_M, Block.field_94339_ct);
            pipeItemsIron = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_IRON_ID, PipeItemsIron.class, "Iron Transport Pipe", Item.field_77703_o, Block.field_71946_M, Item.field_77703_o);
            pipeItemsGold = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_GOLD_ID, PipeItemsGold.class, "Golden Transport Pipe", Item.field_77717_p, Block.field_71946_M, Item.field_77717_p);
            pipeItemsDiamond = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_DIAMOND_ID, PipeItemsDiamond.class, "Diamond Transport Pipe", Item.field_77702_n, Block.field_71946_M, Item.field_77702_n);
            pipeItemsObsidian = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_OBSIDIAN_ID, PipeItemsObsidian.class, "Obsidian Transport Pipe", Block.field_72089_ap, Block.field_71946_M, Block.field_72089_ap);
            pipeItemsSandstone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_SANDSTONE_ID, PipeItemsSandstone.class, "Sandstone Transport Pipe", Block.field_71957_Q, Block.field_71946_M, Block.field_71957_Q);
            pipeItemsVoid = BuildCraftTransport.buildPipe(DefaultProps.PIPE_ITEMS_VOID_ID, PipeItemsVoid.class, "Void Transport Pipe", "dyeBlack", Block.field_71946_M, Item.field_77767_aC);
            pipeLiquidsWood = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_WOOD_ID, PipeLiquidsWood.class, "Wooden Waterproof Pipe", pipeWaterproof, pipeItemsWood);
            pipeLiquidsCobblestone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_COBBLESTONE_ID, PipeLiquidsCobblestone.class, "Cobblestone Waterproof Pipe", pipeWaterproof, pipeItemsCobblestone);
            pipeLiquidsStone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_STONE_ID, PipeLiquidsStone.class, "Stone Waterproof Pipe", pipeWaterproof, pipeItemsStone);
            pipeLiquidsIron = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_IRON_ID, PipeLiquidsIron.class, "Iron Waterproof Pipe", pipeWaterproof, pipeItemsIron);
            pipeLiquidsGold = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_GOLD_ID, PipeLiquidsGold.class, "Golden Waterproof Pipe", pipeWaterproof, pipeItemsGold);
            pipeLiquidsEmerald = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_EMERALD_ID, PipeLiquidsEmerald.class, "Emerald Waterproof Pipe", pipeWaterproof, pipeItemsEmerald);
            pipeLiquidsSandstone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_SANDSTONE_ID, PipeLiquidsSandstone.class, "Sandstone Waterproof Pipe", pipeWaterproof, pipeItemsSandstone);
            pipeLiquidsVoid = BuildCraftTransport.buildPipe(DefaultProps.PIPE_LIQUIDS_VOID_ID, PipeLiquidsVoid.class, "Void Waterproof Pipe", pipeWaterproof, pipeItemsVoid);
            pipePowerWood = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_WOOD_ID, PipePowerWood.class, "Wooden Conductive Pipe", Item.field_77767_aC, pipeItemsWood);
            pipePowerCobblestone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_COBBLESTONE_ID, PipePowerCobblestone.class, "Cobblestone Conductive Pipe", Item.field_77767_aC, pipeItemsCobblestone);
            pipePowerStone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_STONE_ID, PipePowerStone.class, "Stone Conductive Pipe", Item.field_77767_aC, pipeItemsStone);
            pipePowerQuartz = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_QUARTZ_ID, PipePowerQuartz.class, "Quartz Conductive Pipe", Item.field_77767_aC, pipeItemsQuartz);
            pipePowerGold = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_GOLD_ID, PipePowerGold.class, "Golden Conductive Pipe", Item.field_77767_aC, pipeItemsGold);
            pipePowerDiamond = BuildCraftTransport.buildPipe(DefaultProps.PIPE_POWER_DIAMOND_ID, PipePowerDiamond.class, "Diamond Conductive Pipe", Item.field_77767_aC, pipeItemsDiamond);
            pipeStructureCobblestone = BuildCraftTransport.buildPipe(DefaultProps.PIPE_STRUCTURE_COBBLESTONE_ID, PipeStructureCobblestone.class, "Cobblestone Structure Pipe", Block.field_71940_F, pipeItemsCobblestone);
            Property redPipeWireId = BuildCraftCore.mainConfiguration.get("item", "redPipeWire.id", DefaultProps.RED_PIPE_WIRE);
            redPipeWire = new ItemBuildCraft(redPipeWireId.getInt());
            redPipeWire.func_77655_b("redPipeWire");
            LanguageRegistry.addName((Object)redPipeWire, (String)"Red Pipe Wire");
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ItemStack[]{new ItemStack(Item.field_77756_aW, 1, 1), new ItemStack(Item.field_77767_aC, 1), new ItemStack(Item.field_77703_o, 1)}, 500, new ItemStack(redPipeWire, 8)));
            Property bluePipeWireId = BuildCraftCore.mainConfiguration.get("item", "bluePipeWire.id", DefaultProps.BLUE_PIPE_WIRE);
            bluePipeWire = new ItemBuildCraft(bluePipeWireId.getInt());
            bluePipeWire.func_77655_b("bluePipeWire");
            LanguageRegistry.addName((Object)bluePipeWire, (String)"Blue Pipe Wire");
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ItemStack[]{new ItemStack(Item.field_77756_aW, 1, 4), new ItemStack(Item.field_77767_aC, 1), new ItemStack(Item.field_77703_o, 1)}, 500, new ItemStack(bluePipeWire, 8)));
            Property greenPipeWireId = BuildCraftCore.mainConfiguration.get("item", "greenPipeWire.id", DefaultProps.GREEN_PIPE_WIRE);
            greenPipeWire = new ItemBuildCraft(greenPipeWireId.getInt());
            greenPipeWire.func_77655_b("greenPipeWire");
            LanguageRegistry.addName((Object)greenPipeWire, (String)"Green Pipe Wire");
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ItemStack[]{new ItemStack(Item.field_77756_aW, 1, 2), new ItemStack(Item.field_77767_aC, 1), new ItemStack(Item.field_77703_o, 1)}, 500, new ItemStack(greenPipeWire, 8)));
            Property yellowPipeWireId = BuildCraftCore.mainConfiguration.get("item", "yellowPipeWire.id", DefaultProps.YELLOW_PIPE_WIRE);
            yellowPipeWire = new ItemBuildCraft(yellowPipeWireId.getInt());
            yellowPipeWire.func_77655_b("yellowPipeWire");
            LanguageRegistry.addName((Object)yellowPipeWire, (String)"Yellow Pipe Wire");
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ItemStack[]{new ItemStack(Item.field_77756_aW, 1, 11), new ItemStack(Item.field_77767_aC, 1), new ItemStack(Item.field_77703_o, 1)}, 500, new ItemStack(yellowPipeWire, 8)));
            Property pipeGateId = BuildCraftCore.mainConfiguration.get("item", "pipeGate.id", DefaultProps.GATE_ID);
            pipeGate = new ItemGate(pipeGateId.getInt(), 0);
            pipeGate.func_77655_b("pipeGate");
            Property pipeGateAutarchicId = BuildCraftCore.mainConfiguration.get("item", "pipeGateAutarchic.id", DefaultProps.GATE_AUTARCHIC_ID);
            pipeGateAutarchic = new ItemGate(pipeGateAutarchicId.getInt(), 1);
            pipeGateAutarchic.func_77655_b("pipeGateAutarchic");
            Property pipeFacadeId = BuildCraftCore.mainConfiguration.get("item", "pipeFacade.id", DefaultProps.PIPE_FACADE_ID);
            facadeItem = new ItemFacade(pipeFacadeId.getInt());
            facadeItem.func_77655_b("pipeFacade");
            Property pipePlugId = BuildCraftCore.mainConfiguration.get("item", "pipePlug.id", DefaultProps.PIPE_PLUG_ID);
            plugItem = new ItemPlug(pipePlugId.getInt());
            plugItem.func_77655_b("pipePlug");
            AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ItemStack[]{new ItemStack(pipeStructureCobblestone)}, 1000, new ItemStack(plugItem, 8)));
        }
        finally {
            BuildCraftCore.mainConfiguration.save();
        }
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        TransportProxy.proxy.registerTileEntities();
        new BptBlockPipe(BuildCraftTransport.genericPipeBlock.field_71990_ca);
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsWood.field_77779_bT] = new BptItemPipeWooden();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeLiquidsWood.field_77779_bT] = new BptItemPipeWooden();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsIron.field_77779_bT] = new BptItemPipeIron();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeLiquidsIron.field_77779_bT] = new BptItemPipeIron();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsDiamond.field_77779_bT] = new BptItemPipeDiamond();
        BuildCraftCore.itemBptProps[BuildCraftTransport.pipeItemsEmerald.field_77779_bT] = new BptItemPipeEmerald();
        ActionManager.registerTriggerProvider(new PipeTriggerProvider());
        if (BuildCraftCore.loadDefaultRecipes) {
            this.loadRecipes();
        }
        TransportProxy.proxy.registerRenderers();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent evt) {
        ItemFacade.initialize();
    }

    public void loadRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(pipeWaterproof, 1), (Object[])new Object[]{new ItemStack(Item.field_77756_aW, 1, 2)});
        for (PipeRecipe pipe : pipeRecipes) {
            if (pipe.isShapeless) {
                GameRegistry.addShapelessRecipe((ItemStack)pipe.result, (Object[])pipe.input);
                continue;
            }
            CoreProxy.proxy.addCraftingRecipe(pipe.result, pipe.input);
        }
    }

    @Mod.IMCCallback
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        Splitter splitter = Splitter.on((String)"@").trimResults();
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (!"add-facade".equals(m.key)) continue;
            String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
            if (array.length != 2) {
                Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                continue;
            }
            Integer blId = Ints.tryParse((String)array[0]);
            Integer metaId = Ints.tryParse((String)array[1]);
            if (blId == null || metaId == null) {
                Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                continue;
            }
            ItemFacade.addFacade(new ItemStack(blId.intValue(), 1, metaId.intValue()));
        }
    }

    @Deprecated
    public static Item createPipe(int defaultID, Class clas, String descr, Object a, Object b, Object c) {
        if (c != null) {
            return BuildCraftTransport.buildPipe(defaultID, clas, descr, a, b, c);
        }
        return BuildCraftTransport.buildPipe(defaultID, clas, descr, a, b);
    }

    public static Item buildPipe(int defaultID, Class clas, String descr, Object ... ingredients) {
        String name = Character.toLowerCase(clas.getSimpleName().charAt(0)) + clas.getSimpleName().substring(1);
        Property prop = BuildCraftCore.mainConfiguration.getItem(name + ".id", defaultID);
        int id = prop.getInt(defaultID);
        ItemPipe res = BlockGenericPipe.registerPipe(id, clas);
        res.func_77655_b(clas.getSimpleName());
        LanguageRegistry.addName((Object)res, (String)descr);
        PipeRecipe recipe = new PipeRecipe();
        if (ingredients.length == 3) {
            recipe.result = new ItemStack((Item)res, 8);
            recipe.input = new Object[]{"ABC", Character.valueOf('A'), ingredients[0], Character.valueOf('B'), ingredients[1], Character.valueOf('C'), ingredients[2]};
            pipeRecipes.add(recipe);
        } else if (ingredients.length == 2) {
            recipe.isShapeless = true;
            recipe.result = new ItemStack((Item)res, 1);
            recipe.input = new Object[]{ingredients[0], ingredients[1]};
            pipeRecipes.add(recipe);
            if (ingredients[1] instanceof ItemPipe) {
                PipeRecipe uncraft = new PipeRecipe();
                uncraft.isShapeless = true;
                uncraft.input = new Object[]{new ItemStack((Item)res)};
                uncraft.result = new ItemStack((Item)ingredients[1]);
                pipeRecipes.add(uncraft);
            }
        }
        return res;
    }

    static {
        triggerPipeEmpty = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_EMPTY, TriggerPipeContents.Kind.Empty);
        triggerPipeItems = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_ITEMS, TriggerPipeContents.Kind.ContainsItems);
        triggerPipeLiquids = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_LIQUIDS, TriggerPipeContents.Kind.ContainsLiquids);
        triggerPipeEnergy = new TriggerPipeContents(DefaultProps.TRIGGER_PIPE_ENERGY, TriggerPipeContents.Kind.ContainsEnergy);
        triggerRedSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_RED_SIGNAL_ACTIVE, true, IPipe.WireColor.Red);
        triggerRedSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_RED_SIGNAL_INACTIVE, false, IPipe.WireColor.Red);
        triggerBlueSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_BLUE_SIGNAL_ACTIVE, true, IPipe.WireColor.Blue);
        triggerBlueSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_BLUE_SIGNAL_INACTIVE, false, IPipe.WireColor.Blue);
        triggerGreenSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_GREEN_SIGNAL_ACTIVE, true, IPipe.WireColor.Green);
        triggerGreenSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_GREEN_SIGNAL_INACTIVE, false, IPipe.WireColor.Green);
        triggerYellowSignalActive = new TriggerPipeSignal(DefaultProps.TRIGGER_YELLOW_SIGNAL_ACTIVE, true, IPipe.WireColor.Yellow);
        triggerYellowSignalInactive = new TriggerPipeSignal(DefaultProps.TRIGGER_YELLOW_SIGNAL_INACTIVE, false, IPipe.WireColor.Yellow);
        actionRedSignal = new ActionSignalOutput(DefaultProps.ACTION_RED_SIGNAL, IPipe.WireColor.Red);
        actionBlueSignal = new ActionSignalOutput(DefaultProps.ACTION_BLUE_SIGNAL, IPipe.WireColor.Blue);
        actionGreenSignal = new ActionSignalOutput(DefaultProps.ACTION_GREEN_SIGNAL, IPipe.WireColor.Green);
        actionYellowSignal = new ActionSignalOutput(DefaultProps.ACTION_YELLOW_SIGNAL, IPipe.WireColor.Yellow);
        actionEnergyPulser = new ActionEnergyPulser(DefaultProps.ACTION_ENERGY_PULSER);
        actionSingleEnergyPulse = new ActionSingleEnergyPulse(DefaultProps.ACTION_SINGLE_ENERGY_PULSE);
        pipeRecipes = new LinkedList();
    }

    private static class ExtractionHandler
    implements IExtractionHandler {
        private final String[] items;
        private final String[] liquids;

        public ExtractionHandler(String[] items, String[] liquids) {
            this.items = items;
            this.liquids = liquids;
        }

        @Override
        public boolean canExtractItems(Object extractor, World world, int i, int j, int k) {
            return this.testStrings(this.items, world, i, j, k);
        }

        @Override
        public boolean canExtractLiquids(Object extractor, World world, int i, int j, int k) {
            return this.testStrings(this.liquids, world, i, j, k);
        }

        private boolean testStrings(String[] excludedBlocks, World world, int i, int j, int k) {
            int id = world.func_72798_a(i, j, k);
            Block block = Block.field_71973_m[id];
            if (block == null) {
                return false;
            }
            int meta = world.func_72805_g(i, j, k);
            for (String excluded : excludedBlocks) {
                if (excluded.equals(block.func_71917_a())) {
                    return false;
                }
                String[] tokens = excluded.split(":");
                if (!tokens[0].equals(Integer.toString(id)) || tokens.length != 1 && !tokens[1].equals(Integer.toString(meta))) continue;
                return false;
            }
            return true;
        }
    }

    private static class PipeRecipe {
        boolean isShapeless = false;
        ItemStack result;
        Object[] input;

        private PipeRecipe() {
        }
    }
}

