/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    private static StackHelper instance;

    public static StackHelper instance() {
        if (instance == null) {
            instance = new StackHelper();
        }
        return instance;
    }

    public static void setInstance(StackHelper inst) {
        instance = inst;
    }

    protected StackHelper() {
    }

    public boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public int mergeStacks(ItemStack mergeSource, ItemStack mergeTarget, boolean doMerge) {
        if (!this.canStacksMerge(mergeSource, mergeTarget)) {
            return 0;
        }
        int mergeCount = Math.min(mergeTarget.func_77976_d() - mergeTarget.field_77994_a, mergeSource.field_77994_a);
        if (mergeCount < 1) {
            return 0;
        }
        if (doMerge) {
            mergeTarget.field_77994_a += mergeCount;
        }
        return mergeCount;
    }

    public boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary) {
        int idComp;
        int idBase;
        if (this.isMatchingItem(base, comparison)) {
            return true;
        }
        return oreDictionary && (idBase = OreDictionary.getOreID((ItemStack)base)) >= 0 && (idComp = OreDictionary.getOreID((ItemStack)comparison)) >= 0 && idBase == idComp;
    }

    public boolean isMatchingItem(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.field_77993_c != comparison.field_77993_c) {
            return false;
        }
        if (base.func_77973_b().func_77614_k() && base.func_77960_j() != Short.MAX_VALUE && base.func_77960_j() != comparison.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)base, (ItemStack)comparison);
    }
}

