/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.core.BuildCraftAPI;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet60Explosion;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockUtil {
    public static List getItemStackFromBlock(World world, int i, int j, int k) {
        Block block = Block.field_71973_m[world.func_72798_a(i, j, k)];
        if (block == null) {
            return null;
        }
        if (block.isAirBlock(world, i, j, k)) {
            return null;
        }
        int meta = world.func_72805_g(i, j, k);
        return block.getBlockDropped(world, i, j, k, meta, 0);
    }

    public static void breakBlock(World world, int x, int y, int z) {
        BlockUtil.breakBlock(world, x, y, z, BuildCraftCore.itemLifespan);
    }

    public static void breakBlock(World world, int x, int y, int z, int forcedLifespan) {
        int blockId = world.func_72798_a(x, y, z);
        if (blockId != 0 && BuildCraftCore.dropBrokenBlocks && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            ArrayList items = Block.field_71973_m[blockId].getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0);
            for (ItemStack item : items) {
                float var = 0.7f;
                double dx = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                double dy = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                double dz = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, item);
                entityitem.lifespan = forcedLifespan;
                entityitem.field_70293_c = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_94575_c(x, y, z, 0);
    }

    public static boolean canChangeBlock(World world, int x, int y, int z) {
        return BlockUtil.canChangeBlock(world.func_72798_a(x, y, z), world, x, y, z);
    }

    public static boolean canChangeBlock(int blockID, World world, int x, int y, int z) {
        Block block = Block.field_71973_m[blockID];
        if (blockID == 0 || block == null || block.isAirBlock(world, x, y, z)) {
            return true;
        }
        if (block.func_71934_m(world, x, y, z) < 0.0f) {
            return false;
        }
        if (blockID == BuildCraftEnergy.oilMoving.field_71990_ca || blockID == BuildCraftEnergy.oilStill.field_71990_ca) {
            return false;
        }
        return blockID != Block.field_71938_D.field_71990_ca && blockID != Block.field_71944_C.field_71990_ca;
    }

    public static boolean isSoftBlock(World world, int x, int y, int z) {
        return BlockUtil.isSoftBlock(world.func_72798_a(x, y, z), world, x, y, z);
    }

    public static boolean isSoftBlock(int blockID, World world, int x, int y, int z) {
        Block block = Block.field_71973_m[blockID];
        return blockID == 0 || block == null || BuildCraftAPI.softBlocks[blockID] || block.isAirBlock(world, x, y, z);
    }

    public static boolean isToughBlock(World world, int x, int y, int z) {
        return !world.func_72803_f(x, y, z).func_76229_l();
    }

    public static void explodeBlock(World world, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        Explosion explosion = new Explosion(world, null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f);
        explosion.field_77281_g.add(new ChunkPosition(x, y, z));
        explosion.func_77279_a(true);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP) || !(player.func_70092_e((double)x, (double)y, (double)z) < 4096.0)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_72567_b((Packet)new Packet60Explosion((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, explosion.field_77281_g, null));
        }
    }
}

