/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.core.Box;
import buildcraft.core.DefaultAreaProvider;
import buildcraft.core.EntityRobot;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.IMachine;
import buildcraft.core.blueprints.BptBlueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import buildcraft.factory.EntityMechanicalArm;
import buildcraft.factory.TileMachine;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;

public class TileQuarry
extends TileMachine
implements IMachine,
IPowerReceptor,
IPipeConnection,
IBuilderInventory {
    @TileNetworkData
    public Box box = new Box();
    @TileNetworkData
    public boolean inProcess = false;
    @TileNetworkData
    public int targetX;
    @TileNetworkData
    public int targetY;
    @TileNetworkData
    public int targetZ;
    @TileNetworkData
    public double headPosX;
    @TileNetworkData
    public double headPosY;
    @TileNetworkData
    public double headPosZ;
    @TileNetworkData
    public double speed = 0.03;
    @TileNetworkData
    public boolean builderDone = false;
    public EntityRobot builder;
    BptBuilderBase bluePrintBuilder;
    public EntityMechanicalArm arm;
    public IPowerProvider powerProvider;
    boolean isDigging = false;
    public static final int MAX_ENERGY = 15000;
    private boolean loadDefaultBoundaries = false;
    private boolean movingHorizontally;
    private boolean movingVertically;
    private double headTrajectory;
    private ForgeChunkManager.Ticket chunkTicket;
    @TileNetworkData
    public boolean isAlive;
    public EntityPlayer placedBy;
    private final LinkedList visitList = Lists.newLinkedList();

    public TileQuarry() {
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.initPowerProvider();
    }

    private void initPowerProvider() {
        this.powerProvider.configure(20, 25, 100, 25, 15000);
        this.powerProvider.configurePowerPerdition(2, 1);
    }

    public void createUtilsIfNeeded() {
        if (this.bluePrintBuilder == null) {
            if (!this.box.isInitialized()) {
                this.setBoundaries(this.loadDefaultBoundaries);
            }
            this.initializeBluePrintBuilder();
        }
        if (this.builderDone) {
            this.box.deleteLasers();
            if (this.arm == null) {
                this.createArm();
            }
            if (this.findTarget(false)) {
                this.isDigging = true;
                if (this.box != null && (this.headPosX < (double)this.box.xMin || this.headPosX > (double)this.box.xMax || this.headPosZ < (double)this.box.zMin || this.headPosZ > (double)this.box.zMax)) {
                    this.setHead(this.box.xMin + 1, this.field_70330_m + 2, this.box.zMin + 1);
                }
            }
        } else {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
            this.isDigging = true;
        }
    }

    private void createArm() {
        this.field_70331_k.func_72838_d((Entity)new EntityMechanicalArm(this.field_70331_k, (float)this.box.xMin + 0.75f, (float)(this.field_70330_m + this.bluePrintBuilder.bluePrint.sizeY - 1) + 0.25f, (float)this.box.zMin + 0.75f, (float)(this.bluePrintBuilder.bluePrint.sizeX - 2) + 0.5f, (float)(this.bluePrintBuilder.bluePrint.sizeZ - 2) + 0.5f, this));
    }

    public void setArm(EntityMechanicalArm arm) {
        this.arm = arm;
    }

    @Override
    public void func_70316_g() {
        float energyToUse;
        float energy;
        if (!this.isAlive && CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            super.func_70316_g();
            return;
        }
        if (!CoreProxy.proxy.isSimulating(this.field_70331_k) && this.isAlive) {
            super.func_70316_g();
            return;
        }
        super.func_70316_g();
        if (this.inProcess && (energy = this.powerProvider.useEnergy(energyToUse = 2.0f + this.powerProvider.getEnergyStored() / 500.0f, energyToUse, true)) > 0.0f) {
            this.moveHead(0.1 + (double)(energy / 200.0f));
        }
        if (CoreProxy.proxy.isSimulating(this.field_70331_k) && this.inProcess) {
            this.sendNetworkUpdate();
        }
        if (this.inProcess || !this.isDigging) {
            return;
        }
        this.createUtilsIfNeeded();
        if (this.bluePrintBuilder != null) {
            this.builderDone = this.bluePrintBuilder.done;
            if (!this.builderDone) {
                this.buildFrame();
                return;
            }
            if (this.builder != null && this.builder.done()) {
                this.box.deleteLasers();
                this.builder.func_70106_y();
                this.builder = null;
            }
        }
        if (this.builder == null) {
            this.dig();
        }
    }

    @Override
    public void doWork() {
    }

    protected void buildFrame() {
        this.powerProvider.configure(20, 25, 100, 25, 15000);
        if (this.powerProvider.useEnergy(25.0f, 25.0f, true) != 25.0f) {
            return;
        }
        this.powerProvider.getTimeTracker().markTime(this.field_70331_k);
        if (this.builder == null) {
            this.builder = new EntityRobot(this.field_70331_k, this.box);
            this.field_70331_k.func_72838_d((Entity)this.builder);
        }
        if (this.builder.readyToBuild()) {
            this.builder.scheduleContruction(this.bluePrintBuilder.getNextBlock(this.field_70331_k, this), this.bluePrintBuilder.getContext());
        }
    }

    protected void dig() {
        this.powerProvider.configure(20, 30, 500, 50, 15000);
        if (this.powerProvider.useEnergy(60.0f, 60.0f, true) != 60.0f) {
            return;
        }
        if (!this.findTarget(true)) {
            if (this.arm != null && this.box != null) {
                this.setTarget(this.box.xMin + 1, this.field_70330_m + 2, this.box.zMin + 1);
            }
            this.isDigging = false;
        }
        this.inProcess = true;
        this.movingHorizontally = true;
        this.movingVertically = true;
        double[] head = this.getHead();
        int[] target = this.getTarget();
        this.headTrajectory = Math.atan2((double)target[2] - head[2], (double)target[0] - head[0]);
    }

    public boolean findTarget(boolean doSet) {
        if (this.field_70331_k.field_72995_K) {
            return false;
        }
        boolean columnVisitListIsUpdated = false;
        if (this.visitList.isEmpty()) {
            this.createColumnVisitList();
            columnVisitListIsUpdated = true;
        }
        if (!doSet) {
            return !this.visitList.isEmpty();
        }
        if (this.visitList.isEmpty()) {
            return false;
        }
        int[] nextTarget = (int[])this.visitList.removeFirst();
        if (!columnVisitListIsUpdated) {
            for (int y = nextTarget[1] + 1; y < this.field_70330_m + 3; ++y) {
                int blockID = this.field_70331_k.func_72798_a(nextTarget[0], y, nextTarget[2]);
                if (!BlockUtil.canChangeBlock(blockID, this.field_70331_k, nextTarget[0], y, nextTarget[2]) || BlockUtil.isSoftBlock(blockID, this.field_70331_k, nextTarget[0], y, nextTarget[2])) continue;
                this.createColumnVisitList();
                nextTarget = (int[])this.visitList.removeFirst();
                break;
            }
        }
        this.setTarget(nextTarget[0], nextTarget[1] + 1, nextTarget[2]);
        return true;
    }

    private void createColumnVisitList() {
        this.visitList.clear();
        Integer[][] columnHeights = new Integer[this.bluePrintBuilder.bluePrint.sizeX - 2][this.bluePrintBuilder.bluePrint.sizeZ - 2];
        boolean[][] blockedColumns = new boolean[this.bluePrintBuilder.bluePrint.sizeX - 2][this.bluePrintBuilder.bluePrint.sizeZ - 2];
        for (int searchY = this.field_70330_m + 3; searchY >= 0; --searchY) {
            int incX;
            int endX;
            int startX;
            if (searchY % 2 == 0) {
                startX = 0;
                endX = this.bluePrintBuilder.bluePrint.sizeX - 2;
                incX = 1;
            } else {
                startX = this.bluePrintBuilder.bluePrint.sizeX - 3;
                endX = -1;
                incX = -1;
            }
            for (int searchX = startX; searchX != endX; searchX += incX) {
                int incZ;
                int endZ;
                int startZ;
                if (searchX % 2 == searchY % 2) {
                    startZ = 0;
                    endZ = this.bluePrintBuilder.bluePrint.sizeZ - 2;
                    incZ = 1;
                } else {
                    startZ = this.bluePrintBuilder.bluePrint.sizeZ - 3;
                    endZ = -1;
                    incZ = -1;
                }
                for (int searchZ = startZ; searchZ != endZ; searchZ += incZ) {
                    if (blockedColumns[searchX][searchZ]) continue;
                    Integer height = columnHeights[searchX][searchZ];
                    int bx = this.box.xMin + searchX + 1;
                    int by = searchY;
                    int bz = this.box.zMin + searchZ + 1;
                    if (height == null) {
                        columnHeights[searchX][searchZ] = height = Integer.valueOf(this.field_70331_k.func_72976_f(bx, bz));
                    }
                    if (height < by) continue;
                    int blockID = this.field_70331_k.func_72798_a(bx, by, bz);
                    if (!BlockUtil.canChangeBlock(blockID, this.field_70331_k, bx, by, bz)) {
                        blockedColumns[searchX][searchZ] = true;
                    } else if (!BlockUtil.isSoftBlock(blockID, this.field_70331_k, bx, by, bz)) {
                        this.visitList.add(new int[]{bx, by, bz});
                    }
                    if (this.visitList.size() <= this.bluePrintBuilder.bluePrint.sizeZ * this.bluePrintBuilder.bluePrint.sizeX * 2) continue;
                    return;
                }
            }
        }
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.initPowerProvider();
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
            this.loadDefaultBoundaries = false;
        } else if (nbttagcompound.func_74764_b("xSize")) {
            int xMin = nbttagcompound.func_74762_e("xMin");
            int zMin = nbttagcompound.func_74762_e("zMin");
            int xSize = nbttagcompound.func_74762_e("xSize");
            int ySize = nbttagcompound.func_74762_e("ySize");
            int zSize = nbttagcompound.func_74762_e("zSize");
            this.box.initialize(xMin, this.field_70330_m, zMin, xMin + xSize - 1, this.field_70330_m + ySize - 1, zMin + zSize - 1);
            this.loadDefaultBoundaries = false;
        } else {
            this.loadDefaultBoundaries = true;
        }
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
        this.headPosX = nbttagcompound.func_74769_h("headPosX");
        this.headPosY = nbttagcompound.func_74769_h("headPosY");
        this.headPosZ = nbttagcompound.func_74769_h("headPosZ");
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        nbttagcompound.func_74768_a("targetX", this.targetX);
        nbttagcompound.func_74768_a("targetY", this.targetY);
        nbttagcompound.func_74768_a("targetZ", this.targetZ);
        nbttagcompound.func_74780_a("headPosX", this.headPosX);
        nbttagcompound.func_74780_a("headPosY", this.headPosY);
        nbttagcompound.func_74780_a("headPosZ", this.headPosZ);
        NBTTagCompound boxTag = new NBTTagCompound();
        this.box.writeToNBT(boxTag);
        nbttagcompound.func_74782_a("box", (NBTBase)boxTag);
    }

    public void positionReached() {
        this.inProcess = false;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        int i = this.targetX;
        int j = this.targetY - 1;
        int k = this.targetZ;
        int blockId = this.field_70331_k.func_72798_a(i, j, k);
        if (this.isQuarriableBlock(i, j, k)) {
            this.powerProvider.getTimeTracker().markTime(this.field_70331_k);
            List stacks = BlockUtil.getItemStackFromBlock(this.field_70331_k, i, j, k);
            if (stacks != null) {
                for (ItemStack s : stacks) {
                    if (s == null) continue;
                    this.mineStack(s);
                }
            }
            this.field_70331_k.func_72889_a(null, 2001, i, j, k, blockId + (this.field_70331_k.func_72805_g(i, j, k) << 12));
            this.field_70331_k.func_94575_c(i, j, k, 0);
        }
        double[] head = this.getHead();
        AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)(head[0] - 2.0), (double)(head[1] - 2.0), (double)(head[2] - 2.0), (double)(head[0] + 3.0), (double)(head[1] + 3.0), (double)(head[2] + 3.0));
        List result = this.field_70331_k.func_72872_a(EntityItem.class, axis);
        for (int ii = 0; ii < result.size(); ++ii) {
            if (!(result.get(ii) instanceof EntityItem)) continue;
            EntityItem entity = (EntityItem)result.get(ii);
            if (entity.field_70128_L) continue;
            ItemStack mineable = entity.func_92059_d();
            if (mineable.field_77994_a <= 0) continue;
            CoreProxy.proxy.removeEntity((Entity)entity);
            this.mineStack(mineable);
        }
    }

    private void mineStack(ItemStack stack) {
        ItemStack added = Utils.addToRandomInventory(stack, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        stack.field_77994_a -= added.field_77994_a;
        if (stack.field_77994_a > 0) {
            Utils.addToRandomPipeEntry(this, ForgeDirection.UNKNOWN, stack);
        }
        if (stack.field_77994_a > 0) {
            float f = this.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = this.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = this.field_70331_k.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(this.field_70331_k, (double)((float)this.field_70329_l + f), (double)((float)this.field_70330_m + f1 + 0.5f), (double)((float)this.field_70327_n + f2), stack);
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.field_70293_c = 10;
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)this.field_70331_k.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)this.field_70331_k.field_73012_v.nextGaussian() * f3 + 1.0f;
            entityitem.field_70179_y = (float)this.field_70331_k.field_73012_v.nextGaussian() * f3;
            this.field_70331_k.func_72838_d((Entity)entityitem);
        }
    }

    private boolean isQuarriableBlock(int bx, int by, int bz) {
        int blockID = this.field_70331_k.func_72798_a(bx, by, bz);
        return BlockUtil.canChangeBlock(blockID, this.field_70331_k, bx, by, bz) && !BlockUtil.isSoftBlock(blockID, this.field_70331_k, bx, by, bz);
    }

    @Override
    public void func_70313_j() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        super.func_70313_j();
        this.destroy();
    }

    public void onChunkUnload() {
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.arm != null) {
            this.arm.func_70106_y();
        }
        if (this.builder != null) {
            this.builder.func_70106_y();
        }
        this.box.deleteLasers();
        this.arm = null;
    }

    @Override
    public boolean isActive() {
        return this.isDigging;
    }

    private void setBoundaries(boolean useDefault) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)BuildCraftFactory.instance, (World)this.field_70331_k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (this.chunkTicket == null) {
            this.isAlive = false;
            if (this.placedBy != null && CoreProxy.proxy.isSimulating(this.field_70331_k)) {
                PacketDispatcher.sendPacketToPlayer((Packet)new Packet3Chat(String.format("[BUILDCRAFT] The quarry at %d, %d, %d will not work because there are no more chunkloaders available", this.field_70329_l, this.field_70330_m, this.field_70327_n)), (Player)((Player)this.placedBy));
            }
            this.sendNetworkUpdate();
            return;
        }
        this.chunkTicket.getModData().func_74768_a("quarryX", this.field_70329_l);
        this.chunkTicket.getModData().func_74768_a("quarryY", this.field_70330_m);
        this.chunkTicket.getModData().func_74768_a("quarryZ", this.field_70327_n);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70329_l >> 4, this.field_70327_n >> 4));
        IAreaProvider a = null;
        if (!useDefault) {
            a = Utils.getNearbyAreaProvider(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        if (a == null) {
            a = new DefaultAreaProvider(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70329_l + 10, this.field_70330_m + 4, this.field_70327_n + 10);
            useDefault = true;
        }
        int xSize = a.xMax() - a.xMin() + 1;
        int zSize = a.zMax() - a.zMin() + 1;
        if (xSize < 3 || zSize < 3 || xSize * zSize >> 8 >= this.chunkTicket.getMaxChunkListDepth()) {
            if (this.placedBy != null) {
                PacketDispatcher.sendPacketToPlayer((Packet)new Packet3Chat(String.format("Quarry size is outside of chunkloading bounds or too small %d %d (%d)", xSize, zSize, this.chunkTicket.getMaxChunkListDepth())), (Player)((Player)this.placedBy));
            }
            a = new DefaultAreaProvider(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70329_l + 10, this.field_70330_m + 4, this.field_70327_n + 10);
            useDefault = true;
        }
        xSize = a.xMax() - a.xMin() + 1;
        int ySize = a.yMax() - a.yMin() + 1;
        zSize = a.zMax() - a.zMin() + 1;
        this.box.initialize(a);
        if (ySize < 5) {
            ySize = 5;
            this.box.yMax = this.box.yMin + ySize - 1;
        }
        if (useDefault) {
            int zMin;
            int xMin;
            ForgeDirection o = ForgeDirection.values()[this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n)].getOpposite();
            switch (o) {
                case EAST: {
                    xMin = this.field_70329_l + 1;
                    zMin = this.field_70327_n - 4 - 1;
                    break;
                }
                case WEST: {
                    xMin = this.field_70329_l - 9 - 2;
                    zMin = this.field_70327_n - 4 - 1;
                    break;
                }
                case SOUTH: {
                    xMin = this.field_70329_l - 4 - 1;
                    zMin = this.field_70327_n + 1;
                    break;
                }
                default: {
                    xMin = this.field_70329_l - 4 - 1;
                    zMin = this.field_70327_n - 9 - 2;
                }
            }
            this.box.initialize(xMin, this.field_70330_m, zMin, xMin + xSize - 1, this.field_70330_m + ySize - 1, zMin + zSize - 1);
        }
        a.removeFromWorld();
        this.forceChunkLoading(this.chunkTicket);
    }

    private void initializeBluePrintBuilder() {
        BptBlueprint bluePrint = new BptBlueprint(this.box.sizeX(), this.box.sizeY(), this.box.sizeZ());
        for (int i = 0; i < bluePrint.sizeX; ++i) {
            for (int j = 0; j < bluePrint.sizeY; ++j) {
                for (int k = 0; k < bluePrint.sizeZ; ++k) {
                    bluePrint.setBlockId(i, j, k, 0);
                }
            }
        }
        for (int it = 0; it < 2; ++it) {
            for (int i = 0; i < bluePrint.sizeX; ++i) {
                bluePrint.setBlockId(i, it * (this.box.sizeY() - 1), 0, BuildCraftFactory.frameBlock.field_71990_ca);
                bluePrint.setBlockId(i, it * (this.box.sizeY() - 1), bluePrint.sizeZ - 1, BuildCraftFactory.frameBlock.field_71990_ca);
            }
            for (int k = 0; k < bluePrint.sizeZ; ++k) {
                bluePrint.setBlockId(0, it * (this.box.sizeY() - 1), k, BuildCraftFactory.frameBlock.field_71990_ca);
                bluePrint.setBlockId(bluePrint.sizeX - 1, it * (this.box.sizeY() - 1), k, BuildCraftFactory.frameBlock.field_71990_ca);
            }
        }
        for (int h = 1; h < this.box.sizeY(); ++h) {
            bluePrint.setBlockId(0, h, 0, BuildCraftFactory.frameBlock.field_71990_ca);
            bluePrint.setBlockId(0, h, bluePrint.sizeZ - 1, BuildCraftFactory.frameBlock.field_71990_ca);
            bluePrint.setBlockId(bluePrint.sizeX - 1, h, 0, BuildCraftFactory.frameBlock.field_71990_ca);
            bluePrint.setBlockId(bluePrint.sizeX - 1, h, bluePrint.sizeZ - 1, BuildCraftFactory.frameBlock.field_71990_ca);
        }
        this.bluePrintBuilder = new BptBuilderBlueprint(bluePrint, this.field_70331_k, this.box.xMin, this.field_70330_m, this.box.zMin);
    }

    @Override
    public void postPacketHandling(PacketUpdate packet) {
        super.postPacketHandling(packet);
        if (!this.isAlive) {
            this.box.deleteLasers();
            this.box.reset();
            return;
        }
        this.createUtilsIfNeeded();
        if (this.arm != null) {
            this.arm.setHead(this.headPosX, this.headPosY, this.headPosZ);
            this.arm.updatePosition();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (CoreProxy.proxy.isSimulating(this.field_70331_k) && !this.box.initialized) {
            this.setBoundaries(false);
        }
        this.createUtilsIfNeeded();
        this.sendNetworkUpdate();
    }

    public void reinitalize() {
        this.builderDone = false;
        this.initializeBluePrintBuilder();
        this.isDigging = true;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public boolean manageLiquids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return true;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public String func_70303_b() {
        return "";
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public boolean isBuildingMaterial(int i) {
        return true;
    }

    @Override
    public boolean allowAction(IAction action) {
        return false;
    }

    public void moveHead(double instantSpeed) {
        int[] target = this.getTarget();
        double[] head = this.getHead();
        if (this.movingHorizontally) {
            if (Math.abs((double)target[0] - head[0]) < instantSpeed * 2.0 && Math.abs((double)target[2] - head[2]) < instantSpeed * 2.0) {
                head[0] = target[0];
                head[2] = target[2];
                this.movingHorizontally = false;
                if (!this.movingVertically) {
                    this.positionReached();
                    head[1] = target[1];
                }
            } else {
                head[0] = head[0] + Math.cos(this.headTrajectory) * instantSpeed;
                head[2] = head[2] + Math.sin(this.headTrajectory) * instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        if (this.movingVertically) {
            if (Math.abs((double)target[1] - head[1]) < instantSpeed * 2.0) {
                head[1] = target[1];
                this.movingVertically = false;
                if (!this.movingHorizontally) {
                    this.positionReached();
                    head[0] = target[0];
                    head[2] = target[2];
                }
            } else {
                head[1] = (double)target[1] > head[1] ? head[1] + instantSpeed : head[1] - instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        this.updatePosition();
    }

    private void updatePosition() {
        if (this.arm != null && this.field_70331_k.field_72995_K) {
            this.arm.setHead(this.headPosX, this.headPosY, this.headPosZ);
            this.arm.updatePosition();
        }
    }

    private void setHead(double x, double y, double z) {
        this.headPosX = x;
        this.headPosY = y;
        this.headPosZ = z;
    }

    private double[] getHead() {
        return new double[]{this.headPosX, this.headPosY, this.headPosZ};
    }

    private int[] getTarget() {
        return new int[]{this.targetX, this.targetY, this.targetZ};
    }

    private void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        HashSet chunks = Sets.newHashSet();
        this.isAlive = true;
        ChunkCoordIntPair quarryChunk = new ChunkCoordIntPair(this.field_70329_l >> 4, this.field_70327_n >> 4);
        chunks.add(quarryChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)quarryChunk);
        for (int chunkX = this.box.xMin >> 4; chunkX <= this.box.xMax >> 4; ++chunkX) {
            for (int chunkZ = this.box.zMin >> 4; chunkZ <= this.box.zMax >> 4; ++chunkZ) {
                ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
                chunks.add(chunk);
            }
        }
        if (this.placedBy != null) {
            PacketDispatcher.sendPacketToPlayer((Packet)new Packet3Chat(String.format("[BUILDCRAFT] The quarry at %d %d %d will keep %d chunks loaded", this.field_70329_l, this.field_70330_m, this.field_70327_n, chunks.size())), (Player)((Player)this.placedBy));
        }
        this.sendNetworkUpdate();
    }
}

