/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.api.transport.IPipe;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.network.TilePacketWrapper;
import buildcraft.core.triggers.ActionRedstoneOutput;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.FallbackWrapper;
import buildcraft.transport.Gate;
import buildcraft.transport.GateVanilla;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportStructure;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.triggers.ActionSignalOutput;
import com.google.common.collect.HashMultiset;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class Pipe
implements IPipe,
IDropControlInventory {
    public int[] signalStrength = new int[]{0, 0, 0, 0};
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public World worldObj;
    public TileGenericPipe container;
    public final PipeTransport transport;
    public final PipeLogic logic;
    public final int itemID;
    private boolean internalUpdateScheduled = false;
    public boolean[] wireSet = new boolean[]{false, false, false, false};
    public Gate gate;
    private static Map networkWrappers = new HashMap();
    public ITrigger[] activatedTriggers = new ITrigger[8];
    public ITriggerParameter[] triggerParameters = new ITriggerParameter[8];
    public IAction[] activatedActions = new IAction[8];
    public boolean[] broadcastSignal = new boolean[]{false, false, false, false};
    public boolean broadcastRedstone = false;
    public SafeTimeTracker actionTracker = new SafeTimeTracker();
    private boolean initialized = false;
    private static boolean fixedTriggers = false;

    public Pipe(PipeTransport transport, PipeLogic logic, int itemID) {
        this.transport = transport;
        this.logic = logic;
        this.itemID = itemID;
        if (!networkWrappers.containsKey(this.getClass())) {
            networkWrappers.put(this.getClass(), new TilePacketWrapper(new Class[]{TileGenericPipe.class, this.transport.getClass(), this.logic.getClass()}));
        }
    }

    private void setPosition(int xCoord, int yCoord, int zCoord) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.transport.setPosition(xCoord, yCoord, zCoord);
        this.logic.setPosition(xCoord, yCoord, zCoord);
    }

    private void setWorld(World worldObj) {
        if (worldObj != null && this.worldObj == null) {
            this.worldObj = worldObj;
            this.transport.setWorld(worldObj);
            this.logic.setWorld(worldObj);
        }
    }

    public void setTile(TileEntity tile) {
        this.container = (TileGenericPipe)tile;
        this.transport.setTile((TileGenericPipe)tile);
        this.logic.setTile((TileGenericPipe)tile);
        this.setPosition(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        this.setWorld(tile.field_70331_k);
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        this.transport.onBlockPlaced();
    }

    public void onBlockPlacedBy(EntityLiving placer) {
    }

    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange(blockId);
        this.transport.onNeighborBlockChange(blockId);
        this.updateSignalState();
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        return this.logic.canPipeConnect(tile, side) && this.transport.canPipeConnect(tile, side);
    }

    public int getIconIndexForItem() {
        return this.getIconIndex(ForgeDirection.UNKNOWN);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IIconProvider getIconProvider();

    public abstract int getIconIndex(ForgeDirection var1);

    public void updateEntity() {
        this.transport.updateEntity();
        this.logic.updateEntity();
        if (this.internalUpdateScheduled) {
            this.internalUpdate();
            this.internalUpdateScheduled = false;
        }
        if (this.worldObj.field_72995_K) {
            return;
        }
        if (this.actionTracker.markTimeIfDelay(this.worldObj, 10L)) {
            this.resolveActions();
        }
        if (this.gate != null) {
            this.gate.update();
        }
    }

    private void internalUpdate() {
        this.updateSignalState();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        int i;
        this.transport.writeToNBT(nbttagcompound);
        this.logic.writeToNBT(nbttagcompound);
        if (this.gate != null) {
            NBTTagCompound nbttagcompoundC = new NBTTagCompound();
            this.gate.writeToNBT(nbttagcompoundC);
            nbttagcompound.func_74782_a("Gate", (NBTBase)nbttagcompoundC);
            for (int i2 = 0; i2 < 4; ++i2) {
                nbttagcompound.func_74757_a("wireState[" + i2 + "]", this.broadcastSignal[i2]);
            }
            nbttagcompound.func_74757_a("redstoneState", this.broadcastRedstone);
        }
        for (i = 0; i < 4; ++i) {
            nbttagcompound.func_74757_a("wireSet[" + i + "]", this.wireSet[i]);
        }
        for (i = 0; i < 8; ++i) {
            nbttagcompound.func_74768_a("action[" + i + "]", this.activatedActions[i] != null ? this.activatedActions[i].getId() : 0);
            nbttagcompound.func_74768_a("trigger[" + i + "]", this.activatedTriggers[i] != null ? this.activatedTriggers[i].getId() : 0);
        }
        for (i = 0; i < 8; ++i) {
            if (this.triggerParameters[i] == null) continue;
            NBTTagCompound cpt = new NBTTagCompound();
            this.triggerParameters[i].writeToNBT(cpt);
            nbttagcompound.func_74782_a("triggerParameters[" + i + "]", (NBTBase)cpt);
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        int i;
        Gate.GateKind kind;
        this.transport.readFromNBT(nbttagcompound);
        this.logic.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("Gate")) {
            NBTTagCompound nbttagcompoundP = nbttagcompound.func_74775_l("Gate");
            this.gate = new GateVanilla(this);
            this.gate.readFromNBT(nbttagcompoundP);
        } else if (nbttagcompound.func_74764_b("gateKind") && (kind = Gate.GateKind.values()[nbttagcompound.func_74762_e("gateKind")]) != Gate.GateKind.None) {
            this.gate = new GateVanilla(this);
            this.gate.kind = kind;
        }
        if (this.gate != null) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.broadcastSignal[i2] = nbttagcompound.func_74767_n("wireState[" + i2 + "]");
            }
            this.broadcastRedstone = nbttagcompound.func_74767_n("redstoneState");
        }
        for (i = 0; i < 4; ++i) {
            this.wireSet[i] = nbttagcompound.func_74767_n("wireSet[" + i + "]");
        }
        for (i = 0; i < 8; ++i) {
            this.activatedActions[i] = ActionManager.actions[nbttagcompound.func_74762_e("action[" + i + "]")];
            this.activatedTriggers[i] = ActionManager.triggers[nbttagcompound.func_74762_e("trigger[" + i + "]")];
        }
        Pipe.fixTriggers();
        for (i = 0; i < 8; ++i) {
            if (!nbttagcompound.func_74764_b("triggerParameters[" + i + "]")) continue;
            this.triggerParameters[i] = new TriggerParameter();
            this.triggerParameters[i].readFromNBT(nbttagcompound.func_74775_l("triggerParameters[" + i + "]"));
        }
    }

    public void initialize() {
        if (!this.initialized) {
            this.transport.initialize();
            this.logic.initialize();
            this.initialized = true;
            this.updateSignalState();
        }
    }

    private void readNearbyPipesSignal(IPipe.WireColor color) {
        TileGenericPipe tilePipe;
        TileEntity tile;
        boolean foundBiggerSignal = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            tilePipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isFullyDefined(tilePipe.pipe) || !this.isWireConnectedTo(tile, color)) continue;
            foundBiggerSignal |= this.receiveSignal(tilePipe.pipe.signalStrength[color.ordinal()] - 1, color);
        }
        if (!foundBiggerSignal && this.signalStrength[color.ordinal()] != 0) {
            this.signalStrength[color.ordinal()] = 0;
            this.container.scheduleRenderUpdate();
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                tile = this.container.getTile(o);
                if (!(tile instanceof TileGenericPipe)) continue;
                tilePipe = (TileGenericPipe)tile;
                if (!BlockGenericPipe.isFullyDefined(tilePipe.pipe)) continue;
                tilePipe.pipe.internalUpdateScheduled = true;
            }
        }
    }

    private void updateSignalState() {
        for (IPipe.WireColor c : IPipe.WireColor.values()) {
            this.updateSignalStateForColor(c);
        }
    }

    private void updateSignalStateForColor(IPipe.WireColor color) {
        if (!this.wireSet[color.ordinal()]) {
            return;
        }
        if (this.broadcastSignal[color.ordinal()]) {
            this.receiveSignal(255, color);
        } else {
            this.readNearbyPipesSignal(color);
        }
        if (this.signalStrength[color.ordinal()] > 1) {
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.container.getTile(o);
                if (!(tile instanceof TileGenericPipe)) continue;
                TileGenericPipe tilePipe = (TileGenericPipe)tile;
                if (!BlockGenericPipe.isFullyDefined(tilePipe.pipe) || !tilePipe.pipe.wireSet[color.ordinal()] || !this.isWireConnectedTo(tile, color)) continue;
                tilePipe.pipe.receiveSignal(this.signalStrength[color.ordinal()] - 1, color);
            }
        }
    }

    private boolean receiveSignal(int signal, IPipe.WireColor color) {
        if (this.worldObj == null) {
            return false;
        }
        int oldSignal = this.signalStrength[color.ordinal()];
        if (signal >= this.signalStrength[color.ordinal()] && signal != 0) {
            this.signalStrength[color.ordinal()] = signal;
            this.internalUpdateScheduled = true;
            if (oldSignal == 0) {
                this.container.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean inputOpen(ForgeDirection from) {
        return this.transport.inputOpen(from) && this.logic.inputOpen(from);
    }

    public boolean outputOpen(ForgeDirection to) {
        return this.transport.outputOpen(to) && this.logic.outputOpen(to);
    }

    public void onEntityCollidedWithBlock(Entity entity) {
    }

    public boolean canConnectRedstone() {
        return this.hasGate();
    }

    public int isPoweringTo(int l) {
        if (!this.broadcastRedstone) {
            return 0;
        }
        ForgeDirection o = ForgeDirection.values()[l].getOpposite();
        TileEntity tile = this.container.getTile(o);
        if (tile instanceof TileGenericPipe && Utils.checkPipesConnections(this.container, tile)) {
            return 0;
        }
        return 15;
    }

    public int isIndirectlyPoweringTo(int l) {
        return this.isPoweringTo(l);
    }

    public void randomDisplayTick(Random random) {
    }

    public boolean isWired() {
        for (IPipe.WireColor color : IPipe.WireColor.values()) {
            if (!this.isWired(color)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWired(IPipe.WireColor color) {
        return this.wireSet[color.ordinal()];
    }

    @Override
    public boolean hasInterface() {
        return this.hasGate();
    }

    public boolean hasGate() {
        return this.gate != null;
    }

    protected void updateNeighbors(boolean needSelf) {
        if (needSelf) {
            this.worldObj.func_72898_h(this.xCoord, this.yCoord, this.zCoord, BuildCraftTransport.genericPipeBlock.field_71990_ca);
        }
        this.worldObj.func_72898_h(this.xCoord, this.yCoord - 1, this.zCoord, BuildCraftTransport.genericPipeBlock.field_71990_ca);
        this.worldObj.func_72898_h(this.xCoord, this.yCoord + 1, this.zCoord, BuildCraftTransport.genericPipeBlock.field_71990_ca);
        this.worldObj.func_72898_h(this.xCoord - 1, this.yCoord, this.zCoord, BuildCraftTransport.genericPipeBlock.field_71990_ca);
        this.worldObj.func_72898_h(this.xCoord + 1, this.yCoord, this.zCoord, BuildCraftTransport.genericPipeBlock.field_71990_ca);
        this.worldObj.func_72898_h(this.xCoord, this.yCoord, this.zCoord - 1, BuildCraftTransport.genericPipeBlock.field_71990_ca);
        this.worldObj.func_72898_h(this.xCoord, this.yCoord, this.zCoord + 1, BuildCraftTransport.genericPipeBlock.field_71990_ca);
    }

    public void onBlockRemoval() {
        if (this.wireSet[IPipe.WireColor.Red.ordinal()]) {
            Utils.dropItems(this.worldObj, new ItemStack(BuildCraftTransport.redPipeWire), this.xCoord, this.yCoord, this.zCoord);
        }
        if (this.wireSet[IPipe.WireColor.Blue.ordinal()]) {
            Utils.dropItems(this.worldObj, new ItemStack(BuildCraftTransport.bluePipeWire), this.xCoord, this.yCoord, this.zCoord);
        }
        if (this.wireSet[IPipe.WireColor.Green.ordinal()]) {
            Utils.dropItems(this.worldObj, new ItemStack(BuildCraftTransport.greenPipeWire), this.xCoord, this.yCoord, this.zCoord);
        }
        if (this.wireSet[IPipe.WireColor.Yellow.ordinal()]) {
            Utils.dropItems(this.worldObj, new ItemStack(BuildCraftTransport.yellowPipeWire), this.xCoord, this.yCoord, this.zCoord);
        }
        if (this.hasGate()) {
            this.gate.dropGate(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.container.hasFacade(direction)) {
                this.container.dropFacade(direction);
            }
            if (!this.container.hasPlug(direction)) continue;
            this.container.removeAndDropPlug(direction);
        }
        if (this.broadcastRedstone) {
            this.updateNeighbors(false);
        }
    }

    public void setTrigger(int position, ITrigger trigger) {
        this.activatedTriggers[position] = trigger;
    }

    public ITrigger getTrigger(int position) {
        return this.activatedTriggers[position];
    }

    public void setTriggerParameter(int position, ITriggerParameter p) {
        this.triggerParameters[position] = p;
    }

    public ITriggerParameter getTriggerParameter(int position) {
        return this.triggerParameters[position];
    }

    public boolean isNearbyTriggerActive(ITrigger trigger, ITriggerParameter parameter) {
        if (trigger instanceof ITriggerPipe) {
            return ((ITriggerPipe)((Object)trigger)).isTriggerActive(this, parameter);
        }
        if (trigger != null) {
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.container.getTile(o);
                if (tile == null || tile instanceof TileGenericPipe || !trigger.isTriggerActive(o.getOpposite(), tile, parameter)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public LinkedList getActions() {
        LinkedList result = new LinkedList();
        if (this.hasGate()) {
            this.gate.addActions(result);
        }
        return result;
    }

    public IAction getAction(int position) {
        return this.activatedActions[position];
    }

    public void setAction(int position, IAction action) {
        this.activatedActions[position] = action;
    }

    public void resetGate() {
        this.gate = null;
        this.activatedTriggers = new ITrigger[this.activatedTriggers.length];
        this.triggerParameters = new ITriggerParameter[this.triggerParameters.length];
        this.activatedActions = new IAction[this.activatedActions.length];
        this.broadcastSignal = new boolean[]{false, false, false, false};
        if (this.broadcastRedstone) {
            this.updateNeighbors(true);
        }
        this.broadcastRedstone = false;
        this.container.scheduleRenderUpdate();
    }

    private void resolveActions() {
        if (!this.hasGate()) {
            return;
        }
        boolean oldBroadcastRedstone = this.broadcastRedstone;
        boolean[] oldBroadcastSignal = this.broadcastSignal;
        this.broadcastRedstone = false;
        this.broadcastSignal = new boolean[]{false, false, false, false};
        this.gate.startResolution();
        HashMap<Integer, Boolean> actions = new HashMap<Integer, Boolean>();
        HashMultiset actionCount = HashMultiset.create();
        for (int it = 0; it < 8; ++it) {
            ITrigger trigger = this.activatedTriggers[it];
            IAction action = this.activatedActions[it];
            ITriggerParameter parameter = this.triggerParameters[it];
            if (trigger == null || action == null) continue;
            actionCount.add((Object)action.getId());
            if (!actions.containsKey(action.getId())) {
                actions.put(action.getId(), this.isNearbyTriggerActive(trigger, parameter));
                continue;
            }
            if (this.gate.getConditional() == Gate.GateConditional.AND) {
                actions.put(action.getId(), (Boolean)actions.get(action.getId()) != false && this.isNearbyTriggerActive(trigger, parameter));
                continue;
            }
            actions.put(action.getId(), (Boolean)actions.get(action.getId()) != false || this.isNearbyTriggerActive(trigger, parameter));
        }
        for (Integer i : actions.keySet()) {
            if (!((Boolean)actions.get(i)).booleanValue() || this.gate.resolveAction(ActionManager.actions[i], actionCount.count((Object)i))) continue;
            if (ActionManager.actions[i] instanceof ActionRedstoneOutput) {
                this.broadcastRedstone = true;
                continue;
            }
            if (ActionManager.actions[i] instanceof ActionSignalOutput) {
                this.broadcastSignal[((ActionSignalOutput)ActionManager.actions[i.intValue()]).color.ordinal()] = true;
                continue;
            }
            for (int a = 0; a < this.container.tileBuffer.length; ++a) {
                if (!(this.container.tileBuffer[a].getTile() instanceof IActionReceptor)) continue;
                IActionReceptor recept = (IActionReceptor)this.container.tileBuffer[a].getTile();
                recept.actionActivated(ActionManager.actions[i]);
            }
        }
        this.actionsActivated(actions);
        if (oldBroadcastRedstone != this.broadcastRedstone) {
            this.container.scheduleRenderUpdate();
            this.updateNeighbors(true);
        }
        for (int i = 0; i < oldBroadcastSignal.length; ++i) {
            if (oldBroadcastSignal[i] == this.broadcastSignal[i]) continue;
            this.container.scheduleRenderUpdate();
            this.updateSignalState();
            break;
        }
    }

    protected void actionsActivated(HashMap actions) {
    }

    @Override
    public TileGenericPipe getContainer() {
        return this.container;
    }

    @Override
    public boolean isWireConnectedTo(TileEntity tile, IPipe.WireColor color) {
        if (!(tile instanceof TileGenericPipe)) {
            return false;
        }
        TileGenericPipe tilePipe = (TileGenericPipe)tile;
        if (!BlockGenericPipe.isFullyDefined(tilePipe.pipe)) {
            return false;
        }
        if (!tilePipe.pipe.wireSet[color.ordinal()]) {
            return false;
        }
        return tilePipe.pipe.transport instanceof PipeTransportStructure || this.transport instanceof PipeTransportStructure || Utils.checkPipesConnections(this.container, tile);
    }

    public void dropContents() {
        this.transport.dropContents();
    }

    public void onDropped(EntityItem item) {
    }

    public ForgeDirection getOpenOrientation() {
        int Connections_num = 0;
        ForgeDirection target_orientation = ForgeDirection.UNKNOWN;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!Utils.checkPipesConnections(this.container.getTile(o), this.container) || ++Connections_num != 1) continue;
            target_orientation = o;
        }
        if (Connections_num > 1 || Connections_num == 0) {
            return ForgeDirection.UNKNOWN;
        }
        return target_orientation.getOpposite();
    }

    @Override
    public boolean doDrop() {
        return this.logic.doDrop();
    }

    public boolean isGateActive() {
        for (boolean b : this.broadcastSignal) {
            if (!b) continue;
            return true;
        }
        return this.broadcastRedstone;
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void onChunkUnload() {
    }

    public static void fixTriggers() {
        if (fixedTriggers) {
            return;
        }
        for (int i = 0; i < ActionManager.triggers.length; ++i) {
            try {
                ITrigger t = ActionManager.triggers[i];
                ActionManager.triggers[i] = t = new FallbackWrapper(t);
                BuildCraftCore.bcLog.severe("Trigger " + t.getClass() + " using OLD API found, using a falling back wrapper!");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        fixedTriggers = true;
    }
}

