/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.inventory.ISelectiveInventory;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.IClientState;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicEmerald;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsEmerald
extends PipeItemsWood
implements ISpecialInventory,
IClientState {
    private SimpleInventory filters = new SimpleInventory(9, "items", 1);
    private int currentFilter = 0;

    protected PipeItemsEmerald(int itemID, PipeTransportItems transport) {
        super(transport, (PipeLogic)new PipeLogicEmerald(), itemID);
        this.standardIconIndex = 11;
        this.solidIconIndex = 12;
    }

    public PipeItemsEmerald(int itemID) {
        this(itemID, new PipeTransportItems());
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().field_77993_c < Block.field_71973_m.length && Block.field_71973_m[entityplayer.func_71045_bC().field_77993_c] instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(this.worldObj, x, y, z, entityplayer)) {
            return true;
        }
        if (!CoreProxy.proxy.isRenderWorld(this.container.field_70331_k)) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 52, this.worldObj, x, y, z);
        }
        return true;
    }

    @Override
    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory instanceof ISelectiveInventory) {
            ItemStack[] stacks = ((ISelectiveInventory)inventory).extractItem(new ItemStack[]{this.getCurrentFilter()}, false, doRemove, from, (int)this.getPowerProvider().getEnergyStored());
            if (doRemove) {
                for (ItemStack stack : stacks) {
                    if (stack == null) continue;
                    this.getPowerProvider().useEnergy(stack.field_77994_a, stack.field_77994_a, true);
                }
                this.incrementFilter();
            }
            return stacks;
        }
        if (inventory instanceof ISpecialInventory) {
            ItemStack[] stacks = ((ISpecialInventory)inventory).extractItem(false, from, (int)this.getPowerProvider().getEnergyStored());
            if (stacks != null) {
                for (ItemStack stack : stacks) {
                    if (stack == null) continue;
                    boolean matches = false;
                    for (int i = 0; i < this.filters.func_70302_i_(); ++i) {
                        ItemStack filter = this.filters.func_70301_a(i);
                        if (filter == null || !filter.func_77969_a(stack)) continue;
                        matches = true;
                        break;
                    }
                    if (matches) continue;
                    return null;
                }
                if (doRemove) {
                    for (ItemStack stack : stacks = ((ISpecialInventory)inventory).extractItem(true, from, (int)this.getPowerProvider().getEnergyStored())) {
                        if (stack == null) continue;
                        this.getPowerProvider().useEnergy(stack.field_77994_a, stack.field_77994_a, true);
                    }
                }
            }
            return stacks;
        }
        IInventory inv = Utils.getInventory(inventory);
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from);
        if (result != null) {
            return new ItemStack[]{result};
        }
        return null;
    }

    private void incrementFilter() {
        ++this.currentFilter;
        for (int count = 0; this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_()) == null && count < this.filters.func_70302_i_(); ++count) {
            ++this.currentFilter;
        }
    }

    private ItemStack getCurrentFilter() {
        ItemStack filter = this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_());
        if (filter == null) {
            this.incrementFilter();
        }
        return this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_());
    }

    @Override
    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int i : inventory.func_94128_d(from.ordinal())) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            ItemStack filter = this.getCurrentFilter();
            if (filter == null) {
                return null;
            }
            if (!filter.func_77969_a(stack) || !inventory.func_102008_b(i, stack, from.ordinal())) continue;
            if (doRemove) {
                this.incrementFilter();
                return inventory.func_70298_a(i, (int)this.getPowerProvider().useEnergy(1.0f, stack.field_77994_a, true));
            }
            return stack;
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
        this.currentFilter = nbt.func_74762_e("currentFilter");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
        nbt.func_74768_a("currentFilter", this.currentFilter);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        NBTBase.func_74731_a((NBTBase)nbt, (DataOutput)data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        NBTBase nbt = NBTBase.func_74739_b((DataInput)data);
        if (nbt instanceof NBTTagCompound) {
            this.readFromNBT((NBTTagCompound)nbt);
        }
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return new ItemStack[0];
    }

    public int func_70302_i_() {
        return this.filters.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.filters.func_70301_a(i);
    }

    public String func_70303_b() {
        return "Filters";
    }

    public int func_70297_j_() {
        return this.filters.func_70297_j_();
    }

    public ItemStack func_70304_b(int i) {
        return this.filters.func_70304_b(i);
    }

    public void func_70296_d() {
        this.filters.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.worldObj.func_72796_p(this.xCoord, this.yCoord, this.zCoord) == this.container;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this.filters.func_70298_a(i, j);
        if (CoreProxy.proxy.isSimulating(this.worldObj)) {
            this.worldObj.func_72845_h(this.xCoord, this.yCoord, this.zCoord);
        }
        return stack;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.filters.func_70299_a(i, itemstack);
        if (CoreProxy.proxy.isSimulating(this.worldObj)) {
            this.worldObj.func_72845_h(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }
}

