/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;

public class PipeLogicIron
extends PipeLogic {
    boolean lastPower = false;

    public void switchPower() {
        boolean currentPower = this.worldObj.func_72864_z(this.xCoord, this.yCoord, this.zCoord);
        if (currentPower != this.lastPower) {
            this.switchPosition();
            this.lastPower = currentPower;
        }
    }

    public void switchPosition() {
        int metadata;
        int nextMetadata = metadata = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        for (int l = 0; l < 6; ++l) {
            TileEntity tile;
            if (++nextMetadata > 5) {
                nextMetadata = 0;
            }
            if ((tile = this.container.getTile(ForgeDirection.values()[nextMetadata])) instanceof TileGenericPipe) {
                Pipe pipe = ((TileGenericPipe)tile).pipe;
                if (pipe.logic instanceof PipeLogicWood || pipe instanceof PipeStructureCobblestone) continue;
            }
            if (!(tile instanceof IPipeEntry) && !(tile instanceof IInventory) && !(tile instanceof ITankContainer) && !(tile instanceof TileGenericPipe)) continue;
            this.worldObj.func_72921_c(this.xCoord, this.yCoord, this.zCoord, nextMetadata, 0);
            this.container.scheduleRenderUpdate();
            return;
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.lastPower = this.worldObj.func_72864_z(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void onBlockPlaced() {
        super.onBlockPlaced();
        this.worldObj.func_72921_c(this.xCoord, this.yCoord, this.zCoord, 1, 0);
        this.switchPosition();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        Item equipped;
        super.blockActivated(entityplayer);
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.xCoord, this.yCoord, this.zCoord)) {
            this.switchPosition();
            this.worldObj.func_72845_h(this.xCoord, this.yCoord, this.zCoord);
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.switchPower();
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        return to.ordinal() == this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
    }
}

