/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.pipes.PipeLogicWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraftforge.common.ForgeDirection;

public class PipePowerWood
extends Pipe
implements IPowerReceptor {
    private IPowerProvider powerProvider;
    protected int standardIconIndex = 30;
    protected int solidIconIndex = 10;
    private int[] powerSources = new int[6];

    public PipePowerWood(int itemID) {
        super(new PipeTransportPower(), new PipeLogicWood(), itemID);
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(50, 2, 1000, 1, 1500);
        this.powerProvider.configurePowerPerdition(1, 10);
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.worldObj.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.field_72995_K) {
            return;
        }
        int sources = 0;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(o)) {
                this.powerSources[o.ordinal()] = 0;
                continue;
            }
            if (this.powerSources[o.ordinal()] > 0) {
                int n = o.ordinal();
                this.powerSources[n] = this.powerSources[n] - 1;
            }
            if (this.powerProvider.isPowerSource(o)) {
                this.powerSources[o.ordinal()] = 40;
            }
            if (this.powerSources[o.ordinal()] <= 0) continue;
            ++sources;
        }
        if (sources <= 0) {
            return;
        }
        float energyToRemove = this.powerProvider.getEnergyStored() > 40.0f ? this.powerProvider.getEnergyStored() / 40.0f + 4.0f : (this.powerProvider.getEnergyStored() > 10.0f ? this.powerProvider.getEnergyStored() / 10.0f : 1.0f);
        energyToRemove /= (float)sources;
        PipeTransportPower trans = (PipeTransportPower)this.transport;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            float energyUsable;
            float energySend;
            if (this.powerSources[o.ordinal()] <= 0 || !((energySend = (float)trans.receiveEnergy(o, energyUsable = this.powerProvider.useEnergy(1.0f, energyToRemove, false))) > 0.0f)) continue;
            this.powerProvider.useEnergy(1.0f, energySend, true);
        }
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

