/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.core.CoFHProps;
import cofh.util.CoreUtils;
import cofh.world.WorldHandler;
import cofh.world.generators.WorldGenMinableCluster;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="CoFHWorld", name="CoFH World", version="1.5.2.0")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class CoFHWorld {
    @Mod.Instance(value="CoFHWorld")
    public static CoFHWorld instance;
    public static Configuration config;
    public static boolean genFlatBedrock;
    public static boolean genReplaceVanilla;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(new File(CoFHProps.configDir, "/cofh/World.cfg"));
        Property curProp = config.get("world.feature", "ReplaceVanillaGeneration", false);
        curProp.comment = "This allows for vanilla ore generation to be REPLACED. Configure in the 'world.vanilla' section; vanilla defaults have been provided.";
        genReplaceVanilla = curProp.getBoolean(false);
        curProp = config.get("world.feature", "FlatBedrock", false);
        curProp.comment = "This will flatten the bedrock layer to a single block in height.";
        genFlatBedrock = curProp.getBoolean(false);
        this.loadWorldGeneration();
        GameRegistry.registerWorldGenerator((IWorldGenerator)WorldHandler.instance);
        MinecraftForge.ORE_GEN_BUS.register((Object)WorldHandler.instance);
        if (OreDictionary.getOres((String)"oreIron").isEmpty()) {
            OreDictionary.registerOre((String)"oreIron", (Block)Block.field_71949_H);
        }
        if (OreDictionary.getOres((String)"oreGold").isEmpty()) {
            OreDictionary.registerOre((String)"oreGold", (Block)Block.field_71941_G);
        }
        if (OreDictionary.getOres((String)"ingotIron").isEmpty()) {
            OreDictionary.registerOre((String)"ingotIron", (Item)Item.field_77703_o);
        }
        if (OreDictionary.getOres((String)"ingotGold").isEmpty()) {
            OreDictionary.registerOre((String)"ingotGold", (Item)Item.field_77717_p);
        }
        if (config.hasCategory("world.tweak")) {
            config.removeCategory(config.getCategory("world.tweak"));
        }
        if (config.hasKey("world.feature", "Vanilla.Augment")) {
            config.getCategory("world.feature").remove((Object)"Vanilla.Augment");
        }
        config.save();
    }

    @Mod.Init
    public void initialize(FMLInitializationEvent event) {
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
    }

    void loadWorldGeneration() {
        String category = "world.vanilla";
        ConfigCategory cat = config.getCategory(category);
        cat.setComment("This section controls generation specifically related to vanilla Minecraft ores. THESE VALUES ARE USED INSTEAD OF STANDARD GENERATION IF REPLACEMENT IS ENABLED.");
        this.addVanillaGen(new ItemStack(Block.field_71979_v), "dirt", 32, 20, 0, 128, WorldHandler.GenType.ORE_1, genReplaceVanilla);
        this.addVanillaGen(new ItemStack(Block.field_71940_F), "gravel", 32, 10, 0, 128, WorldHandler.GenType.ORE_1, genReplaceVanilla);
        this.addVanillaGen(new ItemStack(Block.field_71950_I), "coal", 16, 20, 0, 128, WorldHandler.GenType.ORE_1, genReplaceVanilla);
        this.addVanillaGen(new ItemStack(Block.field_71949_H), "iron", 8, 20, 0, 64, WorldHandler.GenType.ORE_1, genReplaceVanilla);
        this.addVanillaGen(new ItemStack(Block.field_71941_G), "gold", 8, 2, 0, 32, WorldHandler.GenType.ORE_1, genReplaceVanilla);
        this.addVanillaGen(new ItemStack(Block.field_72047_aN), "redstone", 7, 8, 0, 16, WorldHandler.GenType.ORE_1, genReplaceVanilla);
        this.addVanillaGen(new ItemStack(Block.field_72073_aw), "diamond", 7, 1, 0, 16, WorldHandler.GenType.ORE_1, genReplaceVanilla);
        this.addVanillaGen(new ItemStack(Block.field_71947_N), "lapis", 6, 1, 16, 16, WorldHandler.GenType.ORE_2, genReplaceVanilla);
        cat = config.getCategory("world.vanilla.lapis");
        cat.setComment("Generation settings for Lapis; Defaults: ClusterSize = 6, NumClusters = 1, MinY = 16, MaxY = 16. 'MinY' and 'MaxY' are both 16. THIS IS NOT A BUG - LAPIS GENERATES DIFFERENTLY.");
        config.save();
    }

    public void addVanillaGen(ItemStack stack, String genName, int clusterSize, int numClusters, int minY, int maxY, WorldHandler.GenType gen, boolean generate) {
        String category = "world.vanilla." + genName;
        ConfigCategory cat = config.getCategory(category);
        cat.setComment("Generation settings for " + CoreUtils.titleCase(genName) + "; Defaults: ClusterSize = " + clusterSize + ", NumClusters = " + numClusters + ", MinY = " + minY + ", MaxY = " + maxY);
        clusterSize = config.get(category, "ClusterSize", clusterSize).getInt();
        numClusters = config.get(category, "NumClusters", numClusters).getInt();
        minY = config.get(category, "MinY", minY).getInt();
        maxY = config.get(category, "MaxY", maxY).getInt();
        config.save();
        if (generate) {
            ArrayList resList = new ArrayList();
            WorldHandler.addSurfaceGenerator(new WorldGenMinableCluster(stack, clusterSize), minY, maxY, numClusters, gen.ordinal());
        }
    }

    static {
        genFlatBedrock = false;
        genReplaceVanilla = false;
    }
}

