/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.CoFHModContainer;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CoFHClassTransformer
implements IClassTransformer {
    public static String enchantClassName = "net.minecraft.enchantment.EnchantmentHelper";
    public static String enchantBuildName = "buildEnchantmentList";
    public static String ItemStackName = "Lnet/minecraft/item/ItemStack;";
    public static String RenderGlobalClassName = "net.minecraft.client.renderer.RenderGlobal";
    public static String RenderGlobalFunc = "onEntityCreate";
    public static String EntityName = "net/minecraft/entity/Entity";
    public static String RenderGlobalClassNameOb = "bfz";
    public static String RenderGlobalFuncOb = "a";
    public static String EntityNameOb = "mp";

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (enchantClassName.equals(name)) {
            CoFHModContainer.log.info("EnchantmentHelper class detected. Detecting buildEnchantmentList...");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            for (MethodNode mn : cn.methods) {
                if (!mn.name.equals(enchantBuildName) || !mn.desc.equals("(Ljava/util/Random;" + ItemStackName + "I)Ljava/util/List;")) continue;
                CoFHModContainer.log.info("buildEnchantmentList Function Detected, Calling injection point helper.");
                this.alterBuildEnchantmentList(mn);
            }
            ClassWriter cw = new ClassWriter(3);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        if (RenderGlobalClassName.equals(name) || RenderGlobalClassNameOb.equals(name)) {
            CoFHModContainer.log.info("RenderGlobal Class Detected");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            for (MethodNode mn : cn.methods) {
                if (mn.name.equals(RenderGlobalFunc) && mn.desc.equals("(L" + EntityName + ";)V")) {
                    CoFHModContainer.log.info("RenderGlobal Function Injection Detected");
                    this.alterRenderGlobal(mn);
                }
                if (!mn.name.equals(RenderGlobalFuncOb) || !mn.desc.equals("(L" + EntityNameOb + ";)V")) continue;
                CoFHModContainer.log.info("RenderGlobal(Obfuscated) Function Injection Detected");
                this.alterRenderGlobal(mn);
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return bytes;
    }

    private void alterRenderGlobal(MethodNode mn) {
        ListIterator iter = mn.instructions.iterator();
        int counter = 0;
        int defVariableIndex = 1;
        LocalVariableNode injectedVariable = this.getLocalVariableIndex(mn, "par1Entity", defVariableIndex);
        while (iter.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iter.next();
            if (node.getOpcode() != 177) continue;
            if (counter == 0) {
                CoFHModContainer.log.info("RenderGlobal Injection Point Detected " + (injectedVariable != mn.localVariables.get(defVariableIndex) ? "(Optifine Detected)" : "") + "(updateEntityCape(" + injectedVariable.desc + ")V)");
                mn.instructions.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, injectedVariable.index));
                mn.instructions.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, "cofh/CoFHHooks", "updateEntityCape", "(" + injectedVariable.desc + ")V"));
            }
            ++counter;
        }
    }

    private void alterBuildEnchantmentList(MethodNode mn) {
        ListIterator iter = mn.instructions.iterator();
        int counter = 0;
        int injectedVariable = 1;
        while (iter.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iter.next();
            if (node.getOpcode() != 182) continue;
            if (counter == 1) {
                CoFHModContainer.log.info("buildEnchantmentList Injection Point Detected.");
                mn.instructions.insertBefore(node, (AbstractInsnNode)new VarInsnNode(25, injectedVariable));
                mn.instructions.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, "cofh/CoFHHooks", "getItemEnchantability", "(" + ((LocalVariableNode)mn.localVariables.get((int)injectedVariable)).desc + ")I"));
                mn.instructions.remove(node);
                return;
            }
            ++counter;
        }
    }

    public LocalVariableNode getLocalVariableIndex(MethodNode mn, String OptifineName, int def) {
        for (Object a : mn.localVariables) {
            LocalVariableNode node = (LocalVariableNode)a;
            if (!node.name.equals(OptifineName)) continue;
            return node;
        }
        return (LocalVariableNode)mn.localVariables.get(def);
    }
}

