/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.api.core.RegistryAccess;
import cofh.command.CommandHandler;
import cofh.core.CoFHProps;
import cofh.core.Proxy;
import cofh.core.ProxyClient;
import cofh.skins.CapeHandler;
import cofh.skins.SkinHandler;
import cofh.util.ConfigHandler;
import cofh.util.liquid.BucketHandler;
import cofh.util.version.VersionInfo;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;

public class CoFHModContainer
extends DummyModContainer {
    @SidedProxy(clientSide="cofh.core.ProxyClient", serverSide="cofh.core.Proxy")
    public static Proxy proxy;
    public static MinecraftServer theServer;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final VersionInfo version;

    public CoFHModContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "CoFHCore";
        meta.name = "CoFH Core";
        meta.logoFile = "/mods/cofhcore/logo.png";
        meta.version = "1.5.2.0";
        meta.authorList = Arrays.asList("KingLemmingCoFH", "ZeldoKavira", "Cynycal");
        meta.description = "Core for CoFH team mods.";
        meta.url = "http://thermalexpansion.wikispaces.com/";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void serverStarting(FMLServerStartingEvent event) {
        CommandHandler.initCommands(event);
        theServer = event.getServer();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        version.checkForNewVersion();
        proxy = event.getSide() == Side.CLIENT ? new ProxyClient() : new Proxy();
        RegistryAccess.capeRegistry = new CapeHandler();
        RegistryAccess.skinRegistry = new SkinHandler();
        CapeHandler.registerDefaults();
        SkinHandler.registerDefaults();
        CoFHProps.configDir = event.getModConfigurationDirectory();
        CapeHandler.capeConf = new Configuration(new File(CoFHProps.configDir, "/cofh/Capes.cfg"));
        CapeHandler.capeConf.load();
        CapeHandler.loadCapes();
        SkinHandler.skinConf = new Configuration(new File(CoFHProps.configDir, "/cofh/Skins.cfg"));
        SkinHandler.skinConf.load();
        SkinHandler.loadSkins();
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/CoFHCore.cfg")));
        String category = "general";
        CoFHProps.enableUpdateNotice = config.get(category, "EnableUpdateNotifications", true);
        Property curProp = config.getProperty("tweak", "CapeOp", true);
        curProp.comment = "Allows ops to use /cofh cape set and /cofh cape set (user) if that is also allowed.";
        CapeHandler.allowPlayersUse = curProp.getBoolean(true);
        curProp = config.getProperty("tweak", "CapeRegular", true);
        curProp.comment = "Allows all players to use /cofh cape set.";
        CapeHandler.allowOpsUse = curProp.getBoolean(true);
        curProp = config.getProperty("tweak", "CapeOpOthers", false);
        curProp.comment = "Allows Ops to set the capes of others, if Ops are allowed to set capes.";
        CapeHandler.allowOpsOthers = curProp.getBoolean(false);
        curProp = config.getProperty("tweak", "SkinOp", true);
        curProp.comment = "Allows ops to use /cofh skin set and /cofh skin set (user) if that is also allowed.";
        SkinHandler.allowPlayersUse = curProp.getBoolean(true);
        curProp = config.getProperty("tweak", "SkinRegular", true);
        curProp.comment = "Allows all players to use /cofh skin set.";
        SkinHandler.allowOpsUse = curProp.getBoolean(true);
        curProp = config.getProperty("tweak", "SkinOpOthers", false);
        curProp.comment = "Allows Ops to set the skins of others, if Ops are allowed to set skins.";
        SkinHandler.allowOpsOthers = curProp.getBoolean(false);
        curProp = config.getProperty("general", "Tabs.Information", true);
        CoFHProps.enableInformationTabs = curProp.getBoolean(true);
        curProp = config.getProperty("general", "Tabs.Tutorial", true);
        CoFHProps.enableTutorialTabs = curProp.getBoolean(true);
        config.save();
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.instance);
    }

    @Subscribe
    public void initialize(FMLInitializationEvent event) {
    }

    @Subscribe
    public void modsLoaded(FMLPostInitializationEvent event) {
        proxy.registerRenderInformation();
        proxy.registerTickHandlers();
        this.cleanConfig();
        config.cleanUp(false);
    }

    public void cleanConfig() {
        config.removeEntry("world.feature", "Vanilla.Augment");
        config.removeEntry("world.feature", "FlatBedrock");
        String category = "world.tweak";
        config.removeEntry(category, "Augment.Coal.NumClusters");
        config.removeEntry(category, "Augment.Iron.NumClusters");
        config.removeEntry(category, "Augment.Gold.NumClusters");
        config.removeEntry(category, "Augment.Redstone.NumClusters");
        config.removeEntry(category, "Augment.Diamond.NumClusters");
        config.removeEntry(category, "Augment.Lapis.NumClusters");
        config.removeEntry(category, "Augment.Quartz.NumClusters");
        config.removeEntry(category, "Augment.Coal.ClusterSize");
        config.removeEntry(category, "Augment.Iron.ClusterSize");
        config.removeEntry(category, "Augment.Gold.ClusterSize");
        config.removeEntry(category, "Augment.Redstone.ClusterSize");
        config.removeEntry(category, "Augment.Diamond.ClusterSize");
        config.removeEntry(category, "Augment.Lapis.ClusterSize");
        config.removeEntry(category, "Augment.Quartz.ClusterSize");
    }

    static {
        log = Logger.getLogger("CoFHCore");
        config = new ConfigHandler("1.5.2.0");
        version = new VersionInfo("CoFH Core", "1.5.2.0", "https://dl.dropboxusercontent.com/u/57416963/Minecraft/Mods/CoFHCore/version.txt");
        log.setParent(FMLLog.getLogger());
    }
}

