/*
 * Decompiled with CFR 0.152.
 */
package cofh.core;

import cofh.asm.CoFHModContainer;
import cofh.core.CoFHProps;
import cofh.core.Proxy;
import cofh.entity.CoFHPlayerTracker;
import cofh.gui.element.TabInfo;
import cofh.gui.element.TabTutorial;
import cofh.network.TinyPacketHandler;
import cofh.render.IconRegistry;
import cofh.render.RenderBlockFluidClassic;
import cofh.skins.SkinPacketHandler;
import cofh.util.CoreUtils;
import cofh.util.version.TickHandlerVersion;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.ForgeSubscribe;

public class ProxyClient
extends Proxy {
    @Override
    public void registerRenderInformation() {
        TabInfo.enable = CoFHProps.enableInformationTabs;
        TabTutorial.enable = CoFHProps.enableTutorialTabs;
    }

    @Override
    public void registerTickHandlers() {
        GameRegistry.registerPlayerTracker((IPlayerTracker)CoFHPlayerTracker.instance);
        SkinPacketHandler.setPacketId(TinyPacketHandler.getAvailablePacketIdAndRegister(new SkinPacketHandler()));
        if (CoFHModContainer.version.isMinecraftOutdated()) {
            return;
        }
        if (!CoFHProps.enableUpdateNotice && !CoFHModContainer.version.isCriticalUpdate()) {
            return;
        }
        TickHandlerVersion.registerModVersionInfo(CoFHModContainer.version);
        if (!TickHandlerVersion.isInitialized()) {
            TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)TickHandlerVersion.instance, (Side)Side.CLIENT);
            TickHandlerVersion.initialize();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void registerIcons(TextureStitchEvent.Pre event) {
        if (event.map.field_94255_a != 0 && event.map.field_94255_a == 1) {
            IconRegistry.addIcon("IconAccessFriends", "cofhcore:icons/Icon_Access_Friends", (IconRegister)event.map);
            IconRegistry.addIcon("IconAccessPrivate", "cofhcore:icons/Icon_Access_Private", (IconRegister)event.map);
            IconRegistry.addIcon("IconAccessPublic", "cofhcore:icons/Icon_Access_Public", (IconRegister)event.map);
            IconRegistry.addIcon("IconAccept", "cofhcore:icons/Icon_Accept", (IconRegister)event.map);
            IconRegistry.addIcon("IconAcceptInactive", "cofhcore:icons/Icon_Accept_Inactive", (IconRegister)event.map);
            IconRegistry.addIcon("IconButton", "cofhcore:icons/Icon_Button", (IconRegister)event.map);
            IconRegistry.addIcon("IconButtonHighlight", "cofhcore:icons/Icon_Button_Highlight", (IconRegister)event.map);
            IconRegistry.addIcon("IconButtonInactive", "cofhcore:icons/Icon_Button_Inactive", (IconRegister)event.map);
            IconRegistry.addIcon("IconCancel", "cofhcore:icons/Icon_Cancel", (IconRegister)event.map);
            IconRegistry.addIcon("IconCancelInactive", "cofhcore:icons/Icon_Cancel_Inactive", (IconRegister)event.map);
            IconRegistry.addIcon("IconNope", "cofhcore:icons/Icon_Nope", (IconRegister)event.map);
            IconRegistry.addIcon("IconInformation", "cofhcore:icons/Icon_Information", (IconRegister)event.map);
            IconRegistry.addIcon("IconTutorial", "cofhcore:icons/Icon_Tutorial", (IconRegister)event.map);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void initializeIcons(TextureStitchEvent.Post event) {
        RenderBlockFluidClassic.initialize();
    }

    @Override
    public void addName(Object obj, String s) {
        LanguageRegistry.addName((Object)obj, (String)CoreUtils.localize(s));
    }

    @Override
    public boolean isOp(String playerName) {
        return true;
    }

    @Override
    public void obtainImage(String link) {
        Minecraft.func_71410_x().field_71446_o.func_78356_a(link, null);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public EntityPlayer findPlayer(String playerName) {
        for (Object a : FMLClientHandler.instance().getClient().field_71441_e.field_73010_i) {
            EntityPlayer player = (EntityPlayer)a;
            if (!player.field_71092_bJ.toLowerCase().equals(playerName.toLowerCase())) continue;
            return player;
        }
        return null;
    }

    @Override
    public List getPlayerList() {
        return new LinkedList();
    }
}

