/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui.element;

import cofh.gui.GuiRoot;
import cofh.gui.SessionVars;
import cofh.gui.element.ElementRoot;
import cofh.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public abstract class TabRoot
extends ElementRoot {
    public boolean open;
    public byte side = 1;
    public int backgroundColor = 0xFFFFFF;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    public int minWidth = 22;
    public int maxWidth = 124;
    public int currentWidth = this.minWidth;
    public int minHeight = 22;
    public int maxHeight = 22;
    public int currentHeight = this.minHeight;

    public TabRoot(GuiRoot gui) {
        super(gui, 0, 0);
    }

    public TabRoot(GuiRoot gui, int side) {
        super(gui, 0, 0);
    }

    @Override
    public void update() {
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += 8;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= 8;
        }
        if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        } else if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += 8;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= 8;
        }
        if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        } else if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        }
        if (this.open && this.currentWidth == this.maxWidth && this.currentHeight == this.maxHeight) {
            this.setFullyOpen();
        }
    }

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return this.side == 0 ? mouseX <= shiftX && mouseX >= shiftX - this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight : mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight;
    }

    protected void drawBackground() {
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        if (this.side == 0) {
            RenderUtils.bindTexture("/mods/cofhcore/textures/gui/elements/Tab_Left.png");
            this.gui.func_73729_b(this.posX - this.currentWidth, this.posY + 4, 0, 256 - this.currentHeight + 4, 4, this.currentHeight - 4);
            this.gui.func_73729_b(this.posX - this.currentWidth + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.gui.func_73729_b(this.posX - this.currentWidth, this.posY, 0, 0, 4, 4);
            this.gui.func_73729_b(this.posX - this.currentWidth + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        } else {
            RenderUtils.bindTexture("/mods/cofhcore/textures/gui/elements/Tab_Right.png");
            this.gui.func_73729_b(this.posX, this.posY, 0, 256 - this.currentHeight, 4, this.currentHeight);
            this.gui.func_73729_b(this.posX + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.gui.func_73729_b(this.posX, this.posY, 0, 0, 4, 4);
            this.gui.func_73729_b(this.posX + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawTabIcon(String iconName) {
        int offsetX = 2;
        if (this.side == 0) {
            offsetX = 4 - this.currentWidth;
        }
        this.gui.drawIcon(iconName, this.posX + offsetX, this.posY + 3, 1);
    }

    public boolean isFullyOpened() {
        return this.currentWidth >= this.maxWidth;
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            if (this.side == 0) {
                SessionVars.setOpenedLeftTab(null);
            } else {
                SessionVars.setOpenedRightTab(null);
            }
        } else {
            this.open = true;
            if (this.side == 0) {
                SessionVars.setOpenedLeftTab(this.getClass());
            } else {
                SessionVars.setOpenedRightTab(this.getClass());
            }
        }
    }
}

