/*
 * Decompiled with CFR 0.152.
 */
package cofh.network;

import cofh.asm.CoFHModContainer;
import cofh.network.IGeneralPacketHandler;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketTile;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketHandler
implements IPacketHandler {
    private static int packetIdCounter = 0;
    public static Map handlers = new HashMap();

    public static int getAvailablePacketId() {
        return ++packetIdCounter;
    }

    public static int getAvailablePacketIdAndRegister(IGeneralPacketHandler yourHandler) {
        handlers.put(++packetIdCounter, yourHandler);
        return packetIdCounter;
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            int id = data.read();
            if (handlers.containsKey(id)) {
                ((IGeneralPacketHandler)handlers.get(id)).handlePacket(id, data, (EntityPlayer)player);
            } else {
                PacketTile tilePacket = new PacketTile(id, player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null);
                tilePacket.readData(data);
                World world = ((EntityPlayer)player).field_70170_p;
                if (!tilePacket.targetExists(world)) {
                    return;
                }
                TileEntity tile = tilePacket.getTarget(world);
                if (!(tile instanceof ITilePacketHandler)) {
                    return;
                }
                ((ITilePacketHandler)tile).handleTilePacket(tilePacket);
            }
        }
        catch (Exception e) {
            CoFHModContainer.log.log(Level.SEVERE, "Packet payload failure! Please check your config files! Internal: PH");
        }
    }
}

