/*
 * Decompiled with CFR 0.152.
 */
package cofh.skins;

import cofh.api.core.ISimpleRegistry;
import cofh.asm.CoFHModContainer;
import cofh.network.PacketCoFH;
import cofh.skins.SkinPacketHandler;
import cofh.util.CoreUtils;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class SkinHandler
implements ISimpleRegistry {
    private static HashMap skinMap = new HashMap();
    public static boolean allowPlayersUse = true;
    public static boolean allowOpsUse = true;
    public static boolean allowOpsOthers = false;
    public static Configuration skinConf;

    public static boolean registerSkin(String playerName, String skinURL, boolean saveToFile) {
        if (playerName == null || skinURL == null) {
            return false;
        }
        playerName = playerName.toLowerCase();
        skinMap.put(playerName, skinURL);
        if (saveToFile) {
            skinConf.get("links", playerName, skinURL);
            skinConf.save();
        }
        return true;
    }

    public static boolean removeSkin(String playerName, boolean removeFromFile) {
        if (playerName == null) {
            return false;
        }
        playerName = playerName.toLowerCase();
        skinMap.remove(playerName);
        if (removeFromFile) {
            if (skinConf.hasCategory("links")) {
                skinConf.getCategory("links").remove((Object)playerName);
                skinConf.save();
            } else {
                SkinHandler.registerDefaults();
                return false;
            }
        }
        SkinHandler.registerDefaults();
        return true;
    }

    public static void loadSkins() {
        if (!skinConf.hasCategory("links")) {
            return;
        }
        for (String name : skinConf.getCategory("links").keySet()) {
            Property curSkin = skinConf.getCategory("links").get(name);
            SkinHandler.registerSkin(name, curSkin.getString(), false);
        }
        CoFHModContainer.log.info("Loaded " + skinConf.getCategory("links").keySet().size() + " skins.");
    }

    public static String getPlayerSkin(String playerName) {
        if (playerName == null || !skinMap.containsKey(playerName.toLowerCase())) {
            return null;
        }
        return (String)skinMap.get(playerName.toLowerCase());
    }

    public static void handlePlayerChange(EntityPlayer player) {
        if (CoFHModContainer.proxy.isServer()) {
            return;
        }
        String newSkin = SkinHandler.getPlayerSkin(player.field_71092_bJ);
        if (newSkin != null && newSkin != player.field_70120_cr) {
            player.field_70120_cr = newSkin;
            CoFHModContainer.proxy.obtainImage(player.field_70120_cr);
        } else if (newSkin == null) {
            player.field_70120_cr = "http://skins.minecraft.net/MinecraftSkins/" + StringUtils.func_76338_a((String)player.field_71092_bJ) + ".png";
            CoFHModContainer.proxy.obtainImage(player.field_70120_cr);
        }
    }

    public static void handlePlayerChange(String playerName) {
        if (playerName == null || playerName.equals("") || CoFHModContainer.proxy.isServer()) {
            return;
        }
        EntityPlayer player = CoFHModContainer.proxy.findPlayer(playerName);
        if (player != null) {
            SkinHandler.handlePlayerChange(player);
        }
    }

    public static boolean playerCanAccess(String playerName) {
        return allowPlayersUse ? true : allowOpsUse && CoreUtils.isOp(playerName);
    }

    public static boolean playerCanSetOthers(String playerName) {
        return allowOpsOthers && CoreUtils.isOp(playerName) && (allowPlayersUse || allowOpsUse);
    }

    public static void readJoinPacket(DataInputStream data) {
        try {
            skinMap = new HashMap();
            int count = data.readByte();
            for (int i = 0; i < count; ++i) {
                String name = data.readUTF();
                String link = data.readUTF();
                SkinHandler.registerSkin(name, link, false);
            }
        }
        catch (IOException e) {
            CoFHModContainer.log.log(Level.SEVERE, "Packet Payload Failure. ID: SJ");
        }
    }

    public static void readAddPacket(DataInputStream data) {
        try {
            String name = data.readUTF();
            String link = data.readUTF();
            SkinHandler.registerSkin(name, link, false);
            SkinHandler.handlePlayerChange(name);
        }
        catch (IOException e) {
            CoFHModContainer.log.log(Level.SEVERE, "Packet Payload Failure. ID: SA");
        }
    }

    public static void sendJoinPacket(EntityPlayer player) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        int sendCount = 0;
        try {
            int i;
            List players = CoFHModContainer.proxy.getPlayerList();
            if (players.size() <= 0) {
                return;
            }
            for (i = 0; i < players.size(); ++i) {
                if (SkinHandler.getPlayerSkin(((EntityPlayer)players.get((int)i)).field_71092_bJ) == null) continue;
                ++sendCount;
            }
            data.writeByte(SkinPacketHandler.Type.SKIN_JOIN.ordinal());
            data.writeByte(sendCount);
            for (i = 0; i < players.size(); ++i) {
                if (SkinHandler.getPlayerSkin(((EntityPlayer)players.get((int)i)).field_71092_bJ) == null) continue;
                data.writeUTF(((EntityPlayer)players.get((int)i)).field_71092_bJ);
                data.writeUTF(SkinHandler.getPlayerSkin(((EntityPlayer)players.get((int)i)).field_71092_bJ));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (sendCount == 0) {
            return;
        }
        PacketDispatcher.sendPacketToPlayer((Packet)PacketCoFH.getTinyPacket(SkinPacketHandler.myPacketID, bytes), (Player)((Player)player));
    }

    public static void sendAddPacket(String playerUsername) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            if (SkinHandler.getPlayerSkin(playerUsername) == null) {
                return;
            }
            data.writeByte(SkinPacketHandler.Type.SKIN_ADD.ordinal());
            data.writeUTF(playerUsername);
            data.writeUTF(SkinHandler.getPlayerSkin(playerUsername));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)PacketCoFH.getTinyPacket(SkinPacketHandler.myPacketID, bytes));
    }

    public static void readRemovePacket(DataInputStream data) {
        try {
            String name = data.readUTF();
            SkinHandler.removeSkin(name, false);
            SkinHandler.handlePlayerChange(name);
        }
        catch (IOException e) {
            CoFHModContainer.log.log(Level.SEVERE, "Packet Payload Failure. ID: SR");
        }
    }

    public static void sendRemovePacket(String playerUsername) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(SkinPacketHandler.Type.SKIN_REMOVE.ordinal());
            data.writeUTF(playerUsername);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToAllPlayers((Packet)PacketCoFH.getTinyPacket(SkinPacketHandler.myPacketID, bytes));
    }

    public static void registerDefaults() {
    }

    @Override
    public boolean register(String playerName, String skinURL) {
        return SkinHandler.registerSkin(playerName, skinURL, false);
    }
}

