/*
 * Decompiled with CFR 0.152.
 */
package cofh.util;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public final class BlockUtils {
    public static byte[] rotateType = new byte[4096];
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static final int[] SIDE_LEFT = new int[]{4, 5, 5, 4, 2, 3};
    public static final int[] SIDE_RIGHT = new int[]{5, 4, 4, 5, 3, 2};
    public static final int[] SIDE_OPPOSITE = new int[]{1, 0, 3, 2, 5, 4};
    public static final int[] SIDE_UP = new int[]{2, 3, 1, 1, 1, 1};
    public static final int[] SIDE_DOWN = new int[]{3, 2, 0, 0, 0, 0};

    public static int getCurrentMousedOverSide(World world, EntityPlayer player) {
        double distance = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3 posVec = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        posVec.field_72448_b += (double)player.func_70047_e();
        lookVec = posVec.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        MovingObjectPosition mouseOver = player.field_70170_p.func_72933_a(posVec, lookVec);
        if (mouseOver != null) {
            return mouseOver.field_72310_e;
        }
        return 0;
    }

    public static TileEntity getTileEntityAtOffset(World world, int x, int y, int z, ForgeDirection dir) {
        return world.func_72796_p(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
    }

    public static TileEntity getTileEntityAtOffset(TileEntity startTile, ForgeDirection dir) {
        return BlockUtils.getTileEntityAtOffset(startTile.field_70331_k, startTile.field_70329_l, startTile.field_70330_m, startTile.field_70327_n, dir);
    }

    public static int[] getAdjacentCoordinatesForSide(int x, int y, int z, int side) {
        return new int[]{x + SIDE_COORD_MOD[side][0], y + SIDE_COORD_MOD[side][1], z + SIDE_COORD_MOD[side][2]};
    }

    public static final int getLeftSide(int side) {
        return SIDE_LEFT[side];
    }

    public static final int getRightSide(int side) {
        return SIDE_RIGHT[side];
    }

    public static final int getOppositeSide(int side) {
        return SIDE_OPPOSITE[side];
    }

    public static final int getUpSide(int side) {
        return SIDE_UP[side];
    }

    public static final int getDownSide(int side) {
        return SIDE_DOWN[side];
    }

    public static boolean canRotate(int blockId) {
        return rotateType[blockId] != 0;
    }

    public static int rotateVanillaBlock(World world, int block, int meta, int x, int y, int z) {
        switch (rotateType[block]) {
            case 1: {
                return SIDE_LEFT[meta];
            }
            case 2: {
                if (meta < 6) {
                    return ++meta % 6;
                }
                return meta;
            }
            case 3: {
                if (meta < 2) {
                    return ++meta % 2;
                }
                return meta;
            }
            case 4: {
                return ++meta % 4;
            }
            case 5: {
                return ++meta % 8;
            }
            case 6: {
                int upper = meta & 0xC;
                int lower = meta & 3;
                return upper + ++lower % 4;
            }
            case 7: {
                return (meta + 4) % 12;
            }
            case 8: {
                return (meta + 8) % 16;
            }
            case 9: {
                for (int i = 2; i < 6; ++i) {
                    int[] coords = new int[3];
                    coords = BlockUtils.getAdjacentCoordinatesForSide(x, y, z, i);
                    if (world.func_72798_a(coords[0], coords[1], coords[2]) != Block.field_72077_au.field_71990_ca) continue;
                    world.func_72921_c(coords[0], coords[1], coords[2], SIDE_OPPOSITE[meta], 1);
                    return SIDE_OPPOSITE[meta];
                }
                return SIDE_LEFT[meta];
            }
            case 10: {
                int shift = 0;
                if (meta > 7) {
                    meta -= 8;
                    shift = 8;
                }
                if (meta == 5) {
                    return 6 + shift;
                }
                if (meta == 6) {
                    return 5 + shift;
                }
                if (meta == 7) {
                    return 0 + shift;
                }
                if (meta == 0) {
                    return 7 + shift;
                }
                return meta + shift;
            }
            case 11: {
                return ++meta % 16;
            }
        }
        return meta;
    }

    public static int rotateVanillaBlockAlt(World world, int block, int meta, int x, int y, int z) {
        switch (rotateType[block]) {
            case 1: {
                return SIDE_RIGHT[meta];
            }
            case 2: {
                if (meta < 6) {
                    return (meta + 5) % 6;
                }
                return meta;
            }
            case 3: {
                if (meta < 2) {
                    return ++meta % 2;
                }
                return meta;
            }
            case 4: {
                return (meta + 3) % 4;
            }
            case 5: {
                return (meta + 7) % 8;
            }
            case 6: {
                int upper = meta & 0xC;
                int lower = meta & 3;
                return upper + (lower + 3) % 4;
            }
            case 7: {
                return (meta + 8) % 12;
            }
            case 8: {
                return (meta + 8) % 16;
            }
            case 9: {
                for (int i = 2; i < 6; ++i) {
                    int[] coords = new int[3];
                    coords = BlockUtils.getAdjacentCoordinatesForSide(x, y, z, i);
                    if (world.func_72798_a(coords[0], coords[1], coords[2]) != Block.field_72077_au.field_71990_ca) continue;
                    world.func_72921_c(coords[0], coords[1], coords[2], SIDE_OPPOSITE[meta], 1);
                    return SIDE_OPPOSITE[meta];
                }
                return SIDE_RIGHT[meta];
            }
            case 10: {
                int shift = 0;
                if (meta > 7) {
                    meta -= 8;
                    shift = 8;
                }
                if (meta == 5) {
                    return 6 + shift;
                }
                if (meta == 6) {
                    return 5 + shift;
                }
                if (meta == 7) {
                    return 0 + shift;
                }
                if (meta == 0) {
                    return 7 + shift;
                }
            }
            case 11: {
                return ++meta % 16;
            }
        }
        return meta;
    }

    public static boolean isBlock(int blockID, int blockMeta) {
        return Block.field_71973_m.length >= blockID && Block.field_71973_m[blockID] != null;
    }

    static {
        BlockUtils.rotateType[Block.field_71951_J.field_71990_ca] = 7;
        BlockUtils.rotateType[Block.field_71958_P.field_71990_ca] = 2;
        BlockUtils.rotateType[Block.field_71954_T.field_71990_ca] = 3;
        BlockUtils.rotateType[Block.field_71953_U.field_71990_ca] = 3;
        BlockUtils.rotateType[Block.field_71956_V.field_71990_ca] = 2;
        BlockUtils.rotateType[Block.field_71963_Z.field_71990_ca] = 2;
        BlockUtils.rotateType[Block.field_72079_ak.field_71990_ca] = 8;
        BlockUtils.rotateType[Block.field_72063_at.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_72077_au.field_71990_ca] = 9;
        BlockUtils.rotateType[Block.field_72051_aB.field_71990_ca] = 1;
        BlockUtils.rotateType[Block.field_72052_aC.field_71990_ca] = 1;
        BlockUtils.rotateType[Block.field_72053_aD.field_71990_ca] = 11;
        BlockUtils.rotateType[Block.field_72056_aG.field_71990_ca] = 3;
        BlockUtils.rotateType[Block.field_72057_aH.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_72043_aJ.field_71990_ca] = 10;
        BlockUtils.rotateType[Block.field_72061_ba.field_71990_ca] = 4;
        BlockUtils.rotateType[Block.field_72008_bf.field_71990_ca] = 4;
        BlockUtils.rotateType[Block.field_72010_bh.field_71990_ca] = 6;
        BlockUtils.rotateType[Block.field_72011_bi.field_71990_ca] = 6;
        BlockUtils.rotateType[Block.field_71992_bw.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_71995_bx.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_72100_bC.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_72092_bO.field_71990_ca] = 8;
        BlockUtils.rotateType[Block.field_72088_bQ.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_72066_bS.field_71990_ca] = 1;
        BlockUtils.rotateType[Block.field_72074_bW.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_72072_bX.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_72070_bY.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_94338_cu.field_71990_ca] = 5;
        BlockUtils.rotateType[Block.field_94340_cs.field_71990_ca] = 2;
        BlockUtils.rotateType[Block.field_94337_cv.field_71990_ca] = 3;
        BlockUtils.rotateType[Block.field_96469_cy.field_71990_ca] = 2;
    }

    public static class RotationType {
        public static final int FOUR_WAY = 1;
        public static final int SIX_WAY = 2;
        public static final int RAIL = 3;
        public static final int PUMPKIN = 4;
        public static final int STAIRS = 5;
        public static final int REDSTONE = 6;
        public static final int LOG = 7;
        public static final int SLAB = 8;
        public static final int CHEST = 9;
        public static final int LEVER = 10;
        public static final int SIGN = 11;
    }
}

