/*
 * Decompiled with CFR 0.152.
 */
package cofh.util;

import cofh.asm.CoFHModContainer;
import cofh.util.Localization;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class CoreUtils {
    public static String localize(String key) {
        return Localization.get(key);
    }

    public static void addName(Object obj, String name) {
        CoFHModContainer.proxy.addName(obj, name);
    }

    public static int getSplitStringHeight(FontRenderer fontRenderer, String string, int width) {
        List stringRows = fontRenderer.func_78271_c(string, width);
        return stringRows.size() * fontRenderer.field_78288_b;
    }

    public static String camelCase(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String titleCase(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static boolean isClientWorld(World world) {
        return world.field_72995_K;
    }

    public static boolean isServerWorld(World world) {
        return !world.field_72995_K;
    }

    public static boolean isFalsePlayer(EntityPlayer player) {
        return !(player instanceof EntityPlayerMP);
    }

    public static boolean isOp(EntityPlayer player) {
        return CoFHModContainer.proxy.isOp(player.field_71092_bJ);
    }

    public static boolean isOp(String playerName) {
        return CoFHModContainer.proxy.isOp(playerName);
    }

    public static ItemStack addToInventorySlot(IInventory theInventory, int theSlot, ItemStack theStack) {
        ItemStack aStack = theInventory.func_70301_a(theSlot);
        if (aStack == null) {
            aStack = theStack.func_77946_l();
            theInventory.func_70299_a(theSlot, aStack);
            return null;
        }
        if (aStack.func_77969_a(theStack) && ItemStack.func_77970_a((ItemStack)aStack, (ItemStack)theStack)) {
            if (theStack.field_77994_a + aStack.field_77994_a > aStack.func_77976_d()) {
                int stackDiff = aStack.func_77976_d() - aStack.field_77994_a;
                aStack.field_77994_a = aStack.func_77976_d();
                theStack.field_77994_a -= stackDiff;
                theInventory.func_70299_a(theSlot, aStack);
                return theStack;
            }
            aStack.field_77994_a += theStack.field_77994_a;
            theInventory.func_70299_a(theSlot, aStack);
            return null;
        }
        return theStack;
    }

    public static int findStackInInv(ItemStack theStack, IInventory theInventory) {
        for (int i = 0; i < theInventory.func_70302_i_(); ++i) {
            if (theInventory.func_70301_a(i) == null || theInventory.func_70301_a((int)i).field_77993_c != theStack.field_77993_c || theInventory.func_70301_a(i).func_77960_j() != theStack.func_77960_j()) continue;
            return i;
        }
        return -1;
    }

    public static void dropItemIntoWorld(ItemStack theItem, World theWorld, double x, double y, double z) {
        if (theItem != null) {
            float x2 = theWorld.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float y2 = theWorld.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float z2 = theWorld.field_73012_v.nextFloat() * 0.8f + 0.1f;
            int size = theItem.field_77994_a;
            theItem.field_77994_a -= size;
            EntityItem entity = new EntityItem(theWorld, x + (double)x2, y + (double)y2, z + (double)z2, new ItemStack(theItem.field_77993_c, size, theItem.func_77960_j()));
            if (theItem.func_77942_o()) {
                entity.func_92059_d().func_77982_d((NBTTagCompound)theItem.func_77978_p().func_74737_b());
            }
            entity.field_70159_w = (float)theWorld.field_73012_v.nextGaussian() * 0.05f;
            entity.field_70181_x = (float)theWorld.field_73012_v.nextGaussian() * 0.05f + 0.2f;
            entity.field_70179_y = (float)theWorld.field_73012_v.nextGaussian() * 0.05f;
            theWorld.func_72838_d((Entity)entity);
        }
    }

    public static int getMaxStackForId(int itemID) {
        return Item.field_77698_e[itemID] == null ? 0 : Item.field_77698_e[itemID].func_77639_j();
    }

    public static void doFakeExplosion(World world, double x, double y, double z, boolean playSound) {
        world.func_72869_a("largeexplode", x, y + 1.0, z, 0.0, 0.0, 0.0);
        if (playSound) {
            world.func_72980_b(x, y, z, "random.explode", 1.0f, 1.0f, true);
        }
    }

    public static boolean teleportTo(EntityLiving theEntity, double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent(theEntity, x, y, z, 0);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double x2 = theEntity.field_70165_t;
        double y2 = theEntity.field_70163_u;
        double z2 = theEntity.field_70161_v;
        theEntity.field_70165_t = event.targetX;
        theEntity.field_70163_u = event.targetY;
        theEntity.field_70161_v = event.targetZ;
        theEntity.func_70634_a(event.targetX, event.targetY, event.targetZ);
        theEntity.field_70170_p.func_72908_a(x2, y2, z2, "mob.endermen.portal", 1.0f, 1.0f);
        theEntity.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }
}

