/*
 * Decompiled with CFR 0.152.
 */
package cofh.util.liquid;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class BucketHandler {
    public static BucketHandler instance = new BucketHandler();
    private static BiMap bucketMap = HashBiMap.create();

    @ForgeSubscribe
    public void onBucketFill(FillBucketEvent event) {
        if (!event.current.func_77973_b().equals(Item.field_77788_aw)) {
            return;
        }
        ItemStack theBucket = BucketHandler.fillBucket(event.world, event.target);
        if (theBucket == null) {
            return;
        }
        event.result = theBucket;
        event.setResult(Event.Result.ALLOW);
    }

    public static ItemStack fillBucket(World world, MovingObjectPosition pos) {
        int bId = world.func_72798_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        int bMeta = world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        if (!bucketMap.containsKey(Arrays.asList(bId, bMeta))) {
            return null;
        }
        world.func_94575_c(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, 0);
        List itemInfo = (List)bucketMap.get(Arrays.asList(bId, bMeta));
        return new ItemStack(((Integer)itemInfo.get(0)).intValue(), 1, ((Integer)itemInfo.get(1)).intValue());
    }

    public static boolean emptyBucket(World world, int x, int y, int z, ItemStack theBucket) {
        if (!bucketMap.inverse().containsKey(Arrays.asList(theBucket.field_77993_c, theBucket.func_77960_j()))) {
            return false;
        }
        List blockInfo = (List)bucketMap.inverse().get(Arrays.asList(theBucket.field_77993_c, theBucket.func_77960_j()));
        world.func_72832_d(x, y, z, ((Integer)blockInfo.get(0)).intValue(), ((Integer)blockInfo.get(1)).intValue(), 3);
        return true;
    }

    public static boolean registerBucket(int blockId, int blockMeta, ItemStack theBucket) {
        if (blockId <= 0 || blockMeta < 0 || theBucket == null || bucketMap.containsKey(Arrays.asList(blockId, blockMeta)) || bucketMap.inverse().containsKey(Arrays.asList(theBucket.field_77993_c, theBucket.func_77960_j()))) {
            return false;
        }
        bucketMap.put(Arrays.asList(blockId, blockMeta), Arrays.asList(theBucket.field_77993_c, theBucket.func_77960_j()));
        return true;
    }
}

