/*
 * Decompiled with CFR 0.152.
 */
package cofh.util.version;

import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VersionInfo {
    public static final String MC_VERSION = "1.5.1";
    boolean criticalUpdate;
    boolean newVersion;
    boolean newMinecraftVersion;
    boolean versionCheckComplete;
    String latestModVersion;
    String latestMCVersion = "1.5.1";
    String description = "";
    String modName;
    String modVersion;
    String releaseURL;
    Logger modLogger = FMLLog.getLogger();

    public static boolean beforeTargetVersion(String version, String target) {
        try {
            String[] versionTokens = version.trim().split("\\.");
            String[] targetTokens = target.trim().split("\\.");
            for (int i = 0; i < versionTokens.length; ++i) {
                int t;
                if (versionTokens[i].startsWith("a")) {
                    return false;
                }
                if (versionTokens[i].startsWith("b")) {
                    if (targetTokens[i].startsWith("b")) {
                        versionTokens[i] = versionTokens[i].substring(1);
                        targetTokens[i] = targetTokens[i].substring(1);
                    } else {
                        return true;
                    }
                }
                if (targetTokens[i].startsWith("a") || targetTokens[i].startsWith("b")) {
                    return false;
                }
                int v = Integer.valueOf(versionTokens[i]);
                if (v < (t = Integer.valueOf(targetTokens[i]).intValue())) {
                    return true;
                }
                if (v <= t) continue;
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean afterTargetVersion(String version, String target) {
        return VersionInfo.beforeTargetVersion(target, version);
    }

    public VersionInfo(String name, String version, String url) {
        this.modName = name;
        this.modVersion = this.latestModVersion = version;
        this.releaseURL = url;
    }

    public VersionInfo(String name, String version, String url, Logger logger) {
        this.modName = name;
        this.modVersion = this.latestModVersion = version;
        this.releaseURL = url;
        this.modLogger = logger;
    }

    public void checkForNewVersion() {
        VersionCheckThread versionCheckThread = new VersionCheckThread();
        versionCheckThread.start();
    }

    public String getCurrentVersion() {
        return this.modVersion;
    }

    public String getLatestVersion() {
        return this.latestModVersion;
    }

    public String getLatestMCVersion() {
        return this.latestMCVersion;
    }

    public String getVersionDescription() {
        return this.description;
    }

    public boolean isCriticalUpdate() {
        return this.criticalUpdate;
    }

    public boolean isNewVersionAvailable() {
        return this.newVersion;
    }

    public boolean isMinecraftOutdated() {
        return this.newMinecraftVersion;
    }

    public boolean isVersionCheckComplete() {
        return this.versionCheckComplete;
    }

    private class VersionCheckThread
    extends Thread {
        private VersionCheckThread() {
        }

        @Override
        public void run() {
            try {
                URL versionFile = new URL(VersionInfo.this.releaseURL);
                BufferedReader reader = new BufferedReader(new InputStreamReader(versionFile.openStream()));
                VersionInfo.this.latestModVersion = reader.readLine();
                VersionInfo.this.description = reader.readLine();
                VersionInfo.this.criticalUpdate = Boolean.parseBoolean(reader.readLine());
                VersionInfo.this.latestMCVersion = reader.readLine();
                reader.close();
                if (VersionInfo.beforeTargetVersion(VersionInfo.this.modVersion, VersionInfo.this.latestModVersion)) {
                    VersionInfo.this.modLogger.log(Level.INFO, "An updated version of " + VersionInfo.this.modName + " is available: " + VersionInfo.this.latestModVersion + ".");
                    VersionInfo.this.newVersion = true;
                    if (VersionInfo.this.criticalUpdate) {
                        VersionInfo.this.modLogger.log(Level.INFO, "This update has been marked as CRITICAL and will ignore notification suppression.");
                    }
                    if (VersionInfo.beforeTargetVersion(VersionInfo.MC_VERSION, VersionInfo.this.latestMCVersion)) {
                        VersionInfo.this.newMinecraftVersion = true;
                        VersionInfo.this.modLogger.log(Level.INFO, "This update is for Minecraft " + VersionInfo.this.latestMCVersion + ".");
                    }
                }
            }
            catch (Exception e) {
                VersionInfo.this.modLogger.log(Level.WARNING, "Version Check Failed: " + e.getMessage());
            }
            VersionInfo.this.versionCheckComplete = true;
        }
    }
}

