/*
 * Decompiled with CFR 0.152.
 */
package cofh.world;

import cofh.CoFHWorld;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomItem;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.OreGenEvent;

public class WorldHandler
implements IWorldGenerator {
    private static List generatorListNether = new ArrayList();
    private static List generatorListSurface = new ArrayList();
    private static List generatorListEnd = new ArrayList();
    private static HashSet vanillaGenEvents = new HashSet();
    public static WorldHandler instance;

    @ForgeSubscribe
    public void handleGenEvent(OreGenEvent.GenerateMinable event) {
        if (!CoFHWorld.genReplaceVanilla) {
            return;
        }
        if (vanillaGenEvents.contains(event.type)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.replaceBlocks(world, random, chunkX, chunkZ);
        this.generateWorld(world, random, chunkX, chunkZ, world.field_73011_w.field_76574_g);
    }

    protected void genStandardOre1(World world, GeneratorEntry entry, Random random, int blockX, int blockZ) {
        for (int i = 0; i < entry.count; ++i) {
            int x = blockX + random.nextInt(16);
            int y = entry.minY + random.nextInt(entry.maxY - entry.minY);
            int z = blockZ + random.nextInt(16);
            entry.worldGen.func_76484_a(world, random, x, y, z);
        }
    }

    protected void genStandardOre2(World world, GeneratorEntry entry, Random random, int blockX, int blockZ) {
        for (int i = 0; i < entry.count; ++i) {
            int x = blockX + random.nextInt(16);
            int y = random.nextInt(entry.maxY) + random.nextInt(entry.maxY) + entry.minY - entry.maxY;
            int z = blockZ + random.nextInt(16);
            entry.worldGen.func_76484_a(world, random, x, y, z);
        }
    }

    public static void addNetherGenerator(WorldGenerator generator, int minY, int maxY, int count, int type) {
        generatorListNether.add(new GeneratorEntry(generator, minY, maxY, count, type));
    }

    public static void addSurfaceGenerator(WorldGenerator generator, int minY, int maxY, int count, int type) {
        generatorListSurface.add(new GeneratorEntry(generator, minY, maxY, count, type));
    }

    public static void addEndGenerator(WorldGenerator generator, int minY, int maxY, int count, int type) {
        generatorListEnd.add(new GeneratorEntry(generator, minY, maxY, count, type));
    }

    public static void prependNetherGenerator(WorldGenerator generator, int minY, int maxY, int count, int type) {
        generatorListNether.add(0, new GeneratorEntry(generator, minY, maxY, count, type));
    }

    public static void prependSurfaceGenerator(WorldGenerator generator, int minY, int maxY, int count, int type) {
        generatorListSurface.add(0, new GeneratorEntry(generator, minY, maxY, count, type));
    }

    public static void prependEndGenerator(WorldGenerator generator, int minY, int maxY, int count, int type) {
        generatorListEnd.add(0, new GeneratorEntry(generator, minY, maxY, count, type));
    }

    private void generateWorld(World world, Random random, int chunkX, int chunkZ, int dimId) {
        List theList;
        switch (dimId) {
            case -1: {
                theList = generatorListNether;
                break;
            }
            case 0: {
                theList = generatorListSurface;
                break;
            }
            case 1: {
                theList = generatorListEnd;
                break;
            }
            default: {
                theList = generatorListSurface;
            }
        }
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        for (GeneratorEntry entry : theList) {
            if (entry.type == GenType.ORE_1.ordinal()) {
                this.genStandardOre1(world, entry, random, blockX, blockZ);
                continue;
            }
            if (entry.type != GenType.ORE_2.ordinal()) continue;
            this.genStandardOre2(world, entry, random, blockX, blockZ);
        }
    }

    private void replaceBlocks(World world, Random random, int chunkX, int chunkZ) {
        if (CoFHWorld.genFlatBedrock) {
            this.replaceBedrock(world, random, chunkX, chunkZ);
        }
    }

    private void replaceBedrock(World world, Random random, int chunkX, int chunkZ) {
        boolean isNether = world.func_72807_a((int)chunkX, (int)chunkZ).field_76791_y.toLowerCase().equals("hell");
        if (isNether) {
            for (int blockX = 0; blockX < 16; ++blockX) {
                for (int blockZ = 0; blockZ < 16; ++blockZ) {
                    int blockY;
                    for (blockY = 126; blockY > 121; --blockY) {
                        if (world.func_72798_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Block.field_71986_z.field_71990_ca) continue;
                        world.func_72832_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, Block.field_72012_bb.field_71990_ca, 0, 2);
                    }
                    for (blockY = 5; blockY > 0; --blockY) {
                        if (world.func_72798_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Block.field_71986_z.field_71990_ca) continue;
                        world.func_72832_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, Block.field_72012_bb.field_71990_ca, 0, 2);
                    }
                }
            }
        } else {
            for (int blockX = 0; blockX < 16; ++blockX) {
                for (int blockZ = 0; blockZ < 16; ++blockZ) {
                    for (int blockY = 5; blockY > 0; --blockY) {
                        if (world.func_72798_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Block.field_71986_z.field_71990_ca) continue;
                        world.func_72832_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, Block.field_71981_t.field_71990_ca, 0, 2);
                    }
                }
            }
        }
    }

    static {
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.COAL);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.DIAMOND);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.DIRT);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.GOLD);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.GRAVEL);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.IRON);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.LAPIS);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.REDSTONE);
        instance = new WorldHandler();
    }

    public static enum GenType {
        ORE_1,
        ORE_2;

    }

    public static class GeneratorEntry {
        public final WorldGenerator worldGen;
        public final int minY;
        public final int maxY;
        public final int count;
        public final int type;

        public GeneratorEntry(WorldGenerator worldGen, int minY, int maxY, int count, int type) {
            this.worldGen = worldGen;
            this.minY = minY;
            this.maxY = maxY;
            this.count = count;
            this.type = type;
        }
    }

    public static class ResourceEntry
    extends WeightedRandomItem {
        public final int blockId;
        public final int metadata;

        public ResourceEntry(ItemStack ore, int weight) {
            super(weight);
            this.blockId = ore.field_77993_c;
            this.metadata = ore.func_77960_j();
        }
    }
}

