/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion;

import buildcraft.api.gates.ActionManager;
import cofh.core.CoFHProps;
import cofh.gui.GuiHandler;
import cofh.util.ConfigHandler;
import cofh.util.Localization;
import cofh.util.version.VersionInfo;
import cofh.world.WorldHandler;
import cofh.world.generators.WorldGenMinableCluster;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.MinecraftForge;
import thermalexpansion.api.ThermalExpansionInfo;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileRockGen;
import thermalexpansion.block.simple.BlockOre;
import thermalexpansion.block.tesseract.TesseractRegistry;
import thermalexpansion.core.Proxy;
import thermalexpansion.core.TEProps;
import thermalexpansion.entity.TEPlayerTracker;
import thermalexpansion.gui.CreativeTabTE;
import thermalexpansion.item.TEItems;
import thermalexpansion.liquid.TELiquids;
import thermalexpansion.plugins.PluginProxy;
import thermalexpansion.plugins.TEPlugins;
import thermalexpansion.plugins.buildcraft.triggers.TriggerProviderEnergy;
import thermalexpansion.plugins.buildcraft.triggers.TriggerProviderTesseract;
import thermalexpansion.plugins.buildcraft.triggers.TriggerRegistry;
import thermalexpansion.util.crafting.CrucibleManager;
import thermalexpansion.util.crafting.FurnaceManager;
import thermalexpansion.util.crafting.PulverizerManager;
import thermalexpansion.util.crafting.SawmillManager;
import thermalexpansion.util.crafting.SmelterManager;
import thermalexpansion.util.crafting.TransposerManager;
import thermalexpansion.util.energy.PowerProviderTesseract;

@Mod(name="Thermal Expansion", version="2.4.1.0", useMetadata=false, modid="ThermalExpansion", dependencies="required-after:Forge@[7.1.2.500,);required-after:CoFHCore@[1.5.1.5,);before:IC2;before:Metallurgy")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class ThermalExpansion {
    @SidedProxy(clientSide="thermalexpansion.core.ProxyClient", serverSide="thermalexpansion.core.Proxy")
    public static Proxy proxy;
    @SidedProxy(clientSide="thermalexpansion.plugins.PluginProxyClient", serverSide="thermalexpansion.plugins.PluginProxy")
    public static PluginProxy pluginProxy;
    @Mod.Instance(value="ThermalExpansion")
    public static ThermalExpansion instance;
    public static final boolean DEBUG = false;
    public static final Logger log;
    public static final ConfigHandler config;
    public static final GuiHandler guiHandler;
    public static final VersionInfo version;
    public static final CreativeTabs tab;
    public static ItemStack schematic;
    public static final Material clothFireproof;
    public static final Material woodFireproof;
    public static final EnumArmorMaterial ARMOR_INVAR;
    public static final Material liquidRedstone;
    public static final Material liquidGlowstone;
    public static final Material liquidEnder;

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent event) {
        File oldFile = new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/telenames.cfg");
        if (oldFile.exists()) {
            oldFile.renameTo(new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/tesseracts.cfg"));
        }
        TesseractRegistry.linkConf = new Configuration(new File(DimensionManager.getCurrentSaveRootDirectory(), "/cofh/tesseracts.cfg"));
        TesseractRegistry.linkConf.load();
        TELiquids.registerDispenserHandlers();
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        version.checkForNewVersion();
        boolean optionColorBlind = false;
        boolean optionDrawBorders = true;
        int tweakLavaMJ = TEProps.lavaMJ;
        int tweakRedstoneEnergyLoss = (int)(100.0f - 100.0f * TEProps.redstoneEnergyFactor);
        int tweakTeleportEnergyLoss = 25;
        File oldFile = new File(CoFHProps.configDir, "/cofh/thermalexpansion.cfg");
        if (oldFile.exists()) {
            oldFile.renameTo(new File(CoFHProps.configDir, "/cofh/ThermalExpansion.cfg"));
        }
        config.setConfiguration(new Configuration(new File(event.getModConfigurationDirectory(), "cofh/ThermalExpansion.cfg")));
        this.cleanConfig(true);
        TEItems.configure();
        TEBlocks.configure();
        TELiquids.configure();
        TEPlugins.configure();
        String category = "general";
        TEProps.enableUpdateNotice = config.get(category, "EnableUpdateNotifications", true);
        TEProps.enableWrenchLogging = config.get(category, "LogWrenchDismantle", TEProps.enableWrenchLogging);
        optionColorBlind = config.get(category, "ColorBlindTextures", false);
        optionDrawBorders = config.get(category, "DrawGUISlotBorders", true);
        category = "tweak";
        tweakLavaMJ = config.get(category, "LavaMJValue", tweakLavaMJ);
        tweakRedstoneEnergyLoss = config.get(category, "EnergyFramework.Redstone.Loss", tweakRedstoneEnergyLoss);
        tweakTeleportEnergyLoss = config.get(category, "EnergyFramework.Tesseract.Loss", tweakTeleportEnergyLoss);
        PowerProviderTesseract.energyMax = config.get(category, "EnergyFramework.Tesseract.MaxTransfer", PowerProviderTesseract.energyMax);
        String version = config.get("general", "Version", "2.4.1.0");
        if (optionColorBlind) {
            TEProps.textureGuiCommon = "/mods/thermalexpansion/textures/gui/elements/SlotsCB.png";
            BlockMachine.textureSelection = "SideConfig_CB_";
        }
        TEProps.enableGuiBorders = optionDrawBorders;
        Localization.addLocalization((String)"/mods/thermalexpansion/lang/", (String)"en_US");
        if (tweakLavaMJ >= 1000 && tweakLavaMJ < 36000) {
            TEProps.lavaMJ = tweakLavaMJ;
            ThermalExpansionInfo.lavaFuelValue = tweakLavaMJ * 18 / 20;
        } else {
            log.log(Level.INFO, "'LavaMJValue' config value is out of acceptable range. Using default.");
        }
        if (tweakRedstoneEnergyLoss > 0 && tweakRedstoneEnergyLoss < 100) {
            TEProps.redstoneEnergyFactor = 1.0f - (float)tweakRedstoneEnergyLoss / 100.0f;
        } else {
            log.log(Level.INFO, "The configuration value for 'EnergyFramework.Redstone.Loss' is invalid. Ignoring this setting.");
        }
        if (tweakTeleportEnergyLoss >= 0 && tweakTeleportEnergyLoss < 100) {
            PowerProviderTesseract.energyFactor = 1.0f - (float)tweakTeleportEnergyLoss / 100.0f;
        } else {
            log.log(Level.INFO, "The configuration value for 'EnergyFramework.Tesseract.Loss' is invalid. Ignoring this setting.");
        }
        if (PowerProviderTesseract.energyFactor <= 0.0f) {
            PowerProviderTesseract.energyFactor = 0.0f;
            log.log(Level.INFO, "The configuration value for 'EnergyFramework.Tesseract.Loss' is too low. Energy loss will be disabled.");
        }
        if (PowerProviderTesseract.energyMax > 500) {
            PowerProviderTesseract.energyMax = 500;
            log.log(Level.INFO, "The configuration value for 'EnergyFramework.Tesseract.MaxTransfer' is too high. Setting to Maximum. (500)");
        } else if (PowerProviderTesseract.energyMax <= 0) {
            PowerProviderTesseract.energyMax = 100;
            log.log(Level.INFO, "The configuration value for 'EnergyFramework.Tesseract.MaxTransfer' is too low. Setting to Default. (100)");
        }
        if (VersionInfo.beforeTargetVersion((String)version, (String)"2.1.7.0")) {
            config.removeEntry("tweak", "factory.crucible.netherrack.energy");
            config.removeEntry("tweak", "core.lava.mj");
            config.get("tweak", "Crucible.Netherrack.Energy", 12000);
            config.get("tweak", "LavaMJValue", 20000);
        }
        if (VersionInfo.beforeTargetVersion((String)version, (String)"2.3.0.0")) {
            config.removeEntry("tweak", "factory.rockGen.stone.lava");
            config.get("tweak", "RockGen.Stone.Lava", 0);
            TileRockGen.processLava[1] = 0;
            oldFile = new File(event.getModConfigurationDirectory(), "cofh/telenames.cfg");
            if (oldFile.exists()) {
                oldFile.delete();
            }
        }
        config.init();
        TEItems.initialize();
        TEBlocks.initialize();
        TELiquids.initialize();
        TEPlugins.initialize();
    }

    @Mod.Init
    public void initialize(FMLInitializationEvent event) {
        this.loadWorldGeneration();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)TEPlayerTracker.instance);
        ActionManager.registerTriggerProvider(TriggerProviderEnergy.instance);
        ActionManager.registerTriggerProvider(TriggerProviderTesseract.instance);
        FurnaceManager.initialize();
        PulverizerManager.initialize();
        SawmillManager.initialize();
        SmelterManager.initialize();
        CrucibleManager.initialize();
        TransposerManager.initialize();
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
        FurnaceManager.loadRecipes();
        PulverizerManager.loadRecipes();
        SawmillManager.loadRecipes();
        SmelterManager.loadRecipes();
        CrucibleManager.loadRecipes();
        TransposerManager.loadRecipes();
        TEItems.loadRecipes();
        TEBlocks.loadRecipes();
        TELiquids.loadRecipes();
        TEPlugins.loadRecipes();
        proxy.registerPacketInformation();
        proxy.registerRenderInformation();
        proxy.registerTickHandlers();
        pluginProxy.registerRenderInformation();
        TriggerRegistry.resolveIDs();
        this.cleanConfig(false);
        config.cleanUp(false);
    }

    void loadWorldGeneration() {
        String category = "world.tweak";
        String[] ores = new String[]{"Copper", "Tin", "Silver", "Lead", "Nickel"};
        for (int i = 0; i < ores.length; ++i) {
            TEProps.oreMinY[i] = config.get(category, "Ore." + ores[i] + ".MinY", TEProps.oreMinY[i]);
            TEProps.oreMaxY[i] = config.get(category, "Ore." + ores[i] + ".MaxY", TEProps.oreMaxY[i]);
            TEProps.oreNumCluster[i] = config.get(category, "Ore." + ores[i] + ".NumClusters", TEProps.oreNumCluster[i]);
            TEProps.oreClusterSize[i] = config.get(category, "Ore." + ores[i] + ".ClusterSize", TEProps.oreClusterSize[i]);
        }
        ArrayList<WorldHandler.ResourceEntry> silverList = new ArrayList<WorldHandler.ResourceEntry>();
        silverList.add(new WorldHandler.ResourceEntry(BlockOre.oreSilver, 90));
        if (BlockOre.enable[TEProps.Ores.LEAD.ordinal()]) {
            silverList.add(new WorldHandler.ResourceEntry(BlockOre.oreLead, 10));
        }
        ArrayList<WorldHandler.ResourceEntry> leadList = new ArrayList<WorldHandler.ResourceEntry>();
        leadList.add(new WorldHandler.ResourceEntry(BlockOre.oreLead, 80));
        if (BlockOre.enable[TEProps.Ores.SILVER.ordinal()]) {
            leadList.add(new WorldHandler.ResourceEntry(BlockOre.oreSilver, 20));
        }
        if (BlockOre.enable[TEProps.Ores.COPPER.ordinal()]) {
            WorldHandler.addSurfaceGenerator((WorldGenerator)new WorldGenMinableCluster(BlockOre.oreCopper, TEProps.oreClusterSize[TEProps.Ores.COPPER.ordinal()]), (int)TEProps.oreMinY[TEProps.Ores.COPPER.ordinal()], (int)TEProps.oreMaxY[TEProps.Ores.COPPER.ordinal()], (int)TEProps.oreNumCluster[TEProps.Ores.COPPER.ordinal()], (int)WorldHandler.GenType.ORE_1.ordinal());
        }
        if (BlockOre.enable[TEProps.Ores.TIN.ordinal()]) {
            WorldHandler.addSurfaceGenerator((WorldGenerator)new WorldGenMinableCluster(BlockOre.oreTin, TEProps.oreClusterSize[TEProps.Ores.TIN.ordinal()]), (int)TEProps.oreMinY[TEProps.Ores.TIN.ordinal()], (int)TEProps.oreMaxY[TEProps.Ores.TIN.ordinal()], (int)TEProps.oreNumCluster[TEProps.Ores.TIN.ordinal()], (int)WorldHandler.GenType.ORE_1.ordinal());
        }
        if (BlockOre.enable[TEProps.Ores.SILVER.ordinal()]) {
            WorldHandler.addSurfaceGenerator((WorldGenerator)new WorldGenMinableCluster(silverList, TEProps.oreClusterSize[TEProps.Ores.SILVER.ordinal()]), (int)TEProps.oreMinY[TEProps.Ores.SILVER.ordinal()], (int)TEProps.oreMaxY[TEProps.Ores.SILVER.ordinal()], (int)TEProps.oreNumCluster[TEProps.Ores.SILVER.ordinal()], (int)WorldHandler.GenType.ORE_1.ordinal());
        }
        if (BlockOre.enable[TEProps.Ores.LEAD.ordinal()]) {
            WorldHandler.addSurfaceGenerator((WorldGenerator)new WorldGenMinableCluster(leadList, TEProps.oreClusterSize[TEProps.Ores.LEAD.ordinal()]), (int)TEProps.oreMinY[TEProps.Ores.LEAD.ordinal()], (int)TEProps.oreMaxY[TEProps.Ores.LEAD.ordinal()], (int)TEProps.oreNumCluster[TEProps.Ores.LEAD.ordinal()], (int)WorldHandler.GenType.ORE_1.ordinal());
        }
        if (BlockOre.enable[TEProps.Ores.NICKEL.ordinal()]) {
            WorldHandler.addSurfaceGenerator((WorldGenerator)new WorldGenMinableCluster(BlockOre.oreNickel, TEProps.oreClusterSize[TEProps.Ores.NICKEL.ordinal()]), (int)TEProps.oreMinY[TEProps.Ores.NICKEL.ordinal()], (int)TEProps.oreMaxY[TEProps.Ores.NICKEL.ordinal()], (int)TEProps.oreNumCluster[TEProps.Ores.NICKEL.ordinal()], (int)WorldHandler.GenType.ORE_1.ordinal());
        }
    }

    void cleanConfig(boolean preInit) {
        if (preInit) {
            String category = "block";
            config.renameEntry(category, "block.energy.storage", category, "EnergyCell", true);
            config.renameEntry(category, "block.energy.conduit", category, "Conduit", true);
            config.renameEntry(category, "block.core.ore", category, "Ore", true);
            config.renameEntry(category, "block.energy.cell", category, "EnergyCell", true);
            config.renameEntry(category, "block.energy.engine", category, "Engine", true);
            config.renameEntry(category, "block.factory.machine", category, "Machine", true);
            config.renameEntry(category, "block.factory.glass", category, "Glass", true);
            config.renameEntry(category, "block.factory.tank", category, "Tank", true);
            config.renameEntry(category, "block.factory.rockwool", category, "Rockwool", true);
            config.renameEntry(category, "block.transport.conduit", category, "Conduit", true);
            config.renameEntry(category, "block.transport.teleport", category, "Tesseract", true);
            category = "block.feature";
            config.renameEntry(category, "energy.engine.magmatic", category, "Engine.Magmatic", true);
            config.renameEntry(category, "energy.engine.steam", category, "Engine.Steam", true);
            config.renameEntry(category, "energy.storage.cell", category, "EnergyCell.Enable", true);
            config.renameEntry(category, "factory.machine.furnace", category, "Machine.Furnace", true);
            config.renameEntry(category, "factory.machine.pulverizer", category, "Machine.Pulverizer", true);
            config.renameEntry(category, "factory.machine.sawmill", category, "Machine.Sawmill", true);
            config.renameEntry(category, "factory.machine.smelter", category, "Machine.Smelter", true);
            config.renameEntry(category, "factory.machine.crucible", category, "Machine.Crucible", true);
            config.renameEntry(category, "factory.machine.transposer", category, "Machine.Transposer", true);
            config.renameEntry(category, "factory.machine.iceGen", category, "Machine.IceGen", true);
            config.renameEntry(category, "factory.machine.rockGen", category, "Machine.RockGen", true);
            config.renameEntry(category, "factory.machine.waterGen", category, "Machine.WaterGen", true);
            config.renameEntry(category, "factory.tank.portable", category, "Tank.Portable", true);
            config.renameEntry(category, "transport.conduit.energy", category, "Conduit.Energy", true);
            config.renameEntry(category, "transport.conduit.liquid", category, "Conduit.Liquid", true);
            config.renameEntry(category, "transport.teleport.energy", category, "Tesseract.Energy", true);
            config.renameEntry(category, "transport.teleport.liquid", category, "Tesseract.Liquid", true);
            config.renameEntry(category, "transport.teleport.items", category, "Tesseract.Item", true);
            category = "item";
            config.renameEntry(category, "liquid.energy.redstone", category, "Liquid", true);
            config.renameEntry(category, "item.energy.mjreader", category, "Tool.Multimeter", true);
            config.renameEntry(category, "item.core.wrench", category, "Tool.Wrench", true);
            config.renameEntry(category, "item.transport.multimeter", category, "Tool.Multimeter", true);
            config.renameEntry(category, "item.core.component", category, "Component", true);
            config.renameEntry(category, "item.core.material", category, "Material", true);
            config.renameEntry(category, "item.core.liquid", category, "Liquid", true);
            config.renameEntry("item.feature", "wrench.logDismantle", "general", "LogWrenchDismantle", true);
            category = "general";
            config.renameEntry(category, "tutorial.tabs", category, "tabs.tutorial", true);
            config.renameEntry(category, "graphics.colorblind", category, "ColorBlindTextures", true);
            config.renameEntry(category, "graphics.slotborders", category, "DrawGUISlotBorders", true);
            config.renameEntry(category, "update.notifications", category, "EnableUpdateNotifications", true);
            category = "triggers";
            config.renameEntry(category, "noEnergy", category, "ContainsEnergy", true);
            config.renameEntry(category, "containsEnergy", category, "ContainsEnergy", true);
            config.renameEntry(category, "spaceForEnergy", category, "SpaceForEnergy", true);
            config.renameEntry(category, "fullEnergy", category, "FullEnergy", true);
            config.renameEntry(category, "hasOutputs", category, "HasOutputs", true);
            config.renameEntry(category, "noOutputs", category, "NoOutputs", true);
            config.renameEntry(category, "hasInputs", category, "HasInputs", true);
            config.renameEntry(category, "noInputs", category, "NoInputs", true);
            category = "tweak";
            config.renameEntry(category, "factory.crafting.machineFrame.useSteel", "tweak.recipe", "MachineFrame.UseSteel", true);
            config.renameEntry(category, "factory.crafting.machines.useGears", "tweak.recipe", "Machines.UseGears", true);
            config.renameEntry(category, "factory.crafting.pulverizer.alternate", "tweak.recipe", "Pulverizer.AddDiamonds", true);
            config.renameEntry(category, "factory.crafting.smelter.alternate", "tweak.recipe", "Smelter.AddDiamonds", true);
            config.renameEntry(category, "factory.crucible.netherrack.energy", category, "Crucible.Netherrack.Energy", true);
            config.renameEntry(category, "factory.pulverizer.recipe.IngotsToDust", category, "Pulverizer.IngotsToDust", true);
            config.renameEntry(category, "factory.pulverizer.recipe.sandstone", category, "Pulverizer.Sandstone", true);
            config.renameEntry(category, "factory.pulverizer.recipe.netherrack", category, "Pulverizer.Netherrack", true);
            config.renameEntry(category, "factory.pulverizer.recipe.wool", category, "Pulverizer.Wool", false);
            config.renameEntry(category, "factory.pulverizer.recipe.reed", category, "Pulverizer.Reed", true);
            config.renameEntry(category, "factory.pulverizer.recipe.bone", category, "Pulverizer.Bone", true);
            config.renameEntry(category, "factory.pulverizer.recipe.blazerod", category, "Pulverizer.BlazeRod", true);
            config.renameEntry(category, "factory.rockGen.cobblestone.lava", category, "RockGen.Cobblestone.Lava", true);
            config.renameEntry(category, "factory.rockGen.cobblestone.water", category, "RockGen.Cobblestone.Water", true);
            config.renameEntry(category, "factory.rockGen.cobblestone.time", category, "RockGen.Cobblestone.Time", true);
            config.renameEntry(category, "factory.rockGen.stone.lava", category, "RockGen.Stone.Lava", true);
            config.renameEntry(category, "factory.rockGen.stone.water", category, "RockGen.Stone.Water", true);
            config.renameEntry(category, "factory.rockGen.stone.time", category, "RockGen.Stone.Time", true);
            config.renameEntry(category, "factory.rockGen.obsidian.lava", category, "RockGen.Obsidian.Lava", true);
            config.renameEntry(category, "factory.rockGen.obsidian.water", category, "RockGen.Obsidian.Water", true);
            config.renameEntry(category, "factory.rockGen.obsidian.time", category, "RockGen.Obsidian.Time", true);
            config.renameEntry(category, "factory.waterGen.rate", category, "WaterGen.Rate", true);
            config.renameEntry(category, "transport.conduit.energy.loss", category, "Redstone.Energy.Loss", true);
            config.renameEntry(category, "core.lava.mj", category, "LavaMJValue", true);
            config.renameEntry(category, "transport.teleport.energy.loss", category, "EnergyFramework.Tesseract.Loss", true);
            config.renameEntry(category, "transport.teleport.energy.maxTransfer", category, "EnergyFramework.Tesseract.MaxTransfer", true);
            config.renameEntry(category, "plugins.turtlesCanBreakBlocks", category, "Plugins.CC.TurtlesCanBreakBlocks", true);
            config.renameEntry("tweak.recipehandlers", "factory.furnace.override", "tweak.craftinghandlers", "Furnace.Override", true);
            config.renameEntry("tweak.recipehandlers", "factory.pulverizer.override", "tweak.craftinghandlers", "Pulverizer.Override", true);
            config.renameEntry("tweak.recipehandlers", "factory.sawmill.override", "tweak.craftinghandlers", "Sawmill.Override", true);
            config.renameEntry("tweak.recipehandlers", "factory.smelter.override", "tweak.craftinghandlers", "Smelter.Override", true);
            config.renameEntry("tweak.recipehandlers", "factory.crucible.override", "tweak.craftinghandlers", "Crucible.Override", true);
            config.renameEntry("tweak.recipehandlers", "factory.transposer.override", "tweak.craftinghandlers", "Transposer.Override", true);
            config.renameEntry("world.gen", "ore.copper", "world.feature", "Ore.Copper", true);
            config.renameEntry("world.gen", "ore.tin", "world.feature", "Ore.Tin", true);
            config.renameEntry("world.gen", "ore.silver", "world.feature", "Ore.Silver", true);
            config.renameEntry("world.gen", "ore.lead", "world.feature", "Ore.Lead", true);
            config.renameEntry("world.feature", "ore.copper", "world.feature", "Ore.Copper", true);
            config.renameEntry("world.feature", "ore.tin", "world.feature", "Ore.Tin", true);
            config.renameEntry("world.feature", "ore.silver", "world.feature", "Ore.Silver", true);
            config.renameEntry("world.feature", "ore.lead", "world.feature", "Ore.Lead", true);
            config.renameEntry("world.feature", "ore.ferrous", "world.feature", "Ore.Nickel", true);
            category = "world.tweak";
            config.renameEntry(category, "ore.copper.minY", category, "Ore.Copper.MinY", true);
            config.renameEntry(category, "ore.tin.minY", category, "Ore.Tin.MinY", true);
            config.renameEntry(category, "ore.silver.minY", category, "Ore.Silver.MinY", true);
            config.renameEntry(category, "ore.lead.minY", category, "Ore.Lead.MinY", true);
            config.renameEntry(category, "ore.ferrous.minY", category, "Ore.Nickel.MinY", true);
            config.renameEntry(category, "ore.copper.maxY", category, "Ore.Copper.MaxY", true);
            config.renameEntry(category, "ore.tin.maxY", category, "Ore.Tin.MaxY", true);
            config.renameEntry(category, "ore.silver.maxY", category, "Ore.Silver.MaxY", true);
            config.renameEntry(category, "ore.lead.maxY", category, "Ore.Lead.MaxY", true);
            config.renameEntry(category, "ore.ferrous.maxY", category, "Ore.Nickel.MaxY", true);
            config.renameEntry(category, "ore.copper.numClusters", category, "Ore.Copper.NumClusters", true);
            config.renameEntry(category, "ore.tin.numClusters", category, "Ore.Tin.NumClusters", true);
            config.renameEntry(category, "ore.silver.numClusters", category, "Ore.Silver.NumClusters", true);
            config.renameEntry(category, "ore.lead.numClusters", category, "Ore.Lead.NumClusters", true);
            config.renameEntry(category, "ore.ferrous.numClusters", category, "Ore.Nickel.NumClusters", true);
            config.renameEntry(category, "ore.copper.clusterSize", category, "Ore.Copper.ClusterSize", true);
            config.renameEntry(category, "ore.tin.clusterSize", category, "Ore.Tin.ClusterSize", true);
            config.renameEntry(category, "ore.silver.clusterSize", category, "Ore.Silver.ClusterSize", true);
            config.renameEntry(category, "ore.lead.clusterSize", category, "Ore.Lead.ClusterSize", true);
            config.renameEntry(category, "ore.ferrous.clusterSize", category, "Ore.Nickel.ClusterSize", true);
            config.renameEntry("item.plugin", "BuildCraft.Pipe.Insertion", "item", "BuildCraft.Pipe.Insertion", true);
            config.renameEntry("item.plugin", "BuildCraft.Pipe.Redstone", "item", "BuildCraft.Pipe.Redstone", true);
        } else {
            String category = "block";
            config.removeEntry(category, "block.energy.conduit");
            config.removeEntry(category, "block.factory.conduit");
            config.removeEntry(category, "block.machine");
            config.removeEntry(category, "block.ore");
            config.removeEntry(category, "block.rockwool");
            category = "block.feature";
            config.removeEntry(category, "machine.crucible");
            config.removeEntry(category, "machine.filler");
            config.removeEntry(category, "factory.machine.filler");
            config.removeEntry(category, "machine.furnace");
            config.removeEntry(category, "machine.iceGen");
            config.removeEntry(category, "machine.pulverizer");
            config.removeEntry(category, "machine.rockGen");
            config.removeEntry(category, "machine.sawmill");
            config.removeEntry(category, "machine.smelter");
            config.removeEntry(category, "machine.waterGen");
            config.removeEntry(category, "energy.conduit");
            config.removeEntry(category, "energy.storage");
            category = "general";
            config.removeEntry(category, "tabs.info");
            config.removeEntry(category, "tabs.tutorial");
            category = "item";
            config.removeEntry(category, "item.alloy");
            config.removeEntry(category, "item.mineral");
            config.removeEntry(category, "item.pulverized");
            config.removeEntry(category, "item.reconfigTool");
            config.removeEntry(category, "item.factory.component");
            config.removeEntry(category, "item.energy.component");
            config.removeEntry(category, "Liquid");
            category = "tweak";
            config.removeEntry(category, "Plugins.CC.TurtlesCanBreakBlocks");
            config.removeEntry(category, "machine.crucible.recipe.netherrack.mj");
            config.removeEntry(category, "energy.grid.loss");
            config.removeEntry(category, "energy.grid.allowRedstoneEngines");
            config.removeEntry(category, "factory.tank.updateTime");
            config.removeEntry(category, "transport.conduit.energy.allowRedstoneEngines");
            config.removeEntry(category, "transport.conduit.liquid.updateTime");
            category = "world.gen";
            config.removeEntry(category, "ore.copper");
            config.removeEntry(category, "ore.tin");
            config.removeEntry(category, "ore.silver");
            config.removeEntry(category, "ore.lead");
            config.removeEntry("world.feature", "vanilla.augment");
            category = "world.tweak";
            config.removeEntry(category, "vanilla.augment.iron.clusterSize");
            config.removeEntry(category, "vanilla.augment.iron.numClusters");
            config.removeEntry(category, "vanilla.augment.gold.clusterSize");
            config.removeEntry(category, "vanilla.augment.gold.numClusters");
            config.removeEntry(category, "vanilla.augment.diamond.clusterSize");
            config.removeEntry(category, "vanilla.augment.diamond.numClusters");
            config.renameEntry("item", "BuildCraft.Pipe.Insertion", "item.plugin", "BuildCraft.Pipe.Insertion", true);
            config.renameEntry("item", "BuildCraft.Pipe.Redstone", "item.plugin", "BuildCraft.Pipe.Redstone", true);
        }
    }

    static {
        log = Logger.getLogger("ThermalExpansion");
        config = new ConfigHandler("2.4.1.0", 2001, 20001);
        guiHandler = new GuiHandler();
        version = new VersionInfo("Thermal Expansion", "2.4.1.0", "https://dl.dropboxusercontent.com/u/57416963/Minecraft/Mods/ThermalExpansion/version.txt", log);
        tab = new CreativeTabTE();
        log.setParent(FMLLog.getLogger());
        clothFireproof = new Material(MapColor.field_76278_e);
        woodFireproof = new Material(MapColor.field_76283_o);
        ARMOR_INVAR = EnumHelper.addArmorMaterial((String)"TE_INVAR", (int)25, (int[])new int[]{2, 7, 5, 2}, (int)12);
        liquidRedstone = new MaterialLiquid(MapColor.field_76275_f);
        liquidGlowstone = new MaterialLiquid(MapColor.field_76277_d);
        liquidEnder = new MaterialLiquid(MapColor.field_76289_i);
    }
}

