/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import buildcraft.api.core.SafeTimeTracker;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.World;
import thermalexpansion.block.conduit.PowerProviderGrid;
import thermalexpansion.block.conduit.TileConduitEnergy;

public class GridEnergy {
    List conduitList = new LinkedList();
    List outputList = new LinkedList();
    List inputList = new LinkedList();
    World worldObj;
    SafeTimeTracker tracker = new SafeTimeTracker();
    boolean recentUpdate = false;
    public PowerProviderGrid myProvider;
    public static int updateTime = 40;
    public int nodeCount = 0;
    public int conduitTick = 0;

    public GridEnergy(World world) {
        this.worldObj = world;
        this.myProvider = new PowerProviderGrid();
    }

    public void addConduit(TileConduitEnergy theCond) {
        if (!this.conduitList.contains(theCond)) {
            this.conduitList.add(theCond);
        }
        theCond.updateConnections();
    }

    public void addNode(TileConduitEnergy theCond) {
        if (theCond.mode == 0) {
            if (!this.outputList.contains(theCond)) {
                this.outputList.add(theCond);
            }
            this.inputList.remove(theCond);
        }
        if (theCond.mode == 1) {
            if (!this.inputList.contains(theCond)) {
                this.inputList.add(theCond);
            }
            this.outputList.remove(theCond);
        }
        this.addEnergy(theCond);
        this.recalcProvider();
        theCond.updateConnections();
    }

    public void removeConduit(TileConduitEnergy theCond) {
        this.conduitList.remove(theCond);
    }

    public void removeNode(TileConduitEnergy theCond) {
        this.outputList.remove(theCond);
        this.inputList.remove(theCond);
    }

    public void addEnergy(TileConduitEnergy theCond) {
        if (theCond.tempEnergyStored > 0.0f) {
            this.myProvider.addEnergyWithoutLoss(theCond.tempEnergyStored);
            theCond.tempEnergyStored = 0.0f;
        }
    }

    public void changeMode(TileConduitEnergy theCond) {
        this.inputList.remove(theCond);
        this.outputList.remove(theCond);
        if (theCond.mode == 0) {
            this.outputList.add(theCond);
        } else {
            this.inputList.add(theCond);
        }
    }

    public void transferEnergy(TileConduitEnergy theCond) {
        block15: {
            int i;
            TileConduitEnergy theTile;
            int randCond;
            int a;
            float curEnergyUsed;
            float distAmount;
            block16: {
                if (this.outputList.size() <= 0 || !((TileConduitEnergy)this.outputList.get(0)).equals(theCond) || !(this.myProvider.getEnergyStored() > 0.0f)) break block15;
                distAmount = this.getNodeEnergy();
                curEnergyUsed = 0.0f;
                if (!(distAmount > 0.0f)) break block16;
                for (int a2 = 0; a2 < this.outputList.size(); ++a2) {
                    int i2;
                    TileConduitEnergy theTile2 = (TileConduitEnergy)this.outputList.get(a2);
                    curEnergyUsed = distAmount;
                    for (i2 = theTile2.outputTracker; i2 < 6 && curEnergyUsed > 0.0f; curEnergyUsed -= theTile2.transferEnergy(i2, curEnergyUsed), ++i2) {
                    }
                    for (i2 = 0; i2 < theTile2.outputTracker && curEnergyUsed > 0.0f; curEnergyUsed -= theTile2.transferEnergy(i2, curEnergyUsed), ++i2) {
                    }
                    if (theTile2.trackEnergy) {
                        theTile2.energySent.add(Float.valueOf(distAmount - curEnergyUsed));
                        if (theTile2.energySent.size() >= 20) {
                            theTile2.trackEnergy = false;
                        }
                    }
                    theTile2.outputTracker = this.increaseTracker(theTile2.sideCache, theTile2.outputTracker);
                }
                break block15;
            }
            if (!(this.myProvider.getEnergyStored() % (float)this.nodeCount > 0.0f)) break block15;
            curEnergyUsed = this.myProvider.getEnergyStored() % (float)this.nodeCount;
            for (a = randCond = theCond.field_70331_k.field_73012_v.nextInt(this.outputList.size()); a < this.outputList.size(); ++a) {
                theTile = (TileConduitEnergy)this.outputList.get(a);
                for (i = theTile.outputTracker; i < 6 && curEnergyUsed > 0.0f; curEnergyUsed -= theTile.transferEnergy(i, curEnergyUsed), ++i) {
                }
                for (i = 0; i < theTile.outputTracker && curEnergyUsed > 0.0f; curEnergyUsed -= theTile.transferEnergy(i, curEnergyUsed), ++i) {
                }
                if (theTile.trackEnergy) {
                    theTile.energySent.add(Float.valueOf(distAmount - curEnergyUsed));
                    if (theTile.energySent.size() >= 20) {
                        theTile.trackEnergy = false;
                    }
                }
                theTile.outputTracker = this.increaseTracker(theTile.sideCache, theTile.outputTracker);
                if (curEnergyUsed != 0.0f) continue;
                return;
            }
            for (a = 0; a < randCond; ++a) {
                theTile = (TileConduitEnergy)this.outputList.get(a);
                for (i = theTile.outputTracker; i < 6 && curEnergyUsed > 0.0f; curEnergyUsed -= theTile.transferEnergy(i, curEnergyUsed), ++i) {
                }
                for (i = 0; i < theTile.outputTracker && curEnergyUsed > 0.0f; curEnergyUsed -= theTile.transferEnergy(i, curEnergyUsed), ++i) {
                }
                if (theTile.trackEnergy) {
                    theTile.energySent.add(Float.valueOf(distAmount - curEnergyUsed));
                    if (theTile.energySent.size() >= 20) {
                        theTile.trackEnergy = false;
                    }
                }
                theTile.outputTracker = this.increaseTracker(theTile.sideCache, theTile.outputTracker);
                if (curEnergyUsed != 0.0f) continue;
                return;
            }
        }
    }

    public byte increaseTracker(byte[] sideList, byte curTrack) {
        byte i;
        for (i = curTrack = (byte)(curTrack + 1); i < 6; i = (byte)(i + 1)) {
            if (sideList[i] <= 1) continue;
            return i;
        }
        for (i = 0; i < curTrack; i = (byte)(i + 1)) {
            if (sideList[i] <= 1) continue;
            return i;
        }
        return 0;
    }

    public void setNewGrid(GridEnergy newGrid) {
        Iterator anIt = this.conduitList.iterator();
        TileConduitEnergy aConduit2 = null;
        while (anIt.hasNext()) {
            aConduit2 = (TileConduitEnergy)anIt.next();
            aConduit2.myGrid = newGrid;
            newGrid.addConduit(aConduit2);
        }
        for (TileConduitEnergy aConduit2 : this.outputList) {
            aConduit2.myGrid = newGrid;
            newGrid.addNode(aConduit2);
        }
        for (TileConduitEnergy aConduit2 : this.inputList) {
            aConduit2.myGrid = newGrid;
            newGrid.addNode(aConduit2);
        }
        this.conduitList = null;
        this.outputList = null;
        this.inputList = null;
        newGrid.myProvider.addEnergyWithoutLoss(this.myProvider.getEnergyStored());
        newGrid.recalcProvider();
        this.myProvider = new PowerProviderGrid();
    }

    public void destroy() {
        int i;
        if (this.getNodeEnergy() <= 0.0f) {
            return;
        }
        float distAmount = this.getNodeEnergy();
        for (i = 0; i < this.outputList.size(); ++i) {
            ((TileConduitEnergy)this.outputList.get((int)i)).tempEnergyStored = distAmount;
        }
        for (i = 0; i < this.inputList.size(); ++i) {
            ((TileConduitEnergy)this.inputList.get((int)i)).tempEnergyStored = distAmount;
        }
    }

    public float getNodeEnergy() {
        if (this.nodeCount <= 0) {
            return 0.0f;
        }
        if (this.myProvider.getEnergyStored() / (float)this.nodeCount >= 1.0f) {
            return this.myProvider.getEnergyStored() / (float)this.nodeCount;
        }
        return 0.0f;
    }

    private void recalcProvider() {
        this.nodeCount = this.outputList.size() + this.inputList.size();
        this.myProvider.setMaxEnergyStored(this.nodeCount);
    }

    public boolean contains(TileConduitEnergy theCond) {
        return this.conduitList.contains(theCond) || this.outputList.contains(theCond) || this.inputList.contains(theCond);
    }

    public boolean isFirst(TileConduitEnergy theCond) {
        if (this.conduitList.size() > 0) {
            return ((TileConduitEnergy)this.conduitList.get(0)).equals(theCond);
        }
        if (this.outputList.size() > 0) {
            return ((TileConduitEnergy)this.outputList.get(0)).equals(theCond);
        }
        if (this.inputList.size() > 0) {
            return ((TileConduitEnergy)this.inputList.get(0)).equals(theCond);
        }
        return false;
    }

    public void updateRender(TileConduitEnergy theCond) {
        if (this.tracker.markTimeIfDelay(this.worldObj, updateTime) && this.recentUpdate) {
            this.recentUpdate = false;
        }
    }
}

