/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.block.conduit.GridLiquid;

public class LiquidTankGrid
implements ILiquidTank {
    private LiquidStack liquid;
    private int capacity;
    private int tankPressure;
    private GridLiquid grid;

    public LiquidTankGrid(int capacity, GridLiquid grid) {
        this(null, capacity, grid);
    }

    public LiquidTankGrid(LiquidStack liquid, int capacity, GridLiquid grid) {
        this.liquid = liquid;
        this.capacity = capacity;
        this.grid = grid;
    }

    public LiquidStack getLiquid() {
        return this.liquid;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void fillWithoutLoss(LiquidStack resource) {
        if (resource == null || resource.itemID <= 0) {
            return;
        }
        if (this.liquid == null || this.liquid.itemID <= 0) {
            this.grid.setLiquidData(resource, true);
            this.liquid = resource.copy();
        } else {
            if (!this.liquid.isLiquidEqual(resource)) {
                return;
            }
            this.liquid.amount += resource.amount;
        }
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID <= 0) {
            return 0;
        }
        boolean overfill = false;
        if (this.liquid == null || this.liquid.itemID <= 0) {
            this.grid.setLiquidData(resource, true);
            if (resource.amount <= this.capacity) {
                if (doFill) {
                    this.liquid = resource.copy();
                }
                return resource.amount;
            }
            if (doFill) {
                this.liquid = resource.copy();
                this.liquid.amount = this.capacity;
            }
            return this.capacity;
        }
        if (!this.liquid.isLiquidEqual(resource)) {
            return 0;
        }
        int space = this.capacity - this.liquid.amount;
        if (resource.amount <= space) {
            if (doFill) {
                this.liquid.amount += resource.amount;
            }
            return resource.amount;
        }
        if (doFill) {
            this.liquid.amount = this.capacity;
        }
        return space;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null || this.liquid.itemID <= 0) {
            return null;
        }
        if (this.liquid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.liquid.amount < used) {
            used = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= used;
        }
        LiquidStack drained = new LiquidStack(this.liquid.itemID, used, this.liquid.itemMeta);
        if (this.liquid.amount <= 0) {
            this.liquid = null;
            this.grid.setLiquidData(null, false);
        }
        return drained;
    }

    public int getTankPressure() {
        return this.tankPressure;
    }

    public void setLiquid(LiquidStack liquid) {
        this.grid.setLiquidData(liquid, true);
        this.liquid = liquid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.liquid != null && this.liquid.amount > this.capacity) {
            this.liquid.amount = capacity;
        }
    }
}

