/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import cofh.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.core.TEProps;
import thermalexpansion.util.energy.IPowerProviderAdv;
import thermalexpansion.util.energy.IPowerProviderLoss;

public class PowerProviderGrid
extends PowerProvider
implements IPowerProviderAdv,
IPowerProviderLoss {
    public static int maxNodeStorage = 1000;
    public static float energyRequest = 1.0f / TEProps.redstoneEnergyFactor;

    public PowerProviderGrid() {
        this.powerLoss = 0;
        this.powerLossRegularity = 72000;
        this.configure(maxNodeStorage, 0);
    }

    public void configure(int maxEnergyReceived, int maxStoredEnergy) {
        super.configure(0, 2, MathHelper.ceil((double)((float)maxEnergyReceived * energyRequest)), 0, maxStoredEnergy);
    }

    @Override
    public boolean update(IPowerReceptor receptor) {
        return false;
    }

    @Override
    public void receiveEnergy(float quantity, ForgeDirection from) {
        this.addEnergy(quantity);
    }

    public void setMaxEnergyStored(int nodeCount) {
        this.maxEnergyStored = nodeCount * maxNodeStorage;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public void addEnergy(float quantity) {
        this.energyStored += (quantity *= TEProps.redstoneEnergyFactor);
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public void subtractEnergy(float quantity) {
        this.energyStored -= quantity;
        if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void setEnergyStored(float quantity) {
        this.energyStored = quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        } else if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void roundEnergyStored() {
        this.energyStored = MathHelper.round((double)this.energyStored);
    }

    @Override
    public int powerRequest() {
        if (this.energyStored == (float)this.maxEnergyStored) {
            return 0;
        }
        return (int)(energyRequest * (float)MathHelper.minI((int)maxNodeStorage, (int)MathHelper.ceil((double)((float)this.maxEnergyStored - this.energyStored))));
    }

    @Override
    public void addEnergyWithoutLoss(float quantity) {
        this.energyStored += quantity;
    }

    @Override
    public void receiveEnergyWithoutLoss(float quantity, ForgeDirection from) {
        this.addEnergyWithoutLoss(quantity);
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }
}

