/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import cofh.codechicken.core.vec.Cuboid6;
import cofh.codechicken.core.vec.Vector3;
import cofh.util.raytracer.RayTracer;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.block.ISubSelectionBoxProvider;

public abstract class TileConduitRoot
extends TileEntity
implements ISubSelectionBoxProvider {
    protected boolean needsGrid = true;
    protected boolean conduitInvalid = false;
    protected boolean placingBlock = true;
    public byte[] sideCache = new byte[]{0, 0, 0, 0, 0, 0};
    public byte mode = 0;
    public byte outputTracker = 0;
    public static Cuboid6[] subSelection = new Cuboid6[6];

    public int getLightValue() {
        return 0;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.conduitInvalid) {
            for (int s = 6; s < 6; ++s) {
                this.sideCache[s] = 0;
            }
            this.onBlockAdded();
            this.conduitInvalid = false;
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.breakBlock();
    }

    public abstract int getRenderId();

    public abstract LiquidStack getRenderLiquid();

    public abstract int getRenderLiquidLevel();

    public abstract void debugOutput();

    public abstract void breakBlock();

    public abstract void onBlockAdded();

    public abstract void changeMode(EntityPlayer var1, int var2);

    public abstract void checkConnections();

    public abstract void onNeighborBlockChange();

    public abstract boolean canTransfer();

    public abstract boolean wrenchAction(EntityPlayer var1, int var2);

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.placingBlock = false;
        this.sideCache = data.func_74770_j("side.array");
        if (this.sideCache.length == 0) {
            this.sideCache = new byte[]{0, 0, 0, 0, 0, 0};
        }
        this.mode = data.func_74771_c("mode");
        this.outputTracker = data.func_74771_c("sendTracker");
        this.mode = (byte)(this.mode % 2);
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74774_a("mode", this.mode);
        data.func_74774_a("output", this.outputTracker);
        data.func_74773_a("side.array", this.sideCache);
        data.func_74778_a("version", "2.4.1.0");
    }

    @Override
    public void addTraceableCuboids(List cuboids) {
        double minZ = 0.3;
        double minY = 0.3;
        double minX = 0.3;
        double maxZ = 0.7;
        double maxY = 0.7;
        double maxX = 0.7;
        Vector3 pos = new Vector3((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n);
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < 2) continue;
            cuboids.add(new RayTracer.IndexedCuboid6(i, subSelection[i].copy().add(pos)));
        }
        if (this.sideCache[0] == 1) {
            minY = 0.0;
        }
        if (this.sideCache[1] == 1) {
            maxY = 1.0;
        }
        if (this.sideCache[2] == 1) {
            minZ = 0.0;
        }
        if (this.sideCache[3] == 1) {
            maxZ = 1.0;
        }
        if (this.sideCache[4] == 1) {
            minX = 0.0;
        }
        if (this.sideCache[5] == 1) {
            maxX = 1.0;
        }
        cuboids.add(new RayTracer.IndexedCuboid6(6, new Cuboid6(minX, minY, minZ, maxX, maxY, maxZ).add(pos)));
    }

    static {
        double min = 0.25;
        double max = 0.75;
        double min2 = 0.2;
        double max2 = 0.8;
        TileConduitRoot.subSelection[0] = new Cuboid6(min2, 0.0, min2, max2, min, max2);
        TileConduitRoot.subSelection[1] = new Cuboid6(min2, 1.0 - min, min2, max2, 1.0, max2);
        TileConduitRoot.subSelection[2] = new Cuboid6(min2, min2, 0.0, max2, max2, min);
        TileConduitRoot.subSelection[3] = new Cuboid6(min2, min2, 1.0 - min, max2, max2, 1.0);
        TileConduitRoot.subSelection[4] = new Cuboid6(0.0, min2, min2, min, max2, max2);
        TileConduitRoot.subSelection[5] = new Cuboid6(1.0 - min, min2, min2, 1.0, max2, max2);
    }

    public static enum LiquidRenderInfo {
        EMPTY,
        LOW,
        LOW_MED,
        MEDIUM,
        MED_HIGH,
        HIGH,
        FULL;

    }

    protected static class SideInfo {
        public static final byte NONE = 0;
        public static final byte CONDUIT = 1;
        public static final byte OTHER = 2;
        public static final byte INVENTORY = 3;

        protected SideInfo() {
        }
    }
}

