/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit.item;

import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.block.conduit.BlockConduit;
import thermalexpansion.block.conduit.GridItem;
import thermalexpansion.block.conduit.TileConduitRoot;

public class TileConduitItemBase
extends TileConduitRoot
implements ITilePacketHandler {
    public GridItem myGrid = null;
    private static int descPacketId = PacketHandler.getAvailablePacketId();
    public boolean hasInventory = false;
    public int returnedLength = 1;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileConduitItemBase.class, (String)"cofh.thermalexpansion.ConduitItem");
    }

    public Packet func_70319_e() {
        Payload payload = new Payload(0, 7, 0, 0, 0);
        payload.bytePayload[0] = this.mode;
        System.arraycopy(this.sideCache, 0, payload.bytePayload, 1, this.sideCache.length);
        PacketTile packet = new PacketTile(descPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void sendDescPacket() {
        PacketUtils.sendToPlayers((Packet)this.func_70319_e(), (TileEntity)this);
    }

    public void handleTilePacket(PacketTile packet) {
        this.mode = packet.payload.bytePayload[0];
        System.arraycopy(packet.payload.bytePayload, 1, this.sideCache, 0, this.sideCache.length);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public int getLightValue() {
        return 7;
    }

    @Override
    public int getRenderId() {
        return BlockConduit.Types.LIQUID.ordinal();
    }

    @Override
    public LiquidStack getRenderLiquid() {
        return null;
    }

    @Override
    public int getRenderLiquidLevel() {
        return 0;
    }

    @Override
    public void debugOutput() {
    }

    @Override
    public void breakBlock() {
        int i;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.conduitInvalid = true;
        TileConduitItemBase[] allSides = this.getAdjacentConduits(-1);
        if (this.myGrid == null) {
            return;
        }
        this.myGrid.destroy();
        this.myGrid.removeTile(this);
        for (i = 0; i < 6; ++i) {
            if (allSides[i] == null) continue;
            allSides[i].myGrid = null;
            allSides[i].sideCache[i ^ 1] = 0;
        }
        for (i = 0; i < 6; ++i) {
            if (allSides[i] == null) continue;
            allSides[i].updateGridIfNull();
        }
        this.needsGrid = true;
        this.myGrid = null;
    }

    @Override
    public void onBlockAdded() {
        int i;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.checkConnections();
        TileConduitItemBase[] allSides = this.getAdjacentConduits(-1);
        boolean hasAdjacent = false;
        for (i = 0; i < 6; ++i) {
            if (allSides[i] == null) continue;
            hasAdjacent = true;
            break;
        }
        if (hasAdjacent) {
            for (i = 0; i < 6; ++i) {
                if (allSides[i] == null || allSides[i].myGrid == null) continue;
                if (this.needsGrid) {
                    this.myGrid = allSides[i].myGrid;
                    this.myGrid.addTile(this);
                    this.needsGrid = false;
                    continue;
                }
                if (!this.canConnectTo(allSides[i])) {
                    allSides[i] = null;
                    continue;
                }
                if (allSides[i].myGrid.contains(this)) continue;
                allSides[i].myGrid.setNewGrid(this.myGrid);
            }
        } else {
            this.myGrid = new GridItem(this.field_70331_k);
            this.myGrid.addTile(this);
            this.needsGrid = false;
        }
        this.placingBlock = false;
    }

    @Override
    public void changeMode(EntityPlayer player, int side) {
        this.mode = (byte)(this.mode + 1);
        this.mode = (byte)(this.mode % 3);
        this.returnedLength = 1;
        if (this.mode == 2 && !this.hasInventory) {
            this.changeMode(player, side);
        }
        if (this.mode == 1) {
            this.returnedLength = 100;
        }
        this.checkConnections();
        this.sendDescPacket();
    }

    @Override
    public boolean wrenchAction(EntityPlayer player, int side) {
        return false;
    }

    @Override
    public void checkConnections() {
        TileEntity[] theReceptors = this.getAdjacentTiles(-1);
        this.hasInventory = false;
        for (int i = 0; i < 6; ++i) {
            if (theReceptors[i] == null) {
                this.sideCache[i] = 0;
                continue;
            }
            if (theReceptors[i] instanceof TileConduitItemBase) {
                if (this.canConnectTo((TileConduitItemBase)theReceptors[i])) {
                    this.sideCache[i] = 1;
                    continue;
                }
                this.sideCache[i] = 0;
                continue;
            }
            if (theReceptors[i] instanceof IInventory) {
                this.sideCache[i] = 3;
                this.hasInventory = true;
                continue;
            }
            this.sideCache[i] = 2;
        }
    }

    @Override
    public void onNeighborBlockChange() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.checkConnections();
        this.sendDescPacket();
    }

    public boolean canConnectTo(TileConduitItemBase theCond) {
        return true;
    }

    public void onChunkUnload() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.myGrid != null) {
            this.myGrid.removeTile(this);
        }
    }

    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.needsGrid && !this.placingBlock) {
            this.updateGridIfNull();
        }
    }

    public void updateConnections() {
        boolean sendUpdate = false;
        for (int i = 0; i < 6; ++i) {
            int[] coords;
            TileEntity theTile;
            if (this.sideCache[i] != 0 || !((theTile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)i))[0], coords[1], coords[2])) instanceof TileConduitItemBase)) continue;
            TileConduitItemBase theCond = (TileConduitItemBase)theTile;
            if (this.myGrid != theCond.myGrid) continue;
            this.sideCache[i] = 1;
            sendUpdate = true;
            theCond.sideCache[i ^ 1] = 1;
            theCond.sendDescPacket();
        }
        if (sendUpdate) {
            this.sendDescPacket();
        }
    }

    public void updateGrid(int from, GridItem theGrid) {
        this.needsGrid = false;
        if (this.myGrid != null) {
            this.myGrid.removeTile(this);
        }
        this.myGrid = theGrid;
        this.myGrid.addTile(this);
        for (int i = 0; i < 6; ++i) {
            int[] coords;
            TileConduitItemBase curCon;
            if (this.sideCache[i] != 1 || (curCon = (TileConduitItemBase)this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)i))[0], coords[1], coords[2])) == null || curCon.conduitInvalid || theGrid.contains(curCon)) continue;
            curCon.updateGrid(i ^ 1, theGrid);
        }
        this.conduitInvalid = false;
    }

    public void updateGridIfNull() {
        if (this.myGrid == null) {
            GridItem newGrid = new GridItem(this.field_70331_k);
            this.updateGrid(-1, newGrid);
        }
    }

    public TileEntity[] getAdjacentTiles(int lastSide) {
        TileEntity[] ret = new TileEntity[6];
        TileEntity curTile = null;
        for (int i = 0; i < 6; ++i) {
            if (i == lastSide) continue;
            curTile = this.field_70331_k.func_72796_p(this.field_70329_l + BlockUtils.SIDE_COORD_MOD[i][0], this.field_70330_m + BlockUtils.SIDE_COORD_MOD[i][1], this.field_70327_n + BlockUtils.SIDE_COORD_MOD[i][2]);
            if (curTile instanceof TileConduitItemBase) {
                if (!this.canConnectTo((TileConduitItemBase)curTile)) continue;
                ret[i] = curTile;
                continue;
            }
            if (!(curTile instanceof IInventory)) continue;
            ret[i] = curTile;
        }
        return ret;
    }

    public TileConduitItemBase[] getAdjacentConduits(int lastSide) {
        TileConduitItemBase[] ret = new TileConduitItemBase[6];
        TileEntity curTile = null;
        for (int i = 0; i < 6; ++i) {
            if (i == lastSide || !((curTile = this.field_70331_k.func_72796_p(this.field_70329_l + BlockUtils.SIDE_COORD_MOD[i][0], this.field_70330_m + BlockUtils.SIDE_COORD_MOD[i][1], this.field_70327_n + BlockUtils.SIDE_COORD_MOD[i][2])) instanceof TileConduitItemBase) || !this.canConnectTo((TileConduitItemBase)curTile)) continue;
            ret[i] = (TileConduitItemBase)curTile;
        }
        return ret;
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
    }

    @Override
    public boolean canTransfer() {
        return false;
    }

    public int getLength() {
        return this.returnedLength;
    }
}

