/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import buildcraft.api.tools.IToolWrench;
import cofh.api.core.IInitializer;
import cofh.render.IconRegistry;
import cofh.util.ColorHelper;
import cofh.util.CoreUtils;
import cofh.util.ItemUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.item.ItemRegistry;
import thermalexpansion.block.BlockTERoot;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.device.TileLamp;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEItems;
import thermalexpansion.liquid.TELiquids;
import thermalexpansion.util.Utils;
import thermalexpansion.util.crafting.TransposerManager;

public class BlockLamp
extends BlockTERoot
implements IInitializer {
    public static boolean enable;
    public static ItemStack lamp;

    public BlockLamp(int id) {
        super(id, Material.field_76264_q);
        this.func_71848_c(3.0f);
        this.func_71894_b(150.0f);
        this.func_71884_a(field_71974_j);
        this.func_71864_b("thermalexpansion.lamp");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileLamp();
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        if (enable) {
            list.add(new ItemStack(itemId, 1, 0));
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        TileLamp theTile = (TileLamp)world.func_72796_p(x, y, z);
        if (theTile == null) {
            return false;
        }
        if (player.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(player, x, y, z)) {
                if (CoreUtils.isServerWorld((World)world)) {
                    this.dismantleBlock(player, world, x, y, z, false);
                    ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
                }
                return true;
            }
            return false;
        }
        if (Utils.isHoldingUsableWrench(player, x, y, z)) {
            if (CoreUtils.isServerWorld((World)world)) {
                theTile.changeMode(player);
                ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            }
            return true;
        }
        if (ItemUtils.isHoldingItem((Item)Item.field_77756_aW, (EntityPlayer)player)) {
            if (CoreUtils.isServerWorld((World)world)) {
                theTile.setColor(ColorHelper.getDyeColor((int)player.func_71045_bC().func_77960_j()));
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)player.func_71045_bC()));
                }
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "note.harp", 0.5f, 1.0f);
            }
            return true;
        }
        if (ItemUtils.isHoldingItem((Item)Item.field_77751_aT, (EntityPlayer)player)) {
            if (CoreUtils.isServerWorld((World)world)) {
                theTile.resetColor();
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.orb", 0.25f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public int func_71856_s_() {
        return 1;
    }

    public int func_71857_b() {
        return TEProps.renderIdLamp;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_71886_c() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)"Lamp0", (String)"thermalexpansion:Lamp_Basic", (IconRegister)ir);
        IconRegistry.addIcon((String)"LiquidLamp", (String)"thermalexpansion:Liquid_Lamp_Still", (IconRegister)ir);
    }

    @Override
    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        TileLamp theTile = (TileLamp)world.func_72796_p(x, y, z);
        NBTTagCompound tag = null;
        if (theTile != null && theTile.modified) {
            tag = new NBTTagCompound();
            tag.func_74757_a("modified", theTile.modified);
            tag.func_74768_a("color", theTile.color);
        }
        return super.dismantleBlock(player, tag, world, x, y, z, returnBlock);
    }

    public void initialize() {
        TileLamp.initialize();
        lamp = new ItemStack(TEBlocks.blockLamp, 1, 0);
        ItemRegistry.registerItem("lamp", lamp);
    }

    public void loadRecipes() {
        if (enable) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TEItems.lampFrame, new Object[]{" Q ", "GRG", " I ", Character.valueOf('G'), TEBlocks.blockGlass, Character.valueOf('I'), "ingotSilver", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('Q'), Item.field_94583_ca}));
            TransposerManager.getInstance().addFillRecipe(200, TEItems.lampFrame, lamp, new LiquidStack(TELiquids.blockGlowstone.field_71990_ca, 1000), false, false);
        }
    }

    static {
        String category = "block.feature";
        enable = ThermalExpansion.config.get(category, "Lamp.Enable", true);
    }
}

