/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileRSControl;
import thermalexpansion.block.device.TileEnergyCell;
import thermalexpansion.util.Utils;
import thermalexpansion.util.energy.IPowerProviderLoss;
import thermalexpansion.util.energy.PowerProviderAdvLoss;

public class TileEnergyRestrictor
extends TileRSControl
implements ITilePacketHandler,
IPowerReceptor {
    PowerProviderAdvLoss myProvider;
    public int[] energySend = new int[6];
    int energyTracker;
    int outputTracker;
    private static int guiId = ThermalExpansion.proxy.registerGui("EnergyRestrictor", true);
    private static int descPacketId = PacketHandler.getAvailablePacketId();
    private static int guiPacketId = PacketHandler.getAvailablePacketId();

    public static void initialize() {
        GameRegistry.registerTileEntity(TileEnergyRestrictor.class, (String)"cofh.thermalexpansion.EnergyRestrictor");
    }

    public TileEnergyRestrictor() {
        this.myProvider = new PowerProviderAdvLoss();
        this.myProvider.configure(0, 2, 500, 0, 1500);
    }

    public Packet func_70319_e() {
        Payload payload = new Payload(2, 0, 6, 0, 0);
        payload.boolPayload[0] = this.redstoneDisable;
        payload.boolPayload[1] = this.redstoneState;
        System.arraycopy(this.energySend, 0, payload.intPayload, 0, this.energySend.length);
        PacketTile packet = new PacketTile(descPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void handleTilePacket(PacketTile packet) {
        this.redstoneDisable = packet.payload.boolPayload[0];
        this.redstoneState = packet.payload.boolPayload[1];
        System.arraycopy(packet.payload.intPayload, 0, this.energySend, 0, this.energySend.length);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.sendUpdatePacket(Side.CLIENT);
    }

    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.redstoneControlOrDisable()) {
            int i;
            for (i = this.outputTracker; i < 6; ++i) {
                this.transferEnergy(i);
            }
            for (i = 0; i < this.outputTracker; ++i) {
                this.transferEnergy(i);
            }
            ++this.outputTracker;
            this.outputTracker %= 6;
        }
    }

    public void setEnergyConfig() {
        this.sendUpdatePacket(Side.SERVER);
    }

    protected void transferEnergy(int side) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)side);
        TileEntity tile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (!(tile instanceof TileEnergyCell)) {
            if (Utils.isPoweredTileLoss(tile)) {
                ForgeDirection sideFD = ForgeDirection.VALID_DIRECTIONS[side].getOpposite();
                IPowerProviderLoss tilePP = (IPowerProviderLoss)((IPowerReceptor)tile).getPowerProvider();
                float powerRequested = ((IPowerReceptor)tile).powerRequest(sideFD);
                if (powerRequested > 0.0f) {
                    float adjustedEnergyRequest = MathHelper.minF((float)powerRequested, (float)((float)tilePP.getMaxEnergyStored() - tilePP.getEnergyStored()));
                    float energyMax = MathHelper.minF((float)adjustedEnergyRequest, (float)this.energySend[side]);
                    float energy = this.myProvider.useEnergy(0.0f, energyMax, true);
                    tilePP.receiveEnergyWithoutLoss(energy, sideFD);
                }
            } else if (Utils.isPoweredTile(tile)) {
                ForgeDirection sideFD = ForgeDirection.VALID_DIRECTIONS[side].getOpposite();
                IPowerProvider tilePP = ((IPowerReceptor)tile).getPowerProvider();
                float powerRequested = ((IPowerReceptor)tile).powerRequest(sideFD);
                if (powerRequested > 0.0f) {
                    float adjustedEnergyRequest = MathHelper.minF((float)powerRequested, (float)((float)tilePP.getMaxEnergyStored() - tilePP.getEnergyStored()));
                    float energyMax = MathHelper.minF((float)adjustedEnergyRequest, (float)this.energySend[side]);
                    float energy = this.myProvider.useEnergy(0.0f, energyMax, true);
                    tilePP.receiveEnergy(energy, sideFD);
                }
            }
        }
    }

    public void receiveGuiNetworkData(int i, int j) {
    }

    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        if (iCrafting instanceof EntityPlayer && CoreUtils.isServerWorld((World)this.field_70331_k)) {
            PacketUtils.sendToPlayer((EntityPlayer)((EntityPlayer)iCrafting), (Packet)this.func_70319_e());
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        try {
            this.myProvider.setEnergyStored(data.func_74760_g("energy.stored"));
            if (Float.isNaN(this.myProvider.getEnergyStored())) {
                this.myProvider.setEnergyStored(0.0f);
            }
        }
        catch (Exception e) {
            this.myProvider.setEnergyStored(0.0f);
        }
        this.energySend = data.func_74759_k("energy.array");
        if (this.energySend.length == 0) {
            this.energySend = new int[]{500, 500, 500, 500, 500, 500};
        }
        this.outputTracker = data.func_74762_e("output");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74776_a("energy.stored", this.myProvider.getEnergyStored());
        data.func_74783_a("energy.array", this.energySend);
        data.func_74768_a("output", this.outputTracker);
    }

    public float getEnergy() {
        return this.myProvider.getEnergyStored();
    }

    public float getMaxEnergy() {
        return this.myProvider.getMaxEnergyStored();
    }

    @Override
    public int getLightValue() {
        return this.redstoneControlOrDisable() ? 7 : 0;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public PowerProvider getPowerProvider() {
        return this.myProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.myProvider.getEnergyStored() == (float)this.myProvider.getMaxEnergyStored()) {
            return 0;
        }
        return MathHelper.ceil((double)MathHelper.minF((float)this.myProvider.getMaxEnergyReceived(), (float)((float)this.myProvider.getMaxEnergyStored() - this.myProvider.getEnergyStored())));
    }
}

