/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.Payload;
import cofh.util.CoreUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import thermalexpansion.block.TileTERoot;

public class TileLamp
extends TileTERoot
implements ITilePacketHandler {
    public boolean modified = false;
    byte mode;
    int lightValue;
    int color = 0xFFFFFF;
    int renderColor = -1431655681;
    private static int descPacketId = PacketHandler.getAvailablePacketId();

    public static void initialize() {
        GameRegistry.registerTileEntity(TileLamp.class, (String)"cofh.thermalexpansion.Lamp");
    }

    public Packet func_70319_e() {
        Payload payload = new Payload(1, 2, 1, 0, 0);
        payload.boolPayload[0] = this.modified;
        payload.bytePayload[0] = this.mode;
        payload.bytePayload[1] = (byte)this.getLightValue();
        payload.intPayload[0] = this.color;
        PacketTile packet = new PacketTile(descPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void handleTilePacket(PacketTile packet) {
        this.modified = packet.payload.boolPayload[0];
        this.color = packet.payload.intPayload[0];
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            this.mode = packet.payload.bytePayload[0];
            this.lightValue = packet.payload.bytePayload[1];
            int colorMod = 10 + this.getLightValue() / 3;
            int red = (this.color >> 16 & 0xFF) * colorMod / 15;
            int green = (this.color >> 8 & 0xFF) * colorMod / 15;
            int blue = (this.color & 0xFF) * colorMod / 15;
            this.renderColor = (red << 24) + (green << 16) + (blue << 8) + 255;
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void changeMode(EntityPlayer player) {
        this.mode = (byte)(this.mode + 1);
        this.mode = (byte)(this.mode % 6);
        this.sendUpdatePacket(Side.CLIENT);
        switch (this.mode) {
            case 0: {
                player.func_70006_a("Mode: Switched; Default: Off");
                return;
            }
            case 1: {
                player.func_70006_a("Mode: Switched; Default: On");
                return;
            }
            case 2: {
                player.func_70006_a("Mode: Scaled (Proportional)");
                return;
            }
            case 3: {
                player.func_70006_a("Mode: Scaled (Inverse)");
                return;
            }
            case 4: {
                player.func_70006_a("Mode: Always Off");
                return;
            }
            case 5: {
                player.func_70006_a("Mode: Always On");
                return;
            }
        }
    }

    public int getColorMultiplier() {
        return this.renderColor;
    }

    public boolean resetColor() {
        if (!this.modified) {
            return false;
        }
        this.modified = false;
        this.color = 0xFFFFFF;
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setColor(int color) {
        this.modified = true;
        this.color = color;
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void onNeighborBlockChange() {
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.modified = data.func_74767_n("modified");
        this.mode = data.func_74771_c("mode");
        this.color = data.func_74762_e("color");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("modified", this.modified);
        data.func_74774_a("mode", this.mode);
        data.func_74768_a("color", this.color);
    }

    @Override
    public int getLightValue() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return this.lightValue;
        }
        switch (this.mode) {
            case 0: {
                return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) ? 15 : 0;
            }
            case 1: {
                return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) ? 0 : 15;
            }
            case 2: {
                return this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            case 3: {
                return 15 - this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }
}

