/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.engine;

import buildcraft.api.tools.IToolWrench;
import cofh.api.core.IInitializer;
import cofh.util.BlockUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.item.ItemRegistry;
import thermalexpansion.block.BlockTERoot;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.engine.Engines;
import thermalexpansion.block.engine.TileEngineMagmatic;
import thermalexpansion.block.engine.TileEngineRoot;
import thermalexpansion.block.engine.TileEngineSteam;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.Utils;

public class BlockEngine
extends BlockTERoot
implements IInitializer {
    public static boolean[] enable = new boolean[Engines.Types.values().length];
    public static ItemStack engineSteam;
    public static ItemStack engineMagmatic;

    public BlockEngine(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(0.5f);
        this.func_71864_b("thermalexpansion.engine");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == Engines.Types.STEAM.ordinal()) {
            return new TileEngineSteam();
        }
        if (metadata == Engines.Types.MAGMATIC.ordinal()) {
            return new TileEngineMagmatic();
        }
        return null;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Engines.Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        Item equipped;
        TileEngineRoot theTile = (TileEngineRoot)world.func_72796_p(x, y, z);
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (!player.func_70093_af() && Utils.isHoldingUsableWrench(player, x, y, z) && theTile.isShutdown) {
            ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            return theTile.repairEngine();
        }
        if (theTile instanceof ITankContainer && Utils.fillTankWithContainer((ITankContainer)theTile, player)) {
            return true;
        }
        return super.func_71903_a(world, x, y, z, player, par6, par7, par8, par9);
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLiving living, ItemStack theStack) {
        TileEngineRoot theTile = (TileEngineRoot)world.func_72796_p(i, j, k);
        if (theTile != null) {
            theTile.setFacing(1);
            theTile.rotateBlock();
        }
    }

    public int func_71857_b() {
        return -1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEngineRoot tile = (TileEngineRoot)world.func_72796_p(x, y, z);
        return tile.facing == BlockUtils.SIDE_OPPOSITE[side.ordinal()];
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71862_a(World world, int x, int y, int z, Random random) {
        TileEngineRoot tile = (TileEngineRoot)world.func_72796_p(x, y, z);
        if (tile.isShutdown) {
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
        }
    }

    public void initialize() {
        TileEngineSteam.initialize();
        TileEngineMagmatic.initialize();
        engineSteam = new ItemStack(TEBlocks.blockEngine, 1, Engines.Types.STEAM.ordinal());
        engineMagmatic = new ItemStack(TEBlocks.blockEngine, 1, Engines.Types.MAGMATIC.ordinal());
        ItemRegistry.registerItem("engineSteam", engineSteam);
        ItemRegistry.registerItem("engineMagmatic", engineMagmatic);
    }

    public void loadRecipes() {
        if (enable[Engines.Types.STEAM.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(engineSteam, new Object[]{"III", " C ", "GPG", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "ingotCopper", Character.valueOf('P'), Block.field_71963_Z}));
        }
        if (enable[Engines.Types.MAGMATIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(engineMagmatic, new Object[]{"III", " C ", "GPG", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "ingotInvar", Character.valueOf('P'), Block.field_71963_Z}));
        }
    }

    static {
        String category = "block.feature";
        BlockEngine.enable[Engines.Types.STEAM.ordinal()] = ThermalExpansion.config.get(category, "Engine.Steam", true);
        BlockEngine.enable[Engines.Types.MAGMATIC.ordinal()] = ThermalExpansion.config.get(category, "Engine.Magmatic", true);
    }
}

