/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.engine;

public class Engines {
    public static final String[] NAMES = new String[]{"steam", "magmatic"};
    public static int[] guiIds = new int[Types.values().length];
    public static final int MAX_LIQUID = 4000;
    public static EngineConfig[] defaultConfigs = new EngineConfig[Types.values().length];

    static {
        int id = Types.STEAM.ordinal();
        Engines.defaultConfigs[id] = new EngineConfig();
        Engines.defaultConfigs[id].minPower = 0.2f;
        Engines.defaultConfigs[id].maxPower = 2;
        Engines.defaultConfigs[id].maxEnergy = 2000;
        Engines.defaultConfigs[id].maxCycleEnergy = 200;
        Engines.defaultConfigs[id].minPowerLevel = 9.0f * (float)Engines.defaultConfigs[id].maxEnergy / 10.0f;
        Engines.defaultConfigs[id].maxPowerLevel = 1.0f * (float)Engines.defaultConfigs[id].maxEnergy / 10.0f;
        Engines.defaultConfigs[id].energyRamp = Engines.defaultConfigs[id].minPowerLevel / (float)Engines.defaultConfigs[id].maxPower;
        id = Types.MAGMATIC.ordinal();
        Engines.defaultConfigs[id] = new EngineConfig();
        Engines.defaultConfigs[id].minPower = 0.4f;
        Engines.defaultConfigs[id].maxPower = 4;
        Engines.defaultConfigs[id].maxEnergy = 4000;
        Engines.defaultConfigs[id].maxCycleEnergy = 400;
        Engines.defaultConfigs[id].minPowerLevel = 9.0f * (float)Engines.defaultConfigs[id].maxEnergy / 10.0f;
        Engines.defaultConfigs[id].maxPowerLevel = 1.0f * (float)Engines.defaultConfigs[id].maxEnergy / 10.0f;
        Engines.defaultConfigs[id].energyRamp = Engines.defaultConfigs[id].minPowerLevel / (float)Engines.defaultConfigs[id].maxPower;
    }

    public static enum Types {
        STEAM,
        MAGMATIC;

    }

    public static class EngineConfig {
        public float minPower;
        public int maxPower;
        public int maxEnergy;
        public int maxCycleEnergy;
        public float minPowerLevel;
        public float maxPowerLevel;
        public float energyRamp;
    }
}

