/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.engine;

import cofh.util.liquid.LiquidRegistry;
import cofh.util.liquid.LiquidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.engine.Engines;
import thermalexpansion.block.engine.TileEngineRoot;
import thermalexpansion.core.TEProps;

public class TileEngineMagmatic
extends TileEngineRoot
implements ITankContainer {
    public static final int ID = Engines.Types.MAGMATIC.ordinal();
    LiquidTankAdv myTank = new LiquidTankAdv(LiquidRegistry.LAVA_ID, 0, 4000);
    static int lavaPerProcess = 50;
    static int energyPerProcess = TEProps.lavaMJ * 90 / 2000;

    public static void initialize() {
        Engines.guiIds[TileEngineMagmatic.ID] = ThermalExpansion.proxy.registerGui("EngineMagmatic", true);
        GameRegistry.registerTileEntityWithAlternatives(TileEngineMagmatic.class, (String)"cofh.thermalexpansion.EngineMagmatic", (String[])new String[]{"thermalexpansion.energy.EngineMagmatic"});
    }

    public TileEngineMagmatic() {
        this.myTank.setLocked(true);
    }

    @Override
    public int getId() {
        return ID;
    }

    public LiquidTankAdv getTank(int tankIndex) {
        return this.myTank;
    }

    @Override
    protected boolean canProcess() {
        if (this.fuelMJ > 0.0f) {
            return true;
        }
        return this.myTank.getLiquidAmount() >= lavaPerProcess;
    }

    @Override
    public void processActive() {
        if (this.fuelMJ <= 0.0f) {
            this.fuelMJ += (float)energyPerProcess;
            this.myTank.adjustLiquid(-lavaPerProcess);
        }
        if (this.fuelMJ > 0.0f) {
            float energyToAdd = this.getPower();
            this.myProvider.addEnergy(energyToAdd);
            this.fuelMJ -= energyToAdd;
        }
        if (this.myProvider.getEnergyStored() >= (float)this.myProvider.getMaxEnergyStored()) {
            this.shutdownEngine();
        }
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.myTank.setLiquidAmount(j);
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.myTank.getLiquidAmount());
        super.sendGuiNetworkData(container, iCrafting);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.myTank.setLiquidAmount(data.func_74762_e("qty.lava"));
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("qty.lava", this.myTank.getLiquidAmount());
    }

    public int getScaledDuration(int scale) {
        return (int)(this.fuelMJ * (float)scale / (float)energyPerProcess);
    }

    public int getScaledLiquid(int id, int scale) {
        if (id == LiquidRegistry.LAVA_ID) {
            if (this.myTank.getLiquidAmount() >= 4000) {
                return scale;
            }
            return this.myTank.getLiquidAmount() * scale / 4000;
        }
        return 0;
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return 0;
        }
        return this.myTank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.myTank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.myTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UNKNOWN || direction.ordinal() == this.facing) {
            return null;
        }
        return this.myTank;
    }
}

