/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.engine;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import buildcraft.api.transport.IPipeConnection;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileInventory;
import thermalexpansion.block.engine.Engines;
import thermalexpansion.gui.element.IInfoPower;
import thermalexpansion.util.Utils;
import thermalexpansion.util.energy.IPowerProviderLoss;
import thermalexpansion.util.energy.PowerProviderAdv;

public abstract class TileEngineRoot
extends TileInventory
implements ITilePacketHandler,
IPipeConnection,
IPowerReceptor,
IReconfigurableFacing,
IInfoPower {
    byte facing;
    Engines.EngineConfig config = Engines.defaultConfigs[this.getId()];
    PowerProviderAdv myProvider = new PowerProviderAdv();
    public boolean isActive;
    public boolean isShutdown;
    boolean canCycle;
    boolean stageCycle;
    float fuelMJ;
    float cycleProgress;
    private static int descPacketId = PacketHandler.getAvailablePacketId();
    private static int guiPacketId = PacketHandler.getAvailablePacketId();

    public TileEngineRoot() {
        this.myProvider.configure(this.config.maxCycleEnergy / 2, this.config.maxEnergy);
    }

    public Packet func_70319_e() {
        Payload payload = new Payload(5, 1, 0, 2, 0);
        payload.boolPayload[0] = this.canCycle();
        payload.boolPayload[1] = this.isActive;
        payload.boolPayload[2] = this.isShutdown;
        payload.boolPayload[3] = this.redstoneDisable;
        payload.boolPayload[4] = this.redstoneState;
        payload.bytePayload[0] = this.facing;
        payload.floatPayload[0] = this.fuelMJ;
        payload.floatPayload[1] = this.myProvider.getEnergyStored();
        PacketTile packet = new PacketTile(descPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public Packet getGuiPacket() {
        Payload payload = new Payload(2, 0, 0, 2, 0);
        payload.boolPayload[0] = this.redstoneDisable;
        payload.boolPayload[1] = this.redstoneState;
        payload.floatPayload[0] = this.fuelMJ;
        payload.floatPayload[1] = this.myProvider.getEnergyStored();
        PacketTile packet = new PacketTile(guiPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void handleTilePacket(PacketTile packet) {
        if (packet.getPacketId() == descPacketId) {
            this.canCycle = packet.payload.boolPayload[0];
            this.isActive = packet.payload.boolPayload[1];
            this.isShutdown = packet.payload.boolPayload[2];
            this.redstoneDisable = packet.payload.boolPayload[3];
            this.redstoneState = packet.payload.boolPayload[4];
            this.facing = packet.payload.bytePayload[0];
            this.fuelMJ = packet.payload.floatPayload[0];
            this.myProvider.setEnergyStored(packet.payload.floatPayload[1]);
            if (this.isShutdown) {
                this.cycleProgress = 0.25f;
            }
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.sendUpdatePacket(Side.CLIENT);
        } else if (packet.getPacketId() == guiPacketId) {
            this.redstoneDisable = packet.payload.boolPayload[0];
            this.redstoneState = packet.payload.boolPayload[1];
            this.fuelMJ = packet.payload.floatPayload[0];
            this.myProvider.setEnergyStored(packet.payload.floatPayload[1]);
        }
    }

    protected abstract boolean canProcess();

    protected abstract void processActive();

    protected boolean canCycle() {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)this.facing);
        TileEntity tile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        this.canCycle = tile != null && tile instanceof IPowerReceptor;
        return this.canCycle;
    }

    public void shutdownEngine() {
        this.isActive = false;
        this.isShutdown = true;
        this.fuelMJ = 0.0f;
        this.myProvider.setEnergyStored(this.myProvider.getEnergyStored() * 0.8f);
    }

    protected void transferEnergy() {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)this.facing);
        TileEntity tile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (Utils.isPoweredTileLoss(tile)) {
            IPowerProviderLoss tilePP = (IPowerProviderLoss)((IPowerReceptor)tile).getPowerProvider();
            float adjustedEnergyRequest = MathHelper.maxF((float)((IPowerReceptor)tile).powerRequest(ForgeDirection.VALID_DIRECTIONS[this.facing].getOpposite()), (float)(25.0f * this.config.minPower));
            float energyMax = MathHelper.minF((float)adjustedEnergyRequest, (float)this.config.maxCycleEnergy);
            float energy = this.myProvider.useEnergy(0.0f, energyMax, true);
            tilePP.receiveEnergyWithoutLoss(energy, ForgeDirection.VALID_DIRECTIONS[this.facing].getOpposite());
        } else if (Utils.isPoweredTile(tile)) {
            IPowerProvider tilePP = ((IPowerReceptor)tile).getPowerProvider();
            float energyMax = MathHelper.minF((float)((float)tilePP.getMaxEnergyStored() - tilePP.getEnergyStored()), (float)this.config.maxCycleEnergy);
            float energy = this.myProvider.useEnergy(0.0f, energyMax, true);
            tilePP.receiveEnergy(energy, ForgeDirection.VALID_DIRECTIONS[this.facing].getOpposite());
        }
    }

    public boolean repairEngine() {
        this.isShutdown = false;
        this.cycleProgress = 0.0f;
        return true;
    }

    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            if (this.isShutdown) {
                return;
            }
            if (this.cycleProgress > 0.0f || this.isActive && this.canCycle) {
                this.cycleProgress += 0.04f;
                if (this.cycleProgress >= 1.0f) {
                    this.cycleProgress = 0.0f;
                }
            }
            return;
        }
        if (this.isShutdown) {
            this.myProvider.subtractEnergy(this.config.minPower);
            return;
        }
        if (this.cycleProgress > 0.0f || this.isActive && this.canCycle) {
            this.cycleProgress += 0.04f;
            if (this.cycleProgress >= 1.0f) {
                this.cycleProgress = 0.0f;
                this.stageCycle = false;
            } else if ((double)this.cycleProgress >= 0.5 && !this.stageCycle) {
                this.transferEnergy();
                this.stageCycle = true;
            }
        }
        boolean curActive = this.isActive;
        boolean curCycle = this.canCycle;
        if (this.redstoneControlOrDisable() && this.canCycle()) {
            if (this.canProcess()) {
                this.isActive = true;
                this.processActive();
            } else {
                this.isActive = false;
            }
        } else {
            this.isActive = false;
        }
        if (!this.isActive) {
            this.myProvider.subtractEnergy(this.config.minPower);
            if (this.field_70331_k.func_72820_D() % 40L == 0L && this.fuelMJ > 0.0f) {
                this.fuelMJ -= 10.0f;
                if (this.fuelMJ < 0.0f) {
                    this.fuelMJ = 0.0f;
                }
            }
        }
        if (curActive != this.isActive || curCycle != this.canCycle || this.isShutdown) {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public void receiveGuiNetworkData(int i, int j) {
    }

    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        if (iCrafting instanceof EntityPlayer && CoreUtils.isServerWorld((World)this.field_70331_k)) {
            PacketUtils.sendToPlayer((EntityPlayer)((EntityPlayer)iCrafting), (Packet)this.getGuiPacket());
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        try {
            this.myProvider.setEnergyStored(data.func_74760_g("energy.stored"));
            if (Float.isNaN(this.myProvider.getEnergyStored())) {
                this.myProvider.setEnergyStored(0.0f);
            }
        }
        catch (Exception e) {
            this.myProvider.setEnergyStored(0.0f);
        }
        this.facing = data.func_74771_c("side.facing");
        this.isActive = data.func_74767_n("flag.active");
        this.isShutdown = data.func_74767_n("flag.shutdown");
        this.fuelMJ = data.func_74760_g("qty.fuel");
        this.canCycle = data.func_74767_n("flag.cycle");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74776_a("energy.stored", this.myProvider.getEnergyStored());
        data.func_74774_a("side.facing", this.facing);
        data.func_74757_a("flag.active", this.isActive);
        data.func_74757_a("flag.shutdown", this.isShutdown);
        data.func_74776_a("qty.fuel", this.fuelMJ);
        data.func_74757_a("flag.cycle", this.canCycle);
    }

    public int getScaledPowerOutput(int scale) {
        return (int)(this.getPower() * 10.0f * (float)scale / (float)(this.config.maxPower * 10));
    }

    public int getScaledEnergyStored(int scale) {
        return (int)(this.myProvider.getEnergyStored() * (float)scale / (float)this.myProvider.getMaxEnergyStored());
    }

    public abstract int getId();

    public float getCycleProgress() {
        return this.cycleProgress;
    }

    @Override
    public int getLightValue() {
        return this.isActive ? 7 : 0;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, Engines.guiIds[this.getId()], this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public String func_70303_b() {
        return "engine." + Engines.NAMES[this.getId()];
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return with.ordinal() != this.facing;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public PowerProvider getPowerProvider() {
        return this.myProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return 0;
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean rotateBlock() {
        for (int i = this.facing + 1; i < this.facing + 6; ++i) {
            int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)(i % 6));
            TileEntity tile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
            if (!Utils.isPoweredTile(tile)) continue;
            this.facing = (byte)(i % 6);
            this.sendUpdatePacket(Side.CLIENT);
            return true;
        }
        return false;
    }

    public boolean setFacing(int side) {
        if (side >= 0 && side < 6) {
            this.facing = (byte)side;
            return true;
        }
        return false;
    }

    public boolean setFacing(ForgeDirection side) {
        return this.setFacing(side.ordinal());
    }

    @Override
    public float getPower() {
        if (!this.isActive || this.isShutdown) {
            return 0.0f;
        }
        if (this.myProvider.getEnergyStored() < this.config.maxPowerLevel) {
            return this.config.maxPower;
        }
        if (this.myProvider.getEnergyStored() > this.config.minPowerLevel) {
            return this.config.minPower;
        }
        int intPower = (int)(10.0f * ((float)this.myProvider.getMaxEnergyStored() - this.myProvider.getEnergyStored()) / this.config.energyRamp);
        return (float)intPower / 10.0f;
    }

    @Override
    public float getMaxPower() {
        return this.config.maxPower;
    }

    @Override
    public float getEnergy() {
        return this.myProvider.getEnergyStored();
    }

    @Override
    public float getMaxEnergy() {
        return this.config.maxEnergy;
    }
}

