/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.engine;

import cofh.util.liquid.LiquidRegistry;
import cofh.util.liquid.LiquidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.engine.Engines;
import thermalexpansion.block.engine.TileEngineRoot;

public class TileEngineSteam
extends TileEngineRoot
implements ITankContainer {
    public static final int ID = Engines.Types.STEAM.ordinal();
    static ItemStack coal = new ItemStack(Item.field_77705_m, 1, 0);
    static ItemStack charcoal = new ItemStack(Item.field_77705_m, 1, 1);
    LiquidTankAdv myTank = new LiquidTankAdv(LiquidRegistry.WATER_ID, 0, 4000);
    int currentFuelMJ = 4800;

    public static void initialize() {
        Engines.guiIds[TileEngineSteam.ID] = ThermalExpansion.proxy.registerGui("EngineSteam", true);
        GameRegistry.registerTileEntityWithAlternatives(TileEngineSteam.class, (String)"cofh.thermalexpansion.EngineSteam", (String[])new String[]{"thermalexpansion.energy.EngineSteam"});
    }

    public TileEngineSteam() {
        this.myTank.setLocked(true);
        this.inventory = new ItemStack[1];
    }

    @Override
    public int getId() {
        return ID;
    }

    public LiquidTankAdv getTank(int tankIndex) {
        return this.myTank;
    }

    public static int getItemEnergyValue(ItemStack fuel) {
        if (fuel == null) {
            return 0;
        }
        if (fuel.func_77969_a(coal)) {
            return 4800;
        }
        if (fuel.func_77969_a(charcoal)) {
            return 3200;
        }
        int itemId = fuel.func_77973_b().field_77779_bT;
        if (fuel.func_77973_b() instanceof ItemBlock && Block.field_71973_m[itemId].field_72018_cp == Material.field_76245_d) {
            return 450;
        }
        if (itemId == Item.field_77669_D.field_77779_bT) {
            return 150;
        }
        if (itemId == Block.field_71987_y.field_71990_ca) {
            return 150;
        }
        return GameRegistry.getFuelValue((ItemStack)fuel) * 3 / 2;
    }

    @Override
    protected boolean canProcess() {
        if (this.fuelMJ > 0.0f) {
            return true;
        }
        if (this.inventory[0] == null) {
            return false;
        }
        int fuel = TileEngineSteam.getItemEnergyValue(this.inventory[0]);
        if (fuel <= 0) {
            return false;
        }
        return this.myTank.getLiquidAmount() >= 20;
    }

    @Override
    public void processActive() {
        if (this.fuelMJ <= 0.0f) {
            this.fuelMJ += (float)TileEngineSteam.getItemEnergyValue(this.inventory[0]);
            this.currentFuelMJ = TileEngineSteam.getItemEnergyValue(this.inventory[0]);
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
        if (this.fuelMJ > 0.0f) {
            float energyToAdd = this.getPower();
            this.myProvider.addEnergy(energyToAdd);
            this.fuelMJ -= energyToAdd;
            if (this.field_70331_k.func_72820_D() % 40L == 0L) {
                this.myTank.adjustLiquid((int)(-this.getPower() * 10.0f));
            }
        }
        if (this.myProvider.getEnergyStored() >= (float)this.myProvider.getMaxEnergyStored() || this.myTank.getLiquidAmount() < 20) {
            this.shutdownEngine();
        }
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.myTank.setLiquidAmount(j);
                return;
            }
            case 1: {
                this.currentFuelMJ = j;
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.myTank.getLiquidAmount());
        iCrafting.func_71112_a(container, 1, this.currentFuelMJ);
        super.sendGuiNetworkData(container, iCrafting);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.myTank.setLiquidAmount(data.func_74762_e("qty.water"));
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("qty.water", this.myTank.getLiquidAmount());
    }

    public int getScaledDuration(int scale) {
        return (int)(this.fuelMJ * (float)scale / (float)this.currentFuelMJ);
    }

    public int getScaledLiquid(int id, int scale) {
        if (id == LiquidRegistry.WATER_ID) {
            if (this.myTank.getLiquidAmount() >= 4000) {
                return scale;
            }
            return this.myTank.getLiquidAmount() * scale / 4000;
        }
        return 0;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return 0;
        }
        return this.myTank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.myTank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.myTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UNKNOWN || direction.ordinal() == this.facing) {
            return null;
        }
        return this.myTank;
    }
}

