/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.api.core.IInitializer;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.ISidedBlockTexture;
import cofh.render.IconRegistry;
import cofh.util.CoreUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.item.ItemRegistry;
import thermalexpansion.block.BlockTERoot;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileAssembler;
import thermalexpansion.block.machine.TileCharger;
import thermalexpansion.block.machine.TileCrucible;
import thermalexpansion.block.machine.TileFurnace;
import thermalexpansion.block.machine.TileIceGen;
import thermalexpansion.block.machine.TilePulverizer;
import thermalexpansion.block.machine.TileRockGen;
import thermalexpansion.block.machine.TileSawmill;
import thermalexpansion.block.machine.TileSmelter;
import thermalexpansion.block.machine.TileTransposer;
import thermalexpansion.block.machine.TileWaterGen;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.Utils;

public class BlockMachine
extends BlockTERoot
implements IInitializer {
    public static boolean[] enable = new boolean[Machines.Types.values().length];
    public static int renderPass = 0;
    public static final String TEXTURE_DEFAULT = "SideConfig_";
    public static final String TEXTURE_CB = "SideConfig_CB_";
    public static String textureSelection;
    public static ItemStack furnace;
    public static ItemStack pulverizer;
    public static ItemStack sawmill;
    public static ItemStack smelter;
    public static ItemStack crucible;
    public static ItemStack transposer;
    public static ItemStack iceGen;
    public static ItemStack rockGen;
    public static ItemStack waterGen;
    public static ItemStack assembler;
    public static ItemStack charger;

    public BlockMachine(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(15.0f);
        this.func_71894_b(25.0f);
        this.func_71864_b("thermalexpansion.machine");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == Machines.Types.FURNACE.ordinal()) {
            return new TileFurnace();
        }
        if (metadata == Machines.Types.PULVERIZER.ordinal()) {
            return new TilePulverizer();
        }
        if (metadata == Machines.Types.SAWMILL.ordinal()) {
            return new TileSawmill();
        }
        if (metadata == Machines.Types.SMELTER.ordinal()) {
            return new TileSmelter();
        }
        if (metadata == Machines.Types.CRUCIBLE.ordinal()) {
            return new TileCrucible();
        }
        if (metadata == Machines.Types.TRANSPOSER.ordinal()) {
            return new TileTransposer();
        }
        if (metadata == Machines.Types.ICE_GEN.ordinal()) {
            return new TileIceGen();
        }
        if (metadata == Machines.Types.ROCK_GEN.ordinal()) {
            return new TileRockGen();
        }
        if (metadata == Machines.Types.WATER_GEN.ordinal()) {
            return new TileWaterGen();
        }
        if (metadata == Machines.Types.ASSEMBLER.ordinal()) {
            return new TileAssembler();
        }
        if (metadata == Machines.Types.CHARGER.ordinal()) {
            return new TileCharger();
        }
        return null;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Machines.Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity theTile = world.func_72796_p(x, y, z);
        if ((theTile instanceof TileRockGen || theTile instanceof TileIceGen) && Utils.fillTankWithContainer((ITankContainer)theTile, player)) {
            return true;
        }
        return super.func_71903_a(world, x, y, z, player, par6, par7, par8, par9);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack theItem) {
        IReconfigurableFacing theTile = (IReconfigurableFacing)world.func_72796_p(x, y, z);
        if (theTile != null) {
            int quadrant = MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (quadrant) {
                case 0: {
                    theTile.setFacing(2);
                    return;
                }
                case 1: {
                    theTile.setFacing(5);
                    return;
                }
                case 2: {
                    theTile.setFacing(3);
                    return;
                }
                case 3: {
                    theTile.setFacing(4);
                    return;
                }
            }
        }
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        ISidedBlockTexture theTile = (ISidedBlockTexture)world.func_72796_p(x, y, z);
        return theTile == null ? null : theTile.getBlockTexture(side, renderPass);
    }

    @Override
    public Icon func_71858_a(int side, int metadata) {
        if (side == 0) {
            return IconRegistry.getIcon((String)"MachineBottom");
        }
        if (side == 1) {
            return IconRegistry.getIcon((String)"MachineTop");
        }
        return side != 3 ? IconRegistry.getIcon((String)"MachineSide") : IconRegistry.getIcon((String)("MachineFace_" + metadata));
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public int func_71856_s_() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)"MachineBottom", (String)"thermalexpansion:Machine_Bottom", (IconRegister)ir);
        IconRegistry.addIcon((String)"MachineTop", (String)"thermalexpansion:Machine_Top", (IconRegister)ir);
        IconRegistry.addIcon((String)"MachineSide", (String)"thermalexpansion:Machine_Side", (IconRegister)ir);
        for (int i = 0; i < Machines.Types.values().length; ++i) {
            IconRegistry.addIcon((String)("MachineFace_" + i), (String)("thermalexpansion:Machine_Face_" + CoreUtils.titleCase((String)Machines.NAMES[i])), (IconRegister)ir);
            IconRegistry.addIcon((String)("MachineActive_" + i), (String)("thermalexpansion:Machine_Active_" + CoreUtils.titleCase((String)Machines.NAMES[i])), (IconRegister)ir);
        }
        IconRegistry.addIcon((String)"SideConfig_0", (String)"thermalexpansion:Config_None", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_1", (String)"thermalexpansion:Config_Blue", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_2", (String)"thermalexpansion:Config_Red", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_3", (String)"thermalexpansion:Config_Yellow", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_4", (String)"thermalexpansion:Config_Orange", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_5", (String)"thermalexpansion:Config_Green", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_6", (String)"thermalexpansion:Config_Purple", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_CB_0", (String)"thermalexpansion:Config_None", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_CB_1", (String)"thermalexpansion:Config_Blue_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_CB_2", (String)"thermalexpansion:Config_Red_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_CB_3", (String)"thermalexpansion:Config_Yellow_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_CB_4", (String)"thermalexpansion:Config_Orange_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_CB_5", (String)"thermalexpansion:Config_Green_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"SideConfig_CB_6", (String)"thermalexpansion:Config_Purple_CB", (IconRegister)ir);
    }

    public void initialize() {
        TileFurnace.initialize();
        TilePulverizer.initialize();
        TileSawmill.initialize();
        TileSmelter.initialize();
        TileCrucible.initialize();
        TileTransposer.initialize();
        TileIceGen.initialize();
        TileRockGen.initialize();
        TileWaterGen.initialize();
        TileAssembler.initialize();
        TileCharger.initialize();
        furnace = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.FURNACE.ordinal());
        pulverizer = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.PULVERIZER.ordinal());
        sawmill = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.SAWMILL.ordinal());
        smelter = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.SMELTER.ordinal());
        crucible = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.CRUCIBLE.ordinal());
        transposer = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.TRANSPOSER.ordinal());
        iceGen = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.ICE_GEN.ordinal());
        rockGen = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.ROCK_GEN.ordinal());
        waterGen = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.WATER_GEN.ordinal());
        assembler = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.ASSEMBLER.ordinal());
        charger = new ItemStack(TEBlocks.blockMachine, 1, Machines.Types.CHARGER.ordinal());
        ItemRegistry.registerItem("furnace", furnace);
        ItemRegistry.registerItem("pulverizer", pulverizer);
        ItemRegistry.registerItem("sawmill", sawmill);
        ItemRegistry.registerItem("smelter", smelter);
        ItemRegistry.registerItem("crucible", crucible);
        ItemRegistry.registerItem("transposer", transposer);
        ItemRegistry.registerItem("iceGen", iceGen);
        ItemRegistry.registerItem("rockGen", rockGen);
        ItemRegistry.registerItem("waterGen", waterGen);
        ItemRegistry.registerItem("assembler", assembler);
        ItemRegistry.registerItem("charger", charger);
    }

    public void loadRecipes() {
        boolean machineFrameUseSteel = false;
        boolean machinesUseGears = false;
        boolean[] expensiveRecipe = new boolean[Machines.Types.values().length];
        String category = "tweak.recipe";
        machineFrameUseSteel = ThermalExpansion.config.get(category, "MachineFrame.UseSteel", false);
        machinesUseGears = ThermalExpansion.config.get(category, "Machines.UseGears", false);
        expensiveRecipe[Machines.Types.PULVERIZER.ordinal()] = ThermalExpansion.config.get(category, "Pulverizer.AddDiamonds", false);
        expensiveRecipe[Machines.Types.SMELTER.ordinal()] = ThermalExpansion.config.get(category, "Smelter.AddDiamonds", false);
        String copperPart = "ingotCopper";
        String tinPart = "ingotTin";
        if (machinesUseGears) {
            copperPart = "gearCopper";
            tinPart = "gearTin";
        }
        if (machineFrameUseSteel && OreDictionary.getOres((String)"ingotSteel").size() > 0) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TEItems.machineFrame, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotSteel", Character.valueOf('G'), Block.field_71946_M, Character.valueOf('X'), Item.field_77717_p}));
        } else {
            GameRegistry.addRecipe((ItemStack)TEItems.machineFrame, (Object[])new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('G'), Block.field_71946_M, Character.valueOf('X'), Item.field_77717_p});
        }
        if (enable[Machines.Types.FURNACE.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(furnace, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77767_aC, Character.valueOf('Y'), Block.field_72081_al}));
        }
        if (enable[Machines.Types.PULVERIZER.ordinal()]) {
            if (expensiveRecipe[Machines.Types.PULVERIZER.ordinal()]) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pulverizer, new Object[]{"DXD", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Block.field_71963_Z, Character.valueOf('Y'), Item.field_77804_ap, Character.valueOf('D'), Item.field_77702_n}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pulverizer, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Block.field_71963_Z, Character.valueOf('Y'), Item.field_77804_ap}));
            }
        }
        if (enable[Machines.Types.SAWMILL.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(sawmill, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77708_h, Character.valueOf('Y'), "plankWood"}));
        }
        if (enable[Machines.Types.SMELTER.ordinal()]) {
            if (expensiveRecipe[Machines.Types.SMELTER.ordinal()]) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(smelter, new Object[]{"DXD", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77788_aw, Character.valueOf('Y'), "ingotInvar", Character.valueOf('D'), Item.field_77702_n}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(smelter, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77788_aw, Character.valueOf('Y'), "ingotInvar"}));
            }
        }
        if (enable[Machines.Types.CRUCIBLE.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(crucible, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77788_aw, Character.valueOf('Y'), Block.field_72033_bA}));
        }
        if (enable[Machines.Types.TRANSPOSER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(transposer, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77788_aw, Character.valueOf('Y'), Block.field_71946_M}));
        }
        if (enable[Machines.Types.ICE_GEN.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(iceGen, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Block.field_71963_Z, Character.valueOf('Y'), Block.field_72039_aU}));
        }
        if (enable[Machines.Types.ROCK_GEN.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(rockGen, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), tinPart, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), Block.field_71963_Z, Character.valueOf('Y'), Block.field_71946_M}));
        }
        if (enable[Machines.Types.WATER_GEN.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(waterGen, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), tinPart, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), Item.field_77788_aw, Character.valueOf('Y'), Block.field_71946_M}));
        }
        if (enable[Machines.Types.ASSEMBLER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(assembler, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Block.field_72077_au, Character.valueOf('Y'), "gearTin"}));
        }
        if (enable[Machines.Types.CHARGER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(charger, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), TEItems.machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), "ingotPlatinum", Character.valueOf('Y'), TEItems.powerCoilSilver}));
        }
    }

    static {
        String category = "block.feature";
        BlockMachine.enable[Machines.Types.FURNACE.ordinal()] = ThermalExpansion.config.get(category, "Machine.Furnace", true);
        BlockMachine.enable[Machines.Types.PULVERIZER.ordinal()] = ThermalExpansion.config.get(category, "Machine.Pulverizer", true);
        BlockMachine.enable[Machines.Types.SAWMILL.ordinal()] = ThermalExpansion.config.get(category, "Machine.Sawmill", true);
        BlockMachine.enable[Machines.Types.SMELTER.ordinal()] = ThermalExpansion.config.get(category, "Machine.smelter", true);
        BlockMachine.enable[Machines.Types.CRUCIBLE.ordinal()] = ThermalExpansion.config.get(category, "Machine.Crucible", true);
        BlockMachine.enable[Machines.Types.TRANSPOSER.ordinal()] = ThermalExpansion.config.get(category, "Machine.Transposer", true);
        BlockMachine.enable[Machines.Types.ICE_GEN.ordinal()] = ThermalExpansion.config.get(category, "Machine.IceGen", true);
        BlockMachine.enable[Machines.Types.ROCK_GEN.ordinal()] = ThermalExpansion.config.get(category, "Machine.RockGen", true);
        BlockMachine.enable[Machines.Types.WATER_GEN.ordinal()] = ThermalExpansion.config.get(category, "Machine.WaterGen", true);
        BlockMachine.enable[Machines.Types.ASSEMBLER.ordinal()] = ThermalExpansion.config.get(category, "Machine.AutoCrafter", true);
        BlockMachine.enable[Machines.Types.CHARGER.ordinal()] = ThermalExpansion.config.get(category, "Machine.Charger", true);
        textureSelection = TEXTURE_DEFAULT;
    }
}

